/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String UTF_8 = "UTF-8";
    static final String NOT_PROVIDED = "Not provided";
    static final String FAILED = "Failed to retrieveLoadedStubs response content using relative path specified in 'file' during YAML parse time. Check terminal for warnings, and that response content exists in relative path specified in 'file'";
    private static final CharsetEncoder US_ASCII_ENCODER = Charset.forName("US-ASCII").newEncoder();
    private static final String TEMPLATE_TOKEN_LEFT = "<%";
    private static final String TEMPLATE_TOKEN_RIGHT = "%>";
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getEncoder();

    private StringUtils() {
    }

    public static boolean isSet(String toTest) {
        return ObjectUtils.isNotNull(toTest) && toTest.trim().length() > 0;
    }

    public static String trimIfSet(String toTest) {
        return StringUtils.isSet(toTest) ? toTest.trim() : toTest;
    }

    public static boolean isNotSet(String toTest) {
        return !StringUtils.isSet(toTest);
    }

    public static String toUpper(String toUpper) {
        if (StringUtils.isNotSet(toUpper)) {
            return "";
        }
        return toUpper.toUpperCase(Locale.US);
    }

    public static String toLower(String toLower) {
        if (StringUtils.isNotSet(toLower)) {
            return "";
        }
        return toLower.toLowerCase(Locale.US);
    }

    public static Charset charsetUTF8() {
        return Charset.forName(UTF_8);
    }

    public static String newStringUtf8(byte[] bytes) {
        return new String(bytes, StringUtils.charsetUTF8());
    }

    public static byte[] getBytesUtf8(String string) {
        return string.getBytes(StringUtils.charsetUTF8());
    }

    public static String inputStreamToString(InputStream inputStream) {
        if (ObjectUtils.isNull(inputStream)) {
            return "Could not convert null input stream to string";
        }
        if (inputStream instanceof BufferedInputStream) {
            return new Scanner(inputStream, UTF_8).useDelimiter("\\A").next().trim();
        }
        return new Scanner(FileUtils.makeBuffered(inputStream), UTF_8).useDelimiter("\\A").next().trim();
    }

    public static String buildToken(String propertyName, int capturingGroupIdx) {
        return String.format("%s.%s", propertyName, capturingGroupIdx);
    }

    public static String replaceTokens(byte[] stringBytes, Map<String, String> tokensAndValues) {
        return StringUtils.replaceTokensInString(StringUtils.newStringUtf8(stringBytes), tokensAndValues);
    }

    public static String replaceTokensInString(String template, Map<String, String> tokensAndValues) {
        for (Map.Entry<String, String> entry : tokensAndValues.entrySet()) {
            String regexifiedKey = String.format("%s\\s{0,}%s\\s{0,}%s", TEMPLATE_TOKEN_LEFT, entry.getKey(), TEMPLATE_TOKEN_RIGHT);
            template = template.replaceAll(regexifiedKey, entry.getValue());
        }
        return template;
    }

    public static boolean isTokenized(String target) {
        return target.contains(TEMPLATE_TOKEN_LEFT);
    }

    public static String escapeHtmlEntities(String toBeEscaped) {
        return toBeEscaped.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String escapeSpecialRegexCharacters(String toEscape) {
        return toEscape.replaceAll(Pattern.quote("{"), "\\\\{").replaceAll(Pattern.quote("}"), "\\\\}").replaceAll(Pattern.quote("["), "\\\\[").replaceAll(Pattern.quote("]"), "\\\\]");
    }

    @CoberturaIgnore
    public static String constructUserAgentName() {
        Package pkg = StringUtils.class.getPackage();
        String implementationVersion = StringUtils.isSet(pkg.getImplementationVersion()) ? pkg.getImplementationVersion() : "x.x.xx";
        return String.format("stubby4j/%s (HTTP stub client request)", implementationVersion);
    }

    public static String encodeBase64(String toEncode) {
        return BASE_64_ENCODER.encodeToString(StringUtils.getBytesUtf8(toEncode));
    }

    public static int calculateStringLength(String post) {
        if (StringUtils.isSet(post)) {
            return StringUtils.getBytesUtf8(post).length;
        }
        return 0;
    }

    public static String objectToString(Object fieldObject) {
        if (ObjectUtils.isNull(fieldObject)) {
            return NOT_PROVIDED;
        }
        if (fieldObject instanceof byte[]) {
            byte[] objectBytes = (byte[])fieldObject;
            String toTest = StringUtils.newStringUtf8(objectBytes);
            if (!StringUtils.isUSAscii(toTest)) {
                return "Loaded file is binary - it's content is not displayable";
            }
            if (toTest.equals(FAILED)) {
                return FAILED;
            }
            try {
                return new String(objectBytes, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                return new String(objectBytes);
            }
        }
        String valueAsStr = fieldObject.toString().trim();
        return !valueAsStr.equalsIgnoreCase("null") ? valueAsStr : "";
    }

    static String join(String[] segments, String delimiter) {
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (String segment : segments) {
            stringJoiner.add(segment);
        }
        return stringJoiner.toString();
    }

    static String repeat(String repeatable, int times) {
        if (StringUtils.isNotSet(repeatable) || times < 0) {
            return "";
        }
        return new String(new char[times]).replace("\u0000", repeatable);
    }

    static String decodeUrlEncodedQuotes(String toBeFiltered) {
        return toBeFiltered.replaceAll("%22", "\"").replaceAll("%27", "'");
    }

    static String encodeSingleQuotes(String toBeEncoded) {
        return toBeEncoded.replaceAll("'", "%27");
    }

    static String extractFilenameExtension(String filename) {
        int dotLocation = filename.lastIndexOf(46);
        return filename.substring(dotLocation);
    }

    static String trimSpacesBetweenCSVElements(String toBeFiltered) {
        return toBeFiltered.replaceAll("\",\\s+\"", "\",\"").replaceAll(",\\s+", ",");
    }

    static String removeSquareBrackets(String toBeFiltered) {
        return toBeFiltered.replaceAll("%5B|%5D|\\[|]", "");
    }

    static boolean isWithinSquareBrackets(String toCheck) {
        return toCheck.startsWith("%5B") && toCheck.endsWith("%5D") || toCheck.startsWith("[") && toCheck.endsWith("]");
    }

    static String decodeUrlEncoded(String toCheck) {
        if (toCheck.contains("%2B")) {
            return toCheck.replaceAll("%2B", " ").replaceAll("\\s+", " ");
        }
        if (toCheck.contains("%20")) {
            return toCheck.replaceAll("%20", " ").replaceAll("\\s+", " ");
        }
        if (toCheck.contains("+")) {
            return toCheck.replaceAll(Pattern.quote("+"), " ").replaceAll("\\s+", " ");
        }
        return toCheck;
    }

    static String pluralize(long timeUnit) {
        return timeUnit == 1L ? "" : "s";
    }

    private static boolean isUSAscii(String toTest) {
        return US_ASCII_ENCODER.canEncode(toTest);
    }
}

