/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.client.StubbyResponse;
import io.github.azagniotov.stubby4j.http.StubbyHttpTransport;
import io.github.azagniotov.stubby4j.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import io.github.azagniotov.stubby4j.stubs.StubSearchResult;
import io.github.azagniotov.stubby4j.utils.CollectionUtils;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.ReflectionUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.ConfigurableYAMLProperty;
import io.github.azagniotov.stubby4j.yaml.YAMLParser;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;

public class StubRepository {
    private final File configFile;
    private final List<StubHttpLifecycle> stubs = new ArrayList<StubHttpLifecycle>();
    private final Future<List<StubHttpLifecycle>> stubLoadComputation;
    private final StubbyHttpTransport stubbyHttpTransport;
    private final ConcurrentHashMap<String, AtomicLong> resourceStats;
    private final ConcurrentHashMap<String, StubHttpLifecycle> matchedStubsCache;

    public StubRepository(File configFile, Future<List<StubHttpLifecycle>> stubLoadComputation) {
        this.configFile = configFile;
        this.stubLoadComputation = stubLoadComputation;
        this.stubbyHttpTransport = new StubbyHttpTransport();
        this.resourceStats = new ConcurrentHashMap();
        this.matchedStubsCache = new ConcurrentHashMap();
    }

    public StubSearchResult search(HttpServletRequest incomingRequest) throws IOException {
        StubRequest assertionStubRequest = this.toStubRequest(incomingRequest);
        ConsoleUtils.logAssertingRequest(assertionStubRequest);
        StubResponse match = this.findMatch(new StubHttpLifecycle.Builder().withRequest(assertionStubRequest).build());
        return new StubSearchResult(assertionStubRequest, match);
    }

    public StubRequest toStubRequest(HttpServletRequest request) throws IOException {
        StubRequest.Builder builder = new StubRequest.Builder();
        builder.withUrl(request.getPathInfo()).withPost(HandlerUtils.extractPostRequestBody(request, "stubs")).withMethod(request.getMethod());
        Enumeration<String> headerNamesEnumeration = request.getHeaderNames();
        AbstractList headerNames = ObjectUtils.isNotNull(headerNamesEnumeration) ? Collections.list(request.getHeaderNames()) : new LinkedList();
        for (String headerName : headerNames) {
            String headerValue = request.getHeader(headerName);
            builder.withHeader(StringUtils.toLower(headerName), headerValue);
        }
        return builder.withQuery(CollectionUtils.constructParamMap(request.getQueryString())).build();
    }

    private StubResponse findMatch(StubHttpLifecycle incomingRequest) {
        Optional<StubHttpLifecycle> matchedStubOptional = this.matchStub(incomingRequest);
        if (!matchedStubOptional.isPresent()) {
            return StubResponse.notFoundResponse();
        }
        StubHttpLifecycle matchedStub = matchedStubOptional.get();
        String resourceId = matchedStub.getResourceId();
        this.resourceStats.putIfAbsent(resourceId, new AtomicLong(0L));
        this.resourceStats.get(resourceId).incrementAndGet();
        StubResponse matchedStubResponse = matchedStub.getResponse(true);
        if (matchedStub.isAuthorizationRequired() && matchedStub.isIncomingRequestUnauthorized(incomingRequest)) {
            return StubResponse.unauthorizedResponse();
        }
        if (matchedStubResponse.hasHeaderLocation()) {
            return StubResponse.redirectResponse(Optional.of(matchedStubResponse));
        }
        if (matchedStubResponse.isRecordingRequired()) {
            String recordingSource = String.format("%s%s", matchedStubResponse.getBody(), incomingRequest.getUrl());
            try {
                StubbyResponse stubbyResponse = this.stubbyHttpTransport.fetchRecordableHTTPResponse(matchedStub.getRequest(), recordingSource);
                ReflectionUtils.injectObjectFields(matchedStubResponse, ConfigurableYAMLProperty.BODY.toString(), stubbyResponse.getContent());
            }
            catch (Exception e) {
                ANSITerminal.error(String.format("Could not record from %s: %s", recordingSource, e.toString()));
            }
        }
        return matchedStubResponse;
    }

    private synchronized Optional<StubHttpLifecycle> matchStub(StubHttpLifecycle incomingStub) {
        String incomingRequestUrl = incomingStub.getUrl();
        if (this.matchedStubsCache.containsKey(incomingRequestUrl)) {
            ANSITerminal.loaded(String.format("Local cache contains potential match for the URL [%s]", incomingRequestUrl));
            StubHttpLifecycle cachedPotentialMatch = this.matchedStubsCache.get(incomingRequestUrl);
            if (incomingStub.equals(cachedPotentialMatch)) {
                ANSITerminal.loaded(String.format("Potential match for the URL [%s] was deemed as a full match", incomingRequestUrl));
                return Optional.of(cachedPotentialMatch);
            }
            ANSITerminal.warn(String.format("Cached match for the URL [%s] failed to match fully, invalidating match cache..", incomingRequestUrl));
            this.matchedStubsCache.remove(incomingRequestUrl);
        }
        long initialStart = System.currentTimeMillis();
        for (StubHttpLifecycle stubbed : this.stubs) {
            if (!incomingStub.equals(stubbed)) continue;
            long elapsed = System.currentTimeMillis() - initialStart;
            ANSITerminal.status(String.format("Found a match after %s milliseconds, caching the found match for URL [%s]", elapsed, incomingRequestUrl));
            this.matchedStubsCache.put(incomingRequestUrl, stubbed);
            return Optional.of(stubbed);
        }
        return Optional.empty();
    }

    public synchronized Optional<StubHttpLifecycle> matchStubByIndex(int index) {
        if (!this.canMatchStubByIndex(index)) {
            return Optional.empty();
        }
        return Optional.of(this.stubs.get(index));
    }

    synchronized boolean resetStubsCache(List<StubHttpLifecycle> newStubs) {
        this.matchedStubsCache.clear();
        this.stubs.clear();
        boolean added = this.stubs.addAll(newStubs);
        if (added) {
            this.matchedStubsCache.clear();
            this.updateResourceIDHeaders();
        }
        return added;
    }

    public synchronized void refreshStubsFromYAMLConfig(YAMLParser yamlParser) throws Exception {
        this.resetStubsCache(yamlParser.parse(this.configFile.getParent(), this.configFile));
    }

    public synchronized void refreshStubsByPost(YAMLParser yamlParser, String postPayload) throws Exception {
        this.resetStubsCache(yamlParser.parse(this.configFile.getParent(), postPayload));
    }

    public synchronized String refreshStubByIndex(YAMLParser yamlParser, String putPayload, int index) throws Exception {
        List<StubHttpLifecycle> parsedStubs = yamlParser.parse(this.configFile.getParent(), putPayload);
        StubHttpLifecycle newStub = parsedStubs.get(0);
        this.updateStubByIndex(index, newStub);
        return newStub.getUrl();
    }

    public List<StubHttpLifecycle> getStubs() {
        return new LinkedList<StubHttpLifecycle>(this.stubs);
    }

    public ConcurrentHashMap<String, AtomicLong> getResourceStats() {
        return new ConcurrentHashMap<String, AtomicLong>(this.resourceStats);
    }

    @CoberturaIgnore
    public String getResourceStatsAsCsv() {
        String csvNoHeader = this.resourceStats.toString().replaceAll("\\{|\\}", "").replaceAll(", ", FileUtils.BR).replaceAll("=", ",");
        return String.format("resourceId,hits%s%s", FileUtils.BR, csvNoHeader);
    }

    public synchronized String getOnlyStubRequestUrl() {
        return this.stubs.get(0).getUrl();
    }

    public File getYAMLConfig() {
        return this.configFile;
    }

    public synchronized Map<File, Long> getExternalFiles() {
        HashSet<String> escrow = new HashSet<String>();
        HashMap<File, Long> externalFiles = new HashMap<File, Long>();
        for (StubHttpLifecycle stub : this.stubs) {
            this.cacheExternalFile(escrow, externalFiles, stub.getRequest().getRawFile());
            List<StubResponse> responses = stub.getResponses();
            for (StubResponse stubbedResponse : responses) {
                this.cacheExternalFile(escrow, externalFiles, stubbedResponse.getRawFile());
            }
        }
        return externalFiles;
    }

    private void cacheExternalFile(Set<String> escrow, Map<File, Long> externalFiles, File file) {
        if (ObjectUtils.isNotNull(file) && !escrow.contains(file.getName())) {
            escrow.add(file.getName());
            externalFiles.put(file, file.lastModified());
        }
    }

    @CoberturaIgnore
    public String getYAMLConfigCanonicalPath() {
        try {
            return this.configFile.getCanonicalPath();
        }
        catch (IOException e) {
            return this.configFile.getAbsolutePath();
        }
    }

    public synchronized String getStubYAML() {
        StringBuilder builder = new StringBuilder();
        for (StubHttpLifecycle stub : this.stubs) {
            builder.append(stub.getCompleteYAML()).append(FileUtils.BR).append(FileUtils.BR);
        }
        return builder.toString();
    }

    public synchronized String getStubYAMLByIndex(int index) {
        return this.stubs.get(index).getCompleteYAML();
    }

    synchronized void updateStubByIndex(int index, StubHttpLifecycle newStub) {
        this.deleteStubByIndex(index);
        this.stubs.add(index, newStub);
        this.updateResourceIDHeaders();
    }

    public synchronized boolean canMatchStubByIndex(int index) {
        return this.stubs.size() - 1 >= index;
    }

    public synchronized StubHttpLifecycle deleteStubByIndex(int index) {
        StubHttpLifecycle removedStub = this.stubs.remove(index);
        this.updateResourceIDHeaders();
        return removedStub;
    }

    private void updateResourceIDHeaders() {
        for (int index = 0; index < this.stubs.size(); ++index) {
            this.stubs.get(index).setResourceId(index);
        }
    }

    @CoberturaIgnore
    public void retrieveLoadedStubs() {
        try {
            this.stubs.addAll((Collection<StubHttpLifecycle>)this.stubLoadComputation.get());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

