/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.generics.TypeSafeConverter;
import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.stubs.ReflectableStub;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import io.github.azagniotov.stubby4j.stubs.StubTypes;
import io.github.azagniotov.stubby4j.stubs.StubbableAuthorizationType;
import io.github.azagniotov.stubby4j.utils.ReflectionUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StubHttpLifecycle
implements ReflectableStub {
    private final AtomicInteger responseSequencedIdCounter = new AtomicInteger(0);
    private final String completeYAML;
    private final StubRequest request;
    private final Object response;
    private final String requestAsYAML;
    private final String responseAsYAML;

    private StubHttpLifecycle(StubRequest request, Object response, String requestAsYAML, String responseAsYAML, String completeYAML) {
        this.request = request;
        this.response = response;
        this.requestAsYAML = requestAsYAML;
        this.responseAsYAML = responseAsYAML;
        this.completeYAML = completeYAML;
    }

    public StubRequest getRequest() {
        return this.request;
    }

    public StubResponse getResponse(boolean incrementSequencedResponseId) {
        if (this.response instanceof StubResponse) {
            return (StubResponse)this.response;
        }
        List<StubResponse> stubResponses = TypeSafeConverter.asCheckedLinkedList(this.response, StubResponse.class);
        if (stubResponses.isEmpty()) {
            return StubResponse.okResponse();
        }
        if (incrementSequencedResponseId) {
            int responseSequencedId = this.responseSequencedIdCounter.getAndIncrement();
            this.responseSequencedIdCounter.compareAndSet(stubResponses.size(), 0);
            return stubResponses.get(responseSequencedId);
        }
        return stubResponses.get(this.responseSequencedIdCounter.get());
    }

    public int getNextSequencedResponseId() {
        return this.responseSequencedIdCounter.get();
    }

    public List<StubResponse> getResponses() {
        if (this.response instanceof StubResponse) {
            return new LinkedList<StubResponse>(Collections.singletonList((StubResponse)this.response));
        }
        return TypeSafeConverter.asCheckedLinkedList(this.response, StubResponse.class);
    }

    boolean isAuthorizationRequired() {
        return this.request.isSecured();
    }

    @VisibleForTesting
    String getRawHeaderAuthorization() {
        return this.request.getRawHeaderAuthorization();
    }

    @VisibleForTesting
    String getStubbedHeaderAuthorization(StubbableAuthorizationType stubbedAuthorizationHeaderType) {
        return this.request.getStubbedHeaderAuthorization(stubbedAuthorizationHeaderType);
    }

    boolean isIncomingRequestUnauthorized(StubHttpLifecycle assertingLifecycle) {
        String stubbedHeaderAuthorization = this.getStubbedHeaderAuthorization(this.request.getStubbedAuthorizationType());
        return !stubbedHeaderAuthorization.equals(assertingLifecycle.getRawHeaderAuthorization());
    }

    public String getResourceId() {
        return this.getResponses().get(0).getResourceIDHeader();
    }

    void setResourceId(int resourceId) {
        this.getResponses().forEach(response -> response.addResourceIDHeader(resourceId));
    }

    public String getUrl() {
        return this.request.getUrl();
    }

    public String getCompleteYAML() {
        return this.completeYAML;
    }

    public String getRequestAsYAML() {
        return this.requestAsYAML;
    }

    public String getResponseAsYAML() {
        return this.responseAsYAML;
    }

    public String getAjaxResponseContent(StubTypes stubType, String propertyName) throws Exception {
        switch (stubType) {
            case REQUEST: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.request, propertyName));
            }
            case RESPONSE: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.getResponse(false), propertyName));
            }
        }
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this, propertyName));
    }

    public String getAjaxResponseContent(String propertyName, int sequencedResponseId) throws Exception {
        List<StubResponse> allResponses = this.getResponses();
        StubResponse sequencedResponse = allResponses.get(sequencedResponseId);
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(sequencedResponse, propertyName));
    }

    @CoberturaIgnore
    public int hashCode() {
        return this.request.hashCode();
    }

    @CoberturaIgnore
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StubHttpLifecycle)) {
            return false;
        }
        StubHttpLifecycle that = (StubHttpLifecycle)o;
        return this.request.equals(that.request);
    }

    public static class Builder {
        private StubRequest request = null;
        private Object response = StubResponse.okResponse();
        private String completeYAML = null;
        private String requestAsYAML = null;
        private String responseAsYAML = null;

        public Builder withRequest(StubRequest request) {
            this.request = request;
            return this;
        }

        public Builder withResponse(Object response) {
            if (!(response instanceof StubResponse) && !(response instanceof Collection)) {
                throw new IllegalArgumentException("Trying to set response of the wrong type");
            }
            this.response = response;
            return this;
        }

        public Builder withRequestAsYAML(String requestAsYAML) {
            this.requestAsYAML = requestAsYAML;
            return this;
        }

        public Builder withResponseAsYAML(String responseAsYAML) {
            this.responseAsYAML = responseAsYAML;
            return this;
        }

        public Builder withCompleteYAML(String completeYAML) {
            this.completeYAML = completeYAML;
            return this;
        }

        public Builder withResourceId(int resourceId) {
            this.getResponses().forEach(response -> response.addResourceIDHeader(resourceId));
            return this;
        }

        public StubHttpLifecycle build() {
            StubHttpLifecycle stubHttpLifecycle = new StubHttpLifecycle(this.request, this.response, this.requestAsYAML, this.responseAsYAML, this.completeYAML);
            this.request = null;
            this.response = StubResponse.okResponse();
            this.completeYAML = null;
            this.requestAsYAML = null;
            this.responseAsYAML = null;
            return stubHttpLifecycle;
        }

        private List<StubResponse> getResponses() {
            if (this.response instanceof StubResponse) {
                return new LinkedList<StubResponse>(Collections.singletonList((StubResponse)this.response));
            }
            return TypeSafeConverter.asCheckedLinkedList(this.response, StubResponse.class);
        }
    }
}

