/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

enum RegexParser {
    INSTANCE;

    @VisibleForTesting
    static final Map<Integer, Pattern> PATTERN_CACHE;
    @VisibleForTesting
    static final Pattern SPECIAL_REGEX_CHARS;

    void compilePatternAndCache(String value) {
        this.compilePatternAndCache(value, 8);
    }

    private void compilePatternAndCache(String value, int flags) {
        try {
            if (SPECIAL_REGEX_CHARS.matcher(value).matches()) {
                PATTERN_CACHE.computeIfAbsent(value.hashCode(), hashCode -> Pattern.compile(value, flags));
            }
        }
        catch (PatternSyntaxException e) {
            this.compilePatternAndCache(value, 24);
        }
    }

    boolean match(String patternCandidate, String subject, String templateTokenName, Map<String, String> regexGroups) {
        return this.match(patternCandidate, subject, templateTokenName, regexGroups, 8);
    }

    private boolean match(String patternCandidate, String subject, String templateTokenName, Map<String, String> regexGroups, int flags) {
        try {
            Pattern pattern = PATTERN_CACHE.computeIfAbsent(patternCandidate.hashCode(), hashCode -> Pattern.compile(patternCandidate, flags));
            Matcher matcher = pattern.matcher(subject);
            boolean isMatch = matcher.matches();
            if (isMatch) {
                regexGroups.put(StringUtils.buildToken(templateTokenName, 0), matcher.group(0));
                int groupCount = matcher.groupCount();
                if (groupCount > 0) {
                    for (int idx = 1; idx <= groupCount; ++idx) {
                        regexGroups.put(StringUtils.buildToken(templateTokenName, idx), matcher.group(idx));
                    }
                }
            }
            return isMatch;
        }
        catch (PatternSyntaxException e) {
            return this.match(patternCandidate, subject, templateTokenName, regexGroups, 24);
        }
    }

    static {
        PATTERN_CACHE = new ConcurrentHashMap<Integer, Pattern>();
        SPECIAL_REGEX_CHARS = Pattern.compile(String.format(".*([%s%s%s%s%s%s%s%s%s%s]).*", Pattern.quote("^"), Pattern.quote("$"), Pattern.quote("["), Pattern.quote("]"), Pattern.quote("{"), Pattern.quote("}"), Pattern.quote("*"), Pattern.quote("|"), Pattern.quote("\\"), Pattern.quote("?")));
    }
}

