/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.server;

import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.cli.EmptyLogger;
import io.github.azagniotov.stubby4j.filesystem.ExternalFilesScanner;
import io.github.azagniotov.stubby4j.filesystem.MainYamlScanner;
import io.github.azagniotov.stubby4j.server.JettyFactory;
import io.github.azagniotov.stubby4j.server.StubbyManager;
import io.github.azagniotov.stubby4j.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class StubbyManagerFactory {
    public synchronized StubbyManager construct(File configFile, Map<String, String> commandLineArgs, Future<List<StubHttpLifecycle>> stubLoadComputation) throws Exception {
        Log.setLog(new EmptyLogger());
        StubRepository stubRepository = new StubRepository(configFile, stubLoadComputation);
        JettyFactory jettyFactory = new JettyFactory(commandLineArgs, stubRepository);
        Server server = jettyFactory.construct();
        if (commandLineArgs.containsKey("watch")) {
            String watchValue = commandLineArgs.get("watch");
            long watchScanTime = ObjectUtils.isNotNull(watchValue) ? Long.parseLong(watchValue) : 100L;
            this.watchDataStore(stubRepository, watchScanTime);
        }
        if (commandLineArgs.containsKey("mute")) {
            ANSITerminal.muteConsole(true);
        }
        return new StubbyManager(server, jettyFactory, stubRepository);
    }

    private void watchDataStore(StubRepository stubRepository, long sleepTime) {
        MainYamlScanner mainYamlScanner = new MainYamlScanner(stubRepository, sleepTime);
        new Thread((Runnable)mainYamlScanner, MainYamlScanner.class.getCanonicalName()).start();
        ExternalFilesScanner externalFilesScanner = new ExternalFilesScanner(stubRepository, sleepTime);
        new Thread((Runnable)externalFilesScanner, ExternalFilesScanner.class.getCanonicalName()).start();
    }
}

