/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.admin;

import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.YAMLParser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;

public class PutHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubRepository stubRepository) throws Exception {
        if (request.getRequestURI().equals("/")) {
            response.setStatus(405);
            response.getWriter().println("Method PUT is not allowed on URI " + request.getRequestURI());
            return;
        }
        int contextPathLength = "/".length();
        String pathInfoNoHeadingSlash = request.getRequestURI().substring(contextPathLength);
        int stubIndexToUpdate = Integer.parseInt(pathInfoNoHeadingSlash);
        if (!stubRepository.canMatchStubByIndex(stubIndexToUpdate)) {
            String errorMessage = String.format("Stub request index#%s does not exist, cannot update", stubIndexToUpdate);
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        String put = HandlerUtils.extractPostRequestBody(request, "admin");
        if (!StringUtils.isSet(put)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getRequestURI());
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        String updatedCycleUrl = stubRepository.refreshStubByIndex(new YAMLParser(), put, stubIndexToUpdate);
        response.setStatus(201);
        response.addHeader(HttpHeader.LOCATION.asString(), updatedCycleUrl);
        String successfulMessage = String.format("Stub request index#%s updated successfully", stubIndexToUpdate);
        response.getWriter().println(successfulMessage);
    }
}

