/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.admin;

import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.DeleteHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.GetHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.HttpVerbsEnum;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.NullHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.PostHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.PutHandlingStrategy;
import javax.servlet.http.HttpServletRequest;

public final class AdminResponseHandlingStrategyFactory {
    private AdminResponseHandlingStrategyFactory() {
    }

    public static AdminResponseHandlingStrategy getStrategy(HttpServletRequest request) {
        HttpVerbsEnum verbEnum;
        String method = request.getMethod();
        try {
            verbEnum = HttpVerbsEnum.valueOf(method);
        }
        catch (IllegalArgumentException ex) {
            return new NullHandlingStrategy();
        }
        switch (verbEnum) {
            case POST: {
                return new PostHandlingStrategy();
            }
            case PUT: {
                return new PutHandlingStrategy();
            }
            case DELETE: {
                return new DeleteHandlingStrategy();
            }
        }
        return new GetHandlingStrategy();
    }
}

