/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubsResponseHandlingStrategyFactory;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.stubs.StubSearchResult;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class StubsPortalHandler
extends AbstractHandler {
    private final StubRepository stubRepository;

    public StubsPortalHandler(StubRepository stubRepository) {
        this.stubRepository = stubRepository;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "stubs", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        try {
            StubSearchResult stubSearchResult = this.stubRepository.search(request);
            StubResponseHandlingStrategy strategyStubResponse = StubsResponseHandlingStrategyFactory.getStrategy(stubSearchResult.getMatch());
            strategyStubResponse.handle(response, stubSearchResult.getInvariant());
            ConsoleUtils.logOutgoingResponse(stubSearchResult.getInvariant().getUrl(), response);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }
}

