/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.utils.reflection;

import io.github.antoniovizuete.pojospreadsheet.utils.reflection.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class MethodUtils {
    public static final Object[] VOID_PARAMS = new Object[0];

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static boolean isGetterOrSetter(Method method) {
        return MethodUtils.isGetter(method) || MethodUtils.isSetter(method);
    }

    public static HashMap<String, Field> getFields(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        if (clazz == null || Object.class.equals(clazz)) {
            return fields;
        }
        fields.putAll(MethodUtils.getFields(clazz.getSuperclass()));
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!MethodUtils.isGetterOrSetter(method)) continue;
            String name = method.getName().substring(3, method.getName().length()).toLowerCase();
            Field field = fields.containsKey(name) ? fields.get(name) : new Field(name);
            field.setMethod(method);
            fields.put(name, field);
        }
        return fields;
    }
}

