/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.model.cell.adress;

import io.github.antoniovizuete.pojospreadsheet.core.model.CellAddress;
import io.github.antoniovizuete.pojospreadsheet.core.model.helpers.CellAddressHelper;
import java.util.Objects;

public final class CellAddressImpl
implements CellAddress {
    private Integer col;
    private Integer row;
    private String sheet;

    protected CellAddressImpl() {
    }

    protected CellAddressImpl(int col, int row) {
        this.row = row;
        this.col = col;
    }

    @Override
    public CellAddress col(Integer col) {
        this.col = col;
        return this;
    }

    @Override
    public CellAddress col(String col) {
        this.col = CellAddressHelper.toNumber(col);
        return this;
    }

    @Override
    public CellAddress row(Integer row) {
        this.row = row;
        return this;
    }

    @Override
    public CellAddress sheet(String sheet) {
        this.sheet = sheet;
        return this;
    }

    public String toString() {
        String s = "";
        s = s + (this.sheet == null ? "" : "'" + this.sheet + "'!");
        s = s + (this.col == null ? "" : CellAddressHelper.toName(this.col));
        s = s + (this.row == null ? "" : this.row);
        return s;
    }

    @Override
    public Integer getCol() {
        return this.col;
    }

    @Override
    public Integer getRow() {
        return this.row;
    }

    @Override
    public String getSheet() {
        return this.sheet;
    }

    @Override
    public void setCol(Integer col) {
        this.col = col;
    }

    @Override
    public void setRow(Integer row) {
        this.row = row;
    }

    @Override
    public void setSheet(String sheet) {
        this.sheet = sheet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellAddressImpl that = (CellAddressImpl)o;
        return Objects.equals(this.col, that.col) && Objects.equals(this.row, that.row) && Objects.equals(this.sheet, that.sheet);
    }

    public int hashCode() {
        return Objects.hash(this.col, this.row, this.sheet);
    }
}

