/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.decoration;

import io.github.antoniovizuete.pojospreadsheet.core.model.Color;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class ColorImpl
implements Color {
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final String REGEX = "^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private String hexRGB;

    public ColorImpl(String hexRGB) {
        if (!Pattern.matches(REGEX, hexRGB)) {
            throw new IllegalArgumentException("Color not valid '" + hexRGB + "'");
        }
        this.hexRGB = hexRGB;
    }

    public String toString() {
        return "Color{" + this.hexRGB + '}';
    }

    @Override
    public byte[] toByteArray() {
        return this.convertColor(this.getHexRGB());
    }

    private byte[] convertColor(String color) {
        byte[] colorBytes = new byte[3];
        if (Pattern.matches(REGEX, color)) {
            String auxColor = this.transform(color);
            IntStream.range(0, colorBytes.length).forEach(i -> {
                colorBytes[i] = Integer.valueOf(auxColor.substring(i * 2, (i + 1) * 2), 16).byteValue();
            });
        }
        return colorBytes;
    }

    private String transform(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            StringBuilder sb = new StringBuilder();
            Arrays.asList(color.split("")).forEach(part -> sb.append((String)part).append((String)part));
            color = sb.toString();
        }
        return color;
    }

    @Override
    public java.awt.Color toAwtColor() {
        int[] intArray = new int[3];
        if (Pattern.matches(REGEX, this.hexRGB)) {
            String color = this.transform(this.hexRGB);
            IntStream.range(0, intArray.length).forEach(i -> {
                intArray[i] = Integer.valueOf(color.substring(i * 2, (i + 1) * 2), 16);
            });
        }
        return new java.awt.Color(intArray[0], intArray[1], intArray[2]);
    }

    @Override
    public int getRed() {
        return this.convertColor(this.getHexRGB())[0];
    }

    @Override
    public int getGreen() {
        return this.convertColor(this.getHexRGB())[1];
    }

    @Override
    public int getBlue() {
        return this.convertColor(this.getHexRGB())[2];
    }

    @Override
    public String getHexRGB() {
        return this.hexRGB;
    }

    @Override
    public void setHexRGB(String hexRGB) {
        this.hexRGB = hexRGB;
    }
}

