/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.converter;

import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterCellDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.converter.PoiConverter;
import io.github.antoniovizuete.pojospreadsheet.core.model.Font;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class ConverterFont
implements PoiConverter<XSSFFont, Font> {
    private ConverterCellDecoration decorConverter;

    ConverterFont(ConverterCellDecoration decorConverter) {
        this.decorConverter = decorConverter;
    }

    @Override
    public XSSFFont getPoiValue(XSSFWorkbook xssfWorkbook, Font font) {
        XSSFFont xssfFont = xssfWorkbook.createFont();
        xssfFont.setFontName(font.getFontName());
        if (font.getColor() != null) {
            xssfFont.setColor(this.decorConverter.getXSSFColor(font.getColor()));
        }
        if (font.getHeight() != null) {
            xssfFont.setFontHeightInPoints(font.getHeight().shortValue());
        }
        if (font.getTypeOffset() != null) {
            xssfFont.setTypeOffset(font.getTypeOffset().getPoiValue().shortValue());
        }
        if (font.getBold() != null) {
            xssfFont.setBold(font.getBold().booleanValue());
            if (font.getBold().booleanValue()) {
                xssfFont.setBold(true);
            }
        }
        if (font.getUnderline() != null) {
            xssfFont.setUnderline(font.getUnderline().getPoiValue().byteValue());
        }
        if (font.getItalic() != null) {
            xssfFont.setItalic(font.getItalic().booleanValue());
        }
        return xssfFont;
    }
}

