/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core.converter;

import io.github.antoniovizuete.pojospreadsheet.core.CellStyleImpl;
import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterCellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterColor;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterFont;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterHelper;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultCellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultFormat;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.CellStyleKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.ColorKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.FontKey;
import io.github.antoniovizuete.pojospreadsheet.core.model.Cell;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellStyle;
import io.github.antoniovizuete.pojospreadsheet.utils.reflection.ObjectUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ConverterCellDecoration {
    private XSSFWorkbook xssfWorkbook;
    private SpreadsheetDecoration decoration;
    private ConverterColor colorConverter;
    private ConverterFont fontConverter;
    private ConverterCellStyle cellStyleConverter;
    private Map<ColorKey, XSSFColor> colors = new HashMap<ColorKey, XSSFColor>();
    private Map<FontKey, XSSFFont> fonts = new HashMap<FontKey, XSSFFont>();
    private Map<CellStyleKey, XSSFCellStyle> cellStyles = new HashMap<CellStyleKey, XSSFCellStyle>();

    public ConverterCellDecoration(SpreadsheetDecoration decoration) {
        this.decoration = decoration;
        this.colorConverter = new ConverterColor(decoration);
        this.fontConverter = new ConverterFont(this);
        this.cellStyleConverter = new ConverterCellStyle(this, decoration);
    }

    XSSFColor getXSSFColor(ColorKey c) {
        return this.colors.get(c);
    }

    XSSFFont getXSSFFont(FontKey f) {
        return this.fonts.get(f);
    }

    private XSSFCellStyle getDefaultXSSFCellStyle() {
        return this.cellStyles.get(DefaultCellStyle.DEFAULT_CELL_STYLE);
    }

    private XSSFCellStyle getXSSFCellStyle(CellStyleKey s) {
        return this.cellStyles.get(s);
    }

    public void convert(XSSFWorkbook xssfWorkbook) {
        this.xssfWorkbook = xssfWorkbook;
        this.convertColors();
        this.convertFonts();
        this.convertStyles();
    }

    private void convertColors() {
        Set<ColorKey> colorKeys = this.decoration.getColors().keySet();
        for (ColorKey colorKey : colorKeys) {
            this.colors.put(colorKey, this.colorConverter.getPoiValue(this.xssfWorkbook, colorKey));
        }
    }

    private void convertFonts() {
        Set<FontKey> fontKeys = this.decoration.getFonts().keySet();
        for (FontKey fontKey : fontKeys) {
            this.fonts.put(fontKey, this.fontConverter.getPoiValue(this.xssfWorkbook, this.decoration.getFonts().get(fontKey)));
        }
    }

    private void convertStyles() {
        Set<CellStyleKey> styleKeys = this.decoration.getCellStyles().keySet();
        for (CellStyleKey styleKey : styleKeys) {
            this.cellStyles.put(styleKey, this.cellStyleConverter.getPoiValue(this.xssfWorkbook, this.decoration.getCellStyles().get(styleKey)));
        }
    }

    public XSSFCellStyle mergeXSSFCellStyle(Cell cell) {
        if (Objects.isNull(cell.getCellStyle()) && ConverterHelper.isSpecificStyleNull(cell)) {
            XSSFCellStyle defaultXSSFCellStyle = this.getDefaultXSSFCellStyle();
            if (Objects.nonNull(cell.getValue()) && Date.class.equals(cell.getValue().getClass())) {
                CellStyle defStyle = this.decoration.get(DefaultCellStyle.DEFAULT_CELL_STYLE);
                defStyle.setFormat(DefaultFormat.DD_MM_YYYY);
                defaultXSSFCellStyle = this.cellStyleConverter.getPoiValue(this.xssfWorkbook, defStyle);
            }
            return defaultXSSFCellStyle;
        }
        CellStyle mergedStyle = ConverterHelper.cellAsCellStyle(cell);
        CellStyle genericStyle = this.decoration.get(cell.getCellStyle());
        if (Objects.nonNull(cell.getValue()) && Date.class.equals(cell.getValue().getClass()) && Objects.isNull(mergedStyle.getFormat()) && Objects.isNull(genericStyle.getFormat())) {
            mergedStyle.setFormat(DefaultFormat.DD_MM_YYYY);
        }
        if (genericStyle != null) {
            mergedStyle = ObjectUtils.mergeObject(mergedStyle, genericStyle.cloneInstance(), CellStyleImpl.class);
        }
        if (mergedStyle.equals(genericStyle)) {
            return this.getXSSFCellStyle(cell.getCellStyle());
        }
        return this.cellStyleConverter.getPoiValue(this.xssfWorkbook, mergedStyle);
    }
}

