/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.AbstractWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

class SpreadsheetFileOutputStreamWriter
extends AbstractWriter<FileOutputStream> {
    private String path;
    private String fileName;
    private File outputFile;

    public SpreadsheetFileOutputStreamWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    public SpreadsheetFileOutputStreamWriter(String path, String fileName) {
        this.path = path;
        this.fileName = fileName;
    }

    public SpreadsheetFileOutputStreamWriter(String fileName) {
        this.fileName = fileName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public byte[] write() {
        File file = this.checkFile();
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.xssfWorkbook.write((OutputStream)fos);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        byte[] byteArray = new byte[(int)file.length()];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            dis.readFully(byteArray);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return byteArray;
    }

    @Override
    public FileOutputStream performWrite() {
        FileOutputStream result;
        File file = this.checkFile();
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.xssfWorkbook.write((OutputStream)fos);
            result = fos;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private File checkFile() {
        if (Objects.nonNull(this.outputFile)) {
            return this.outputFile;
        }
        if (Objects.isNull(this.fileName)) {
            throw new IllegalStateException("Filename can not be null.");
        }
        if (Objects.nonNull(this.path) && !this.path.isEmpty() && !new File(this.path).exists()) {
            throw new IllegalStateException("Output path \"" + this.path + "\" does not exist.");
        }
        File file = new File(this.path + this.fileName);
        if (!file.canWrite()) {
            throw new IllegalStateException(this.path + this.fileName + " is not writable");
        }
        return file;
    }
}

