/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetByteArrayOutputStreamWriter;
import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetFileOutputStreamWriter;
import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetImpl;
import io.github.antoniovizuete.pojospreadsheet.core.model.Spreadsheet;
import java.io.File;

public interface SpreadsheetFactory {
    public static Spreadsheet createFileSpreadsheet(File file) {
        SpreadsheetFileOutputStreamWriter writer = new SpreadsheetFileOutputStreamWriter(file);
        return new SpreadsheetImpl(writer);
    }

    public static Spreadsheet createFileSpreadsheet(String fileName) {
        SpreadsheetFileOutputStreamWriter writer = new SpreadsheetFileOutputStreamWriter(new File(fileName));
        return new SpreadsheetImpl(writer);
    }

    public static Spreadsheet createFileSpreadsheet(String path, String file) {
        SpreadsheetFileOutputStreamWriter writer = new SpreadsheetFileOutputStreamWriter(new File(path + file));
        return new SpreadsheetImpl(writer);
    }

    public static Spreadsheet createOutputStreamSpreadsheet() {
        return new SpreadsheetImpl(new SpreadsheetByteArrayOutputStreamWriter());
    }

    public static Spreadsheet readFromFile(String path) {
        return SpreadsheetImpl.read(path);
    }
}

