/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.CellStyleImpl;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.FontImpl;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.FormatImpl;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultCellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultFont;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.defaults.DefaultFormat;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.BorderKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.CellStyleKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.ColorKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.FontKey;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.FormatKey;
import io.github.antoniovizuete.pojospreadsheet.core.model.Border;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.model.Color;
import io.github.antoniovizuete.pojospreadsheet.core.model.Font;
import io.github.antoniovizuete.pojospreadsheet.core.model.Format;
import java.util.HashMap;
import java.util.Map;

public final class SpreadsheetDecoration {
    private Map<ColorKey, Color> colors = this.configureColors();
    private Map<FontKey, Font> fonts = this.configureFonts();
    private Map<CellStyleKey, CellStyle> cellStyles = this.configureStyles();
    private Map<FormatKey, Format> formats = this.configureFormats();
    private Map<BorderKey, Border> borders = this.configureBorders();

    public Color get(ColorKey k) {
        return this.colors.get(k);
    }

    public Font get(FontKey k) {
        return this.fonts.get(k);
    }

    public Format get(FormatKey k) {
        return this.formats.get(k);
    }

    public Border get(BorderKey k) {
        return this.borders.get(k);
    }

    public CellStyle get(CellStyleKey k) {
        return this.cellStyles.get(k);
    }

    public boolean exists(ColorKey c) {
        return this.colors.containsKey(c);
    }

    public boolean exists(FontKey f) {
        return this.fonts.containsKey(f);
    }

    public boolean exists(FormatKey f) {
        return this.formats.containsKey(f);
    }

    public boolean exists(BorderKey b) {
        return this.borders.containsKey(b);
    }

    public boolean exists(CellStyleKey s) {
        return this.cellStyles.containsKey(s);
    }

    public void add(ColorKey c, Color color) {
        this.colors.put(c, color);
    }

    public void add(FontKey f, Font font) {
        this.fonts.put(f, font);
    }

    public void add(FormatKey f, Format format) {
        this.formats.put(f, format);
    }

    public void add(BorderKey b, Border border) {
        this.borders.put(b, border);
    }

    public void add(CellStyleKey s, CellStyle cellStyle) {
        this.cellStyles.put(s, cellStyle);
    }

    public void remove(ColorKey c) {
        this.colors.remove(c);
    }

    public void remove(FontKey f) {
        this.fonts.remove(f);
    }

    public void remove(FormatKey f) {
        this.formats.remove(f);
    }

    public void remove(BorderKey b) {
        this.borders.remove(b);
    }

    public void remove(CellStyleKey s) {
        this.cellStyles.remove(s);
    }

    public Map<ColorKey, Color> getColors() {
        return this.colors;
    }

    public Map<FontKey, Font> getFonts() {
        return this.fonts;
    }

    public Map<CellStyleKey, CellStyle> getCellStyles() {
        return this.cellStyles;
    }

    public Map<FormatKey, Format> getFormats() {
        return this.formats;
    }

    public Map<BorderKey, Border> getBorders() {
        return this.borders;
    }

    private Map<ColorKey, Color> configureColors() {
        return new HashMap<ColorKey, Color>();
    }

    private Map<FontKey, Font> configureFonts() {
        HashMap<FontKey, Font> map = new HashMap<FontKey, Font>();
        map.put(DefaultFont.DEFAULT_FONT, new FontImpl());
        return map;
    }

    private Map<CellStyleKey, CellStyle> configureStyles() {
        HashMap<CellStyleKey, CellStyle> map = new HashMap<CellStyleKey, CellStyle>();
        map.put(DefaultCellStyle.DEFAULT_CELL_STYLE, (CellStyle)new CellStyleImpl().font(DefaultFont.DEFAULT_FONT));
        return map;
    }

    private Map<FormatKey, Format> configureFormats() {
        HashMap<FormatKey, Format> map = new HashMap<FormatKey, Format>();
        map.put(DefaultFormat.DD_MM_YYYY, new FormatImpl("dd/MM/yyyy"));
        return map;
    }

    private Map<BorderKey, Border> configureBorders() {
        return new HashMap<BorderKey, Border>();
    }
}

