/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.PrintSetupImpl;
import io.github.antoniovizuete.pojospreadsheet.core.RowImpl;
import io.github.antoniovizuete.pojospreadsheet.core.TextBoxImpl;
import io.github.antoniovizuete.pojospreadsheet.core.image.Image;
import io.github.antoniovizuete.pojospreadsheet.core.image.ImageInputStream;
import io.github.antoniovizuete.pojospreadsheet.core.model.Cell;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellAddress;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellRegion;
import io.github.antoniovizuete.pojospreadsheet.core.model.PrintSetup;
import io.github.antoniovizuete.pojospreadsheet.core.model.Row;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.TextBox;
import io.github.antoniovizuete.pojospreadsheet.utils.iterator.AbstractIntegerSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SheetImpl
extends AbstractIntegerSet<Row>
implements Sheet {
    private Boolean autoSize = true;
    private PrintSetup printSetup = new PrintSetupImpl();
    private Integer index;
    private List<Image> images;
    private List<TextBox> textBoxes;
    private Map<String, CellRegion> mergedCells = new HashMap<String, CellRegion>();
    private CellRegion filterRange;
    private String name;
    private String alias;

    public SheetImpl(Integer index) {
        this.index = index;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public Boolean getAutoSize() {
        return this.autoSize;
    }

    @Override
    public void setAutoSize(Boolean autoSize) {
        this.autoSize = autoSize;
    }

    @Override
    public PrintSetup getPrintSetup() {
        return this.printSetup;
    }

    @Override
    public void setPrintSetup(PrintSetup printSetup) {
        this.printSetup = printSetup;
    }

    @Override
    public CellRegion getFilterRange() {
        return this.filterRange;
    }

    @Override
    public void setFilterRange(CellRegion filterRange) {
        this.filterRange = filterRange;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public List<Image> getImages() {
        return this.images;
    }

    @Override
    public void setImages(List<Image> images) {
        this.images = images;
    }

    @Override
    public List<TextBox> getTextBoxes() {
        return this.textBoxes;
    }

    @Override
    public void setTextBoxes(List<TextBox> textBoxes) {
        this.textBoxes = textBoxes;
    }

    @Override
    public Map<String, CellRegion> getMergedCells() {
        return this.mergedCells;
    }

    @Override
    public void setMergedCells(Map<String, CellRegion> mergedCells) {
        this.mergedCells = mergedCells;
    }

    @Override
    public Set<Row> rows() {
        return this.set;
    }

    @Override
    public Row createItem(Integer index) {
        return new RowImpl(this, index);
    }

    @Override
    public Row row() {
        return (Row)super.add();
    }

    @Override
    public Row row(Integer index) {
        return (Row)super.add(index);
    }

    @Override
    public Sheet name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Deprecated
    public Sheet alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public Sheet autoSize(Boolean autoSize) {
        this.autoSize = autoSize;
        return this;
    }

    @Override
    public Sheet filterRegion(CellRegion region) {
        this.filterRange = region;
        return this;
    }

    @Override
    public Sheet addImage(Image image) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(image);
        return this;
    }

    @Override
    public Sheet addImage(CellAddress address, String resourcePath) {
        return this.addImage(new ImageInputStream(resourcePath, address));
    }

    @Override
    public Sheet createTextBox(TextBox textBox) {
        if (this.textBoxes == null) {
            this.textBoxes = new ArrayList<TextBox>();
        }
        this.textBoxes.add(textBox);
        return this;
    }

    @Override
    public Sheet createTextBox(CellRegion region, String content) {
        return this.createTextBox(new TextBoxImpl(region, content));
    }

    @Override
    public Sheet mergeCell(int rowIndex, int columnIndex, int numCells) {
        CellRegion cellRegion = CellRegion.newInstance(columnIndex, rowIndex, columnIndex + --numCells, rowIndex);
        this.addMergedRegion(cellRegion);
        return this;
    }

    @Override
    public Sheet mergeCell(Row row, Cell cell, int numCells) {
        CellRegion cellRegion = CellRegion.newInstance(cell.getIndex(), row.getIndex(), cell.getIndex() + --numCells, row.getIndex());
        this.addMergedRegion(cellRegion);
        return this;
    }

    @Override
    public Sheet mergeRow(int rowIndex, int columnIndex, int numRows) {
        CellRegion cellRegion = CellRegion.newInstance(columnIndex, rowIndex, columnIndex, rowIndex + --numRows);
        this.addMergedRegion(cellRegion);
        return this;
    }

    @Override
    public Sheet mergeRow(Row row, Cell cell, int numRows) {
        CellRegion cellRegion = CellRegion.newInstance(cell.getIndex(), row.getIndex(), cell.getIndex(), row.getIndex() + numRows);
        this.addMergedRegion(cellRegion);
        return this;
    }

    @Override
    public Sheet mergeRegion(String region) {
        return this.mergeRegion(CellRegion.of(region));
    }

    @Override
    public Sheet mergeRegion(CellRegion region) {
        this.addMergedRegion(region);
        return this;
    }

    private void addMergedRegion(CellRegion cellRegion) {
        this.mergedCells.put(cellRegion.toString(), cellRegion);
    }
}

