/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.CellImpl;
import io.github.antoniovizuete.pojospreadsheet.core.model.Cell;
import io.github.antoniovizuete.pojospreadsheet.core.model.Row;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.helpers.CellAddressHelper;
import io.github.antoniovizuete.pojospreadsheet.utils.iterator.AbstractIntegerSet;
import io.github.antoniovizuete.pojospreadsheet.utils.iterator.IntegerIndex;
import java.util.Objects;
import java.util.Set;

public class RowImpl
extends AbstractIntegerSet<Cell>
implements IntegerIndex,
Row {
    private Sheet sheet;
    private Integer index;

    public RowImpl(Sheet sheet, Integer index) {
        this.sheet = sheet;
        this.index = index;
    }

    @Override
    public Set<Cell> cells() {
        return this.set;
    }

    @Override
    public Cell createItem(Integer index) {
        return new CellImpl(this, index);
    }

    @Override
    public Sheet parentSheet() {
        return this.sheet;
    }

    @Override
    public Row nextRow() {
        return this.parentSheet().row();
    }

    @Override
    public Row prevRow() {
        int newIndex = this.index - 1;
        if (newIndex < 1) {
            throw new IllegalStateException("The previous row can not be selected. The execution thread is processing the first row of the current parentSheet.");
        }
        return this.parentSheet().row(newIndex);
    }

    @Override
    public Row merge(String address, int numCells) {
        return this.merge(CellAddressHelper.toNumber(address), numCells);
    }

    @Override
    public Row merge(Integer index, int numCells) {
        return this.merge((Cell)this.add(index), numCells);
    }

    @Override
    public Row merge(Cell cell, int numCells) {
        this.parentSheet().mergeRow(this, cell, numCells);
        return this;
    }

    @Override
    public Cell cell() {
        return (Cell)super.add();
    }

    @Override
    public Cell cell(Integer index) {
        return (Cell)super.add(index);
    }

    @Override
    public Cell cell(String column) {
        return (Cell)super.add(CellAddressHelper.toNumber(column));
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowImpl row = (RowImpl)o;
        return Objects.equals(this.sheet, row.sheet) && Objects.equals(this.index, row.index);
    }

    public int hashCode() {
        return Objects.hash(this.sheet, this.index);
    }
}

