/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.AbstractCellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.RowImpl;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterHelper;
import io.github.antoniovizuete.pojospreadsheet.core.decoration.keys.CellStyleKey;
import io.github.antoniovizuete.pojospreadsheet.core.model.Cell;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellAddress;
import io.github.antoniovizuete.pojospreadsheet.core.model.CellStyle;
import io.github.antoniovizuete.pojospreadsheet.core.model.Row;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.cell.adress.CellAddressImpl;
import io.github.antoniovizuete.pojospreadsheet.core.model.helpers.CellAddressHelper;
import org.apache.poi.ss.usermodel.CellType;

public class CellImpl
extends AbstractCellStyle<Cell>
implements Cell {
    private Integer index;
    private CellAddress address = CellAddress.empty();
    private CellType type = CellType.STRING;
    private CellStyleKey cellStyle;
    private RowImpl row;
    private Object value;
    private CellAddress hyperlink;

    public CellImpl(RowImpl row, Integer col) {
        this.row = row;
        this.index = col;
        this.address.col(col).row(row.getIndex()).sheet(row.parentSheet().getName());
        this.setInstance(this);
    }

    public CellImpl(RowImpl row, String col) {
        this.row = row;
        this.index = CellAddressHelper.toNumber(col);
        this.address.col(col).row(row.getIndex()).sheet(row.parentSheet().getName());
        this.setInstance(this);
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public CellAddress getAddress() {
        return this.address;
    }

    @Override
    public CellType getType() {
        return this.type;
    }

    @Override
    public CellStyleKey getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public CellAddress getHyperlink() {
        return this.hyperlink;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public void setType(CellType type) {
        this.type = type;
    }

    @Override
    public void setCellStyle(CellStyleKey cellStyle) {
        this.cellStyle = cellStyle;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setHyperlink(CellAddressImpl hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setAddress(CellAddress address) {
        this.address = address;
    }

    @Override
    public Cell cellStyle(CellStyleKey cellStyle) {
        this.cellStyle = cellStyle;
        return this;
    }

    @Override
    public Cell value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Cell hyperlink(String hyperlink) {
        this.hyperlink = CellAddress.of(hyperlink);
        return this;
    }

    @Override
    public Cell hyperlink(CellAddressImpl hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    @Override
    public Row parentRow() {
        return this.row;
    }

    @Override
    public Sheet parentSheet() {
        return this.row.parentSheet();
    }

    @Override
    public Cell nextCell() {
        return this.row.cell();
    }

    @Override
    public Cell prevCell() {
        int newIndex = this.index - 1;
        if (newIndex < 1) {
            throw new IllegalStateException("The previous cell can not be selected. The execution thread is processing the first cell of the current row.");
        }
        return this.row.cell(newIndex);
    }

    @Override
    public Row nextRow() {
        return this.parentRow().nextRow();
    }

    @Override
    public Row prevRow() {
        return this.parentRow().prevRow();
    }

    @Override
    public Cell merge(int numCells) {
        this.parentRow().parentSheet().mergeCell(this.row, this, numCells);
        return this;
    }

    public String toString() {
        return "Cell(super=" + super.toString() + ", address=" + this.getAddress() + ", type=" + this.getType() + ", cellStyle=" + this.getCellStyle() + ", row=" + this.row + ", value=" + this.getValue() + ", hyperlink=" + this.getHyperlink() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellImpl cell = (CellImpl)o;
        return this.index.equals(cell.index);
    }

    @Override
    public int hashCode() {
        return this.index.hashCode();
    }

    protected CellStyle asCellStyle() {
        return ConverterHelper.cellAsCellStyle(this);
    }

    protected boolean isSpecificStyleNull() {
        return ConverterHelper.isSpecificStyleNull(this);
    }
}

