/*
 * Decompiled with CFR 0.152.
 */
package io.github.antoniovizuete.pojospreadsheet.core;

import io.github.antoniovizuete.pojospreadsheet.core.SpreadsheetDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.converter.ConverterCellDecoration;
import io.github.antoniovizuete.pojospreadsheet.core.image.Image;
import io.github.antoniovizuete.pojospreadsheet.core.model.Cell;
import io.github.antoniovizuete.pojospreadsheet.core.model.Color;
import io.github.antoniovizuete.pojospreadsheet.core.model.PrintSetup;
import io.github.antoniovizuete.pojospreadsheet.core.model.Row;
import io.github.antoniovizuete.pojospreadsheet.core.model.Sheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.Spreadsheet;
import io.github.antoniovizuete.pojospreadsheet.core.model.SpreadsheetWriter;
import io.github.antoniovizuete.pojospreadsheet.core.model.TextBox;
import io.github.antoniovizuete.pojospreadsheet.utils.reflection.ObjectUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTextBox;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

abstract class AbstractWriter<T extends OutputStream>
implements SpreadsheetWriter<T> {
    private static final String STANDARD_SHEET_NAME = "Sheet ";
    private static final int FIRST_PARAM = 0;
    private static final Double INCH_FACTOR = 0.03937;
    protected Spreadsheet spreadsheet;
    protected XSSFWorkbook xssfWorkbook;
    private ConverterCellDecoration decorationConverter;
    private List<Integer> cellIndexesAutosize = new ArrayList<Integer>();

    AbstractWriter() {
    }

    T writeSpreadsheet(Spreadsheet spreadsheet) {
        this.spreadsheetToPoiWorkbook(spreadsheet);
        return this.performWrite();
    }

    @Deprecated
    byte[] writeSpreadsheet(Spreadsheet spreadsheet, SpreadsheetDecoration decoration) {
        this.spreadsheetToPoiWorkbook(spreadsheet);
        return this.write();
    }

    private void spreadsheetToPoiWorkbook(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        this.decorationConverter = new ConverterCellDecoration(spreadsheet.getDecoration());
        this.xssfWorkbook = new XSSFWorkbook();
        this.decorationConverter.convert(this.xssfWorkbook);
        this.iterateSheets();
    }

    private void iterateSheets() {
        this.spreadsheet.sheets().forEach(sheet -> {
            this.cellIndexesAutosize.clear();
            XSSFSheet xssfSheet = this.createXssfSheet((Sheet)sheet);
            this.iterateRows((Sheet)sheet, xssfSheet);
            this.doMerge((Sheet)sheet, xssfSheet);
            this.doFilter((Sheet)sheet, xssfSheet);
            this.printImages((Sheet)sheet, xssfSheet);
            this.printTextBoxes((Sheet)sheet, xssfSheet);
            this.doAutosize((Sheet)sheet, xssfSheet);
            this.doPrintSettings((Sheet)sheet, xssfSheet);
        });
    }

    private void doPrintSettings(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getPrintSetup() == null) {
            return;
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        xssfSheet.getPrintSetup().setPaperSize(printSetup.getPaperSize());
        xssfSheet.getPrintSetup().setOrientation(printSetup.getOrientation());
        if (printSetup.getMarginTop() != null) {
            xssfSheet.setMargin((short)2, printSetup.getMarginTop() * INCH_FACTOR);
        }
        if (printSetup.getMarginRight() != null) {
            xssfSheet.setMargin((short)1, printSetup.getMarginRight() * INCH_FACTOR);
        }
        if (printSetup.getMarginBottom() != null) {
            xssfSheet.setMargin((short)3, printSetup.getMarginBottom() * INCH_FACTOR);
        }
        if (printSetup.getMarginLeft() != null) {
            xssfSheet.setMargin((short)0, printSetup.getMarginLeft() * INCH_FACTOR);
        }
        if (printSetup.getMarginHeader() != null) {
            xssfSheet.setMargin((short)4, printSetup.getMarginHeader() * INCH_FACTOR);
        }
        if (printSetup.getMarginFooter() != null) {
            xssfSheet.setMargin((short)5, printSetup.getMarginFooter() * INCH_FACTOR);
        }
        if (printSetup.getPrintArea() != null) {
            this.xssfWorkbook.setPrintArea(sheet.getIndex().intValue(), printSetup.getPrintArea().getStart().getCol().intValue(), printSetup.getPrintArea().getEnd().getCol().intValue(), printSetup.getPrintArea().getStart().getRow().intValue(), printSetup.getPrintArea().getEnd().getRow().intValue());
        }
    }

    private void doAutosize(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getAutoSize() == null || !sheet.getAutoSize().booleanValue()) {
            return;
        }
        this.cellIndexesAutosize.sort(Comparator.naturalOrder());
        this.cellIndexesAutosize.forEach(cellKey -> xssfSheet.autoSizeColumn(cellKey.intValue(), true));
    }

    private void doFilter(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getFilterRange() == null) {
            return;
        }
        xssfSheet.setAutoFilter(CellRangeAddress.valueOf((String)sheet.getFilterRange().toString()));
    }

    private void doMerge(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getMergedCells() == null || sheet.getMergedCells().size() == 0) {
            return;
        }
        Set<String> keySet = sheet.getMergedCells().keySet();
        for (String key : keySet) {
            xssfSheet.addMergedRegion(CellRangeAddress.valueOf((String)sheet.getMergedCells().get(key).toString()));
        }
    }

    private XSSFSheet createXssfSheet(Sheet sheet) {
        String sheetName = sheet.getName();
        if (sheetName == null) {
            sheetName = STANDARD_SHEET_NAME + sheet.getIndex();
        }
        return this.xssfWorkbook.createSheet(sheetName);
    }

    private void iterateRows(Sheet sheet, XSSFSheet xssfSheet) {
        sheet.rows().forEach(row -> this.iterateCells((Row)row, this.createXssfRow((Row)row, xssfSheet)));
    }

    private XSSFRow createXssfRow(Row row, XSSFSheet xssfSheet) {
        return xssfSheet.createRow(row.getIndex() - 1);
    }

    private void iterateCells(Row row, XSSFRow xssfRow) {
        row.cells().forEach(cell -> {
            XSSFCell xssfCell = this.createXssfCell((Cell)cell, xssfRow);
            this.setCellValue((org.apache.poi.ss.usermodel.Cell)xssfCell, cell.getValue());
            this.setXSSFCellStyle((Cell)cell, xssfCell);
            if (cell.getHyperlink() != null) {
                XSSFHyperlink hyperlink = this.xssfWorkbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
                hyperlink.setAddress(cell.getHyperlink().toString());
                xssfCell.setHyperlink((Hyperlink)hyperlink);
            }
            if (!this.cellIndexesAutosize.contains(xssfCell.getColumnIndex())) {
                this.cellIndexesAutosize.add(xssfCell.getColumnIndex());
            }
        });
    }

    private XSSFCell createXssfCell(Cell cell, XSSFRow xssfRow) {
        return xssfRow.createCell(cell.getIndex() - 1);
    }

    private void setCellValue(org.apache.poi.ss.usermodel.Cell cell, Object object) {
        if (object == null) {
            return;
        }
        object = this.preventNumeric(object);
        List methods = Stream.of(cell.getClass().getDeclaredMethods()).filter(method -> "setCellValue".equals(method.getName())).collect(Collectors.toList());
        try {
            Class clazz = object.getClass();
            Class type = this.isNumeric(clazz) ? (Class)clazz.getField("TYPE").get(null) : clazz;
            for (Method method2 : methods) {
                Class<?> paramType = method2.getParameterTypes()[0];
                if (!paramType.isAssignableFrom(type)) continue;
                if (paramType.equals(RichTextString.class)) {
                    method2.invoke((Object)cell, (RichTextString)object);
                } else if (paramType.equals(Double.TYPE)) {
                    method2.invoke((Object)cell, object);
                } else {
                    method2.invoke((Object)cell, ObjectUtils.getCastedValue(object, type));
                }
                if (!clazz.equals(Double.class) && !clazz.equals(Double.TYPE) && !clazz.equals(Date.class) && !clazz.equals(Calendar.class)) continue;
                cell.setCellType(CellType.NUMERIC);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object preventNumeric(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return new Integer((Integer)object).doubleValue();
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return new Short((Short)object).doubleValue();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return new Long((Long)object).doubleValue();
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return new Float(((Float)object).floatValue()).doubleValue();
        }
        if (clazz.equals(Double.class)) {
            return (double)new Double((Double)object);
        }
        if (clazz.equals(BigDecimal.class)) {
            return ((BigDecimal)object).doubleValue();
        }
        return object;
    }

    private boolean isNumeric(Class<?> clazz) {
        return clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) || clazz.equals(Short.class) || clazz.equals(Short.TYPE) || clazz.equals(Long.class) || clazz.equals(Long.TYPE) || clazz.equals(Float.class) || clazz.equals(Float.TYPE) || clazz.equals(Double.class) || clazz.equals(Double.TYPE) || clazz.equals(BigDecimal.class);
    }

    private void setXSSFCellStyle(Cell cell, XSSFCell xssfCell) {
        XSSFCellStyle xssfCellStyle = this.decorationConverter.mergeXSSFCellStyle(cell);
        if (xssfCellStyle != null) {
            xssfCell.setCellStyle((CellStyle)xssfCellStyle);
        }
    }

    private void printImages(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getImages() == null) {
            return;
        }
        for (Image image : sheet.getImages()) {
            this.printImage(xssfSheet, image);
        }
    }

    private void printImage(XSSFSheet xssfSheet, Image image) {
        int imageIndex;
        try {
            imageIndex = this.xssfWorkbook.addPicture(image.getResource(), image.getType().getPoiValue().intValue());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        XSSFDrawing draw = xssfSheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.xssfWorkbook.getCreationHelper().createClientAnchor();
        anchor.setRow1(image.getCellAddress().getRow() - 1);
        anchor.setCol1(image.getCellAddress().getCol() - 1);
        anchor.setDx1(19050);
        anchor.setDy1(19050);
        Picture picture = draw.createPicture((ClientAnchor)anchor, imageIndex);
        picture.resize();
    }

    private void printTextBoxes(Sheet sheet, XSSFSheet xssfSheet) {
        if (sheet.getTextBoxes() == null) {
            return;
        }
        for (TextBox textBox : sheet.getTextBoxes()) {
            this.printTextBox(xssfSheet, textBox);
        }
    }

    private void printTextBox(XSSFSheet xssfSheet, TextBox textBox) {
        Color color;
        XSSFDrawing draw = xssfSheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.xssfWorkbook.getCreationHelper().createClientAnchor();
        anchor.setDx1(9524);
        anchor.setDy1(9524);
        anchor.setDx2(9524);
        anchor.setDy2(9524);
        anchor.setCol1(textBox.getPosition().getStart().getCol() - 1);
        anchor.setRow1(textBox.getPosition().getStart().getRow() - 1);
        anchor.setCol2(textBox.getPosition().getEnd().getCol().intValue());
        anchor.setRow2(textBox.getPosition().getEnd().getRow().intValue());
        XSSFTextBox tb = draw.createTextbox(anchor);
        if (textBox.getBorderStyle() != null) {
            Double width;
            color = this.spreadsheet.getDecoration().get(this.spreadsheet.getDecoration().get(textBox.getBorderStyle()).getColor());
            tb.setLineStyleColor(color.getRed(), color.getGreen(), color.getBlue());
            tb.setLineStyle(this.spreadsheet.getDecoration().get(textBox.getBorderStyle()).getBorderStyle().ordinal() - 1);
            switch (this.spreadsheet.getDecoration().get(textBox.getBorderStyle()).getBorderStyle()) {
                case THIN: 
                case THICK: 
                case HAIR: {
                    width = 1.0;
                    break;
                }
                case MEDIUM: 
                case MEDIUM_DASH_DOT: 
                case MEDIUM_DASHED: {
                    width = 2.0;
                    break;
                }
                case DOUBLE: {
                    width = 3.0;
                    break;
                }
                default: {
                    width = 0.0;
                }
            }
            tb.setLineWidth(width.doubleValue());
        }
        if (textBox.getAutofit() != null) {
            tb.setTextAutofit(textBox.getAutofit());
        }
        if (textBox.getTextColor() != null) {
            color = this.spreadsheet.getDecoration().get(textBox.getTextColor());
            tb.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        tb.setText(textBox.getValue());
    }
}

