/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.rajat.pdfviewer.HeaderData;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewerActivity;
import com.rajat.pdfviewer.PdfViewerViewModel;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ActivityPdfViewerBinding;
import com.rajat.pdfviewer.util.FileUtils;
import com.rajat.pdfviewer.util.NetworkUtil;
import com.rajat.pdfviewer.util.PdfEngine;
import com.rajat.pdfviewer.util.saveTo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\u0012\u0010&\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010'\u001a\u00020#2\b\u0010(\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010)\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010*\u001a\u00020#2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020#H\u0014J\u0010\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u0014H\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\nH\u0002J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\nH\u0002J\b\u00108\u001a\u00020#H\u0002J\u0018\u00109\u001a\u00020#2\u0006\u0010(\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0002J\u0018\u0010:\u001a\u00020#2\u0006\u0010(\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0002J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\nH\u0002J\b\u0010=\u001a\u00020#H\u0002J\f\u0010>\u001a\u00020#*\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006@"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "binding", "Lcom/rajat/pdfviewer/databinding/ActivityPdfViewerBinding;", "createFileLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "downloadedFilePath", "", "error_no_internet_connection", "error_pdf_corrupted", "fileUrl", "file_not_downloaded_yet", "file_saved_successfully", "file_saved_to_downloads", "headers", "Lcom/rajat/pdfviewer/HeaderData;", "menuItem", "Landroid/view/MenuItem;", "pdf_viewer_cancel", "pdf_viewer_error", "pdf_viewer_grant", "pdf_viewer_retry", "permission_required", "permission_required_title", "requestPermissionLauncher", "viewModel", "Lcom/rajat/pdfviewer/PdfViewerViewModel;", "getViewModel", "()Lcom/rajat/pdfviewer/PdfViewerViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "checkAndStartDownload", "", "configureToolbar", "init", "initPdfViewer", "initPdfViewerWithPath", "filePath", "loadFileFromNetwork", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "onPdfError", "e", "promptUserForLocation", "fileName", "requestStoragePermission", "saveFileToPublicDirectoryLegacy", "saveFileToPublicDirectoryScopedStorage", "setUpToolbar", "toolbarTitle", "startDownload", "showProgressBar", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfViewerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,510:1\n75#2,13:511\n*S KotlinDebug\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n*L\n63#1:511,13\n*E\n"})
public final class PdfViewerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String file_not_downloaded_yet;
    private String file_saved_to_downloads;
    private String file_saved_successfully;
    private String error_no_internet_connection;
    private String permission_required;
    private String permission_required_title;
    private String error_pdf_corrupted;
    private String pdf_viewer_retry;
    private String pdf_viewer_grant;
    private String pdf_viewer_cancel;
    private String pdf_viewer_error;
    @Nullable
    private MenuItem menuItem;
    @Nullable
    private String fileUrl;
    private HeaderData headers;
    private ActivityPdfViewerBinding binding;
    @NotNull
    private final Lazy viewModel$delegate;
    @Nullable
    private String downloadedFilePath;
    @NotNull
    private final ActivityResultLauncher<String> requestPermissionLauncher;
    @NotNull
    private final ActivityResultLauncher<Intent> createFileLauncher;
    public static final int $stable = 8;
    @NotNull
    public static final String FILE_URL = "pdf_file_url";
    @NotNull
    public static final String FILE_TITLE = "pdf_file_title";
    @NotNull
    public static final String ENABLE_FILE_DOWNLOAD = "enable_download";
    @NotNull
    public static final String FROM_ASSETS = "from_assests";
    @NotNull
    private static PdfEngine engine = PdfEngine.INTERNAL;
    private static boolean enableDownload;
    private static boolean isPDFFromPath;
    private static boolean isFromAssets;
    private static boolean SAVE_TO_DOWNLOADS;

    public PdfViewerActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.$this_viewModels.getDefaultViewModelProviderFactory();
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PdfViewerViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PdfViewerActivity.requestPermissionLauncher$lambda$6(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
        this.requestPermissionLauncher = activityResultLauncher;
        ActivityResultLauncher activityResultLauncher2 = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> PdfViewerActivity.createFileLauncher$lambda$12(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"registerForActivityResult(...)");
        this.createFileLauncher = activityResultLauncher2;
    }

    private final PdfViewerViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PdfViewerViewModel)((Object)lazy.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureToolbar() {
        TypedArray typedArray = this.getTheme().obtainStyledAttributes(R.styleable.PdfRendererView_toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            boolean showToolbar = typedArray2.getBoolean(R.styleable.PdfRendererView_toolbar_pdfView_showToolbar, true);
            Drawable backIcon = typedArray2.getDrawable(R.styleable.PdfRendererView_toolbar_pdfView_backIcon);
            int downloadIconTint = typedArray2.getColor(R.styleable.PdfRendererView_toolbar_pdfView_downloadIconTint, -1);
            int actionBarTint = typedArray2.getColor(R.styleable.PdfRendererView_toolbar_pdfView_actionBarTint, -1);
            int titleTextStyle = typedArray2.getResourceId(R.styleable.PdfRendererView_toolbar_pdfView_titleTextStyle, -1);
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.myToolbar.setVisibility(showToolbar ? 0 : 8);
            ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
            if (activityPdfViewerBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding2 = null;
            }
            activityPdfViewerBinding2.myToolbar.setNavigationIcon(backIcon);
            if (titleTextStyle != -1) {
                ActivityPdfViewerBinding activityPdfViewerBinding3 = this.binding;
                if (activityPdfViewerBinding3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    activityPdfViewerBinding3 = null;
                }
                View view = activityPdfViewerBinding3.myToolbar.findViewById(R.id.tvAppBarTitle);
                Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
                ((TextView)view).setTextAppearance((Context)this, titleTextStyle);
            }
            if (actionBarTint != -1) {
                ActivityPdfViewerBinding activityPdfViewerBinding4 = this.binding;
                if (activityPdfViewerBinding4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    activityPdfViewerBinding4 = null;
                }
                activityPdfViewerBinding4.myToolbar.setBackgroundColor(actionBarTint);
            }
        }
        finally {
            typedArray2.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        HeaderData headerData;
        super.onCreate(savedInstanceState);
        ActivityPdfViewerBinding activityPdfViewerBinding = ActivityPdfViewerBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)activityPdfViewerBinding, (String)"inflate(...)");
        this.binding = activityPdfViewerBinding;
        ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
        if (activityPdfViewerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding2 = null;
        }
        this.setContentView((View)activityPdfViewerBinding2.getRoot());
        this.configureToolbar();
        Bundle bundle = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        String string13 = bundle.getString(FILE_TITLE, "PDF");
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getString(...)");
        this.setUpToolbar(string13);
        TypedArray typedArray = this.getTheme().obtainStyledAttributes(R.styleable.PdfRendererView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray1 = typedArray;
        try {
            int backgroundColor = typedArray1.getColor(R.styleable.PdfRendererView_pdfView_backgroundColor, ContextCompat.getColor((Context)this.getApplicationContext(), (int)17170443));
            ActivityPdfViewerBinding activityPdfViewerBinding3 = this.binding;
            if (activityPdfViewerBinding3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding3 = null;
            }
            activityPdfViewerBinding3.parentLayout.setBackgroundColor(backgroundColor);
            int progressBarStyleResId = typedArray1.getResourceId(R.styleable.PdfRendererView_pdfView_progressBar, -1);
            if (progressBarStyleResId != -1) {
                Drawable progressBarStyle = ContextCompat.getDrawable((Context)((Context)this), (int)progressBarStyleResId);
                ActivityPdfViewerBinding activityPdfViewerBinding4 = this.binding;
                if (activityPdfViewerBinding4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    activityPdfViewerBinding4 = null;
                }
                activityPdfViewerBinding4.progressBar.setIndeterminateDrawable(progressBarStyle);
            }
        }
        finally {
            typedArray1.recycle();
        }
        Bundle bundle2 = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle2);
        enableDownload = bundle2.getBoolean(ENABLE_FILE_DOWNLOAD, false);
        HeaderData headerData2 = headerData = Build.VERSION.SDK_INT >= 33 ? (HeaderData)this.getIntent().getParcelableExtra("headers", HeaderData.class) : (HeaderData)this.getIntent().getParcelableExtra("headers");
        if (headerData2 != null) {
            HeaderData it = headerData2;
            boolean bl = false;
            this.headers = it;
        }
        Bundle bundle3 = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle3);
        isFromAssets = bundle3.getBoolean(FROM_ASSETS, false);
        engine = PdfEngine.INTERNAL;
        TypedArray typedArray2 = this.obtainStyledAttributes(R.styleable.PdfRendererView_Strings);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray3 = typedArray2;
        String string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_error_pdf_corrupted);
        if (string14 == null) {
            String string15 = this.getString(R.string.error_pdf_corrupted);
            string12 = string15;
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getString(...)");
        } else {
            string12 = string14;
        }
        this.error_pdf_corrupted = string12;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_error_no_internet_connection);
        if (string14 == null) {
            String string16 = this.getString(R.string.error_no_internet_connection);
            string11 = string16;
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getString(...)");
        } else {
            string11 = string14;
        }
        this.error_no_internet_connection = string11;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_file_saved_successfully);
        if (string14 == null) {
            String string17 = this.getString(R.string.file_saved_successfully);
            string10 = string17;
            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"getString(...)");
        } else {
            string10 = string14;
        }
        this.file_saved_successfully = string10;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_file_saved_to_downloads);
        if (string14 == null) {
            String string18 = this.getString(R.string.file_saved_to_downloads);
            string9 = string18;
            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"getString(...)");
        } else {
            string9 = string14;
        }
        this.file_saved_to_downloads = string9;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_file_not_downloaded_yet);
        if (string14 == null) {
            String string19 = this.getString(R.string.file_not_downloaded_yet);
            string8 = string19;
            Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"getString(...)");
        } else {
            string8 = string14;
        }
        this.file_not_downloaded_yet = string8;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_permission_required);
        if (string14 == null) {
            String string20 = this.getString(R.string.permission_required);
            string7 = string20;
            Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"getString(...)");
        } else {
            string7 = string14;
        }
        this.permission_required = string7;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_permission_required_title);
        if (string14 == null) {
            String string21 = this.getString(R.string.permission_required_title);
            string6 = string21;
            Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"getString(...)");
        } else {
            string6 = string14;
        }
        this.permission_required_title = string6;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_pdf_viewer_error);
        if (string14 == null) {
            String string22 = this.getString(R.string.pdf_viewer_error);
            string5 = string22;
            Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"getString(...)");
        } else {
            string5 = string14;
        }
        this.pdf_viewer_error = string5;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_pdf_viewer_retry);
        if (string14 == null) {
            String string23 = this.getString(R.string.pdf_viewer_retry);
            string4 = string23;
            Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"getString(...)");
        } else {
            string4 = string14;
        }
        this.pdf_viewer_retry = string4;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_pdf_viewer_cancel);
        if (string14 == null) {
            String string24 = this.getString(R.string.pdf_viewer_cancel);
            string3 = string24;
            Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"getString(...)");
        } else {
            string3 = string14;
        }
        this.pdf_viewer_cancel = string3;
        string14 = typedArray3.getString(R.styleable.PdfRendererView_Strings_pdf_viewer_grant);
        if (string14 == null) {
            String string25 = this.getString(R.string.pdf_viewer_grant);
            string2 = string25;
            Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"getString(...)");
        } else {
            string2 = string14;
        }
        this.pdf_viewer_grant = string2;
        this.init();
    }

    private final void init() {
        ActivityPdfViewerBinding activityPdfViewerBinding;
        Bundle bundle = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        if (bundle.containsKey(FILE_URL)) {
            Bundle bundle2 = this.getIntent().getExtras();
            Intrinsics.checkNotNull((Object)bundle2);
            this.fileUrl = bundle2.getString(FILE_URL);
            if (isPDFFromPath) {
                this.initPdfViewerWithPath(this.fileUrl);
            } else if (NetworkUtil.INSTANCE.checkInternetConnection((Context)this)) {
                this.loadFileFromNetwork(this.fileUrl);
            } else {
                Context context = (Context)this;
                String string2 = this.error_no_internet_connection;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"error_no_internet_connection");
                    string2 = null;
                }
                Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
            }
        }
        if ((activityPdfViewerBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.pdfView.setStatusListener(new PdfRendererView.StatusCallBack(this){
            final /* synthetic */ PdfViewerActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPdfLoadStart() {
                this.this$0.runOnUiThread(() -> init.1.onPdfLoadStart$lambda$0(this.this$0));
            }

            public void onPdfLoadProgress(int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public void onPdfLoadSuccess(@NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                this.this$0.runOnUiThread(() -> init.1.onPdfLoadSuccess$lambda$1(this.this$0, absolutePath));
            }

            public void onError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.this$0.runOnUiThread(() -> init.1.onError$lambda$2(this.this$0, error));
            }

            public void onPageChanged(int currentPage, int totalPage) {
            }

            private static final void onPdfLoadStart$lambda$0(PdfViewerActivity this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                PdfViewerActivity.access$showProgressBar(this$0, true);
            }

            private static final void onPdfLoadSuccess$lambda$1(PdfViewerActivity this$0, String $absolutePath) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$absolutePath, (String)"$absolutePath");
                PdfViewerActivity.access$showProgressBar(this$0, false);
                PdfViewerActivity.access$setDownloadedFilePath$p(this$0, $absolutePath);
            }

            private static final void onError$lambda$2(PdfViewerActivity this$0, Throwable $error) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
                PdfViewerActivity.access$showProgressBar(this$0, false);
                PdfViewerActivity.access$onPdfError(this$0, $error.toString());
            }
        });
    }

    private final void setUpToolbar(String toolbarTitle) {
        block2: {
            ActionBar actionBar;
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            this.setSupportActionBar(activityPdfViewerBinding.myToolbar);
            ActionBar actionBar2 = this.getSupportActionBar();
            if (actionBar2 == null) break block2;
            ActionBar $this$setUpToolbar_u24lambda_u241 = actionBar = actionBar2;
            boolean bl = false;
            $this$setUpToolbar_u24lambda_u241.setDisplayHomeAsUpEnabled(true);
            $this$setUpToolbar_u24lambda_u241.setDisplayShowHomeEnabled(true);
            ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
            if (activityPdfViewerBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding2 = null;
            }
            View view = activityPdfViewerBinding2.myToolbar.findViewById(R.id.tvAppBarTitle);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
            ((TextView)view).setText((CharSequence)toolbarTitle);
            $this$setUpToolbar_u24lambda_u241.setDisplayShowTitleEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuInflater menuInflater = this.getMenuInflater();
        Intrinsics.checkNotNullExpressionValue((Object)menuInflater, (String)"getMenuInflater(...)");
        MenuInflater inflater = menuInflater;
        inflater.inflate(R.menu.menu, menu2);
        MenuItem downloadMenuItem = menu2.findItem(R.id.download);
        TypedArray typedArray = this.getTheme().obtainStyledAttributes(R.styleable.PdfRendererView_toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            int downloadIconTint = typedArray2.getColor(R.styleable.PdfRendererView_toolbar_pdfView_downloadIconTint, ContextCompat.getColor((Context)this.getApplicationContext(), (int)17170443));
            Drawable drawable = downloadMenuItem.getIcon();
            if (drawable != null) {
                Drawable icon = drawable;
                boolean bl = false;
                Drawable drawable2 = DrawableCompat.wrap((Drawable)icon).mutate();
                Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"mutate(...)");
                Drawable wrappedIcon = drawable2;
                DrawableCompat.setTint((Drawable)wrappedIcon, (int)downloadIconTint);
                downloadMenuItem.setIcon(wrappedIcon);
            }
        }
        finally {
            typedArray2.recycle();
        }
        downloadMenuItem.setVisible(enableDownload);
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.download) {
            this.checkAndStartDownload();
            bl = true;
        } else if (n == 16908332) {
            this.finish();
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    private final void loadFileFromNetwork(String fileUrl) {
        this.initPdfViewer(fileUrl);
    }

    private final void initPdfViewer(String fileUrl) {
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            this.onPdfError("");
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            PdfRendererView pdfRendererView = activityPdfViewerBinding.pdfView;
            String string2 = fileUrl;
            Intrinsics.checkNotNull((Object)string2);
            HeaderData headerData = this.headers;
            if (headerData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                headerData = null;
            }
            LifecycleCoroutineScope lifecycleCoroutineScope = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this));
            Lifecycle lifecycle = this.getLifecycle();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"<get-lifecycle>(...)");
            pdfRendererView.initWithUrl(string2, headerData, lifecycleCoroutineScope, lifecycle);
        }
        catch (Exception e) {
            this.onPdfError(e.toString());
        }
    }

    private final void initPdfViewerWithPath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            this.onPdfError("");
            return;
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding;
            File file;
            File file2;
            String string2 = filePath;
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.startsWith$default((String)string2, (String)"content://", (boolean)false, (int)2, null)) {
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                Uri uri = Uri.parse((String)filePath);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
                file2 = FileUtils.INSTANCE.uriToFile(context, uri);
            } else {
                file2 = file = isFromAssets ? FileUtils.INSTANCE.fileFromAsset((Context)this, filePath) : new File(filePath);
            }
            if ((activityPdfViewerBinding = this.binding) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.pdfView.initWithFile(file);
        }
        catch (Exception e) {
            this.onPdfError(e.toString());
        }
    }

    private final void onPdfError(String e) {
        Log.e((String)"Pdf render error", (String)e);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        String string2 = this.pdf_viewer_error;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_error");
            string2 = null;
        }
        AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
        String string3 = this.error_pdf_corrupted;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"error_pdf_corrupted");
            string3 = null;
        }
        AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
        String string4 = this.pdf_viewer_retry;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_retry");
            string4 = null;
        }
        AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.onPdfError$lambda$4(this, arg_0, arg_1));
        String string5 = this.pdf_viewer_cancel;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
            string5 = null;
        }
        builder4.setNegativeButton((CharSequence)string5, null).show();
    }

    private final void showProgressBar(boolean $this$showProgressBar) {
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.progressBar.setVisibility($this$showProgressBar ? 0 : 8);
    }

    private final void requestStoragePermission() {
        this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private final void checkAndStartDownload() {
        if (Build.VERSION.SDK_INT < 30) {
            if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.startDownload();
            } else {
                this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
            }
        } else {
            this.startDownload();
        }
    }

    private final void startDownload() {
        block8: {
            Unit unit;
            String string2 = this.getIntent().getStringExtra(FILE_TITLE);
            if (string2 == null) {
                string2 = "downloaded_file.pdf";
            }
            String fileName = string2;
            String string3 = this.downloadedFilePath;
            if (string3 != null) {
                String filePath = string3;
                boolean bl = false;
                if (SAVE_TO_DOWNLOADS) {
                    if (Build.VERSION.SDK_INT >= 29) {
                        this.saveFileToPublicDirectoryScopedStorage(filePath, fileName);
                    } else {
                        this.saveFileToPublicDirectoryLegacy(filePath, fileName);
                    }
                } else {
                    this.promptUserForLocation(fileName);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block8;
            Context context = (Context)this;
            String string4 = this.file_not_downloaded_yet;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file_not_downloaded_yet");
                string4 = null;
            }
            Toast.makeText((Context)context, (CharSequence)string4, (int)0).show();
        }
    }

    private final void promptUserForLocation(String fileName) {
        Intent intent;
        Intent $this$promptUserForLocation_u24lambda_u248 = intent = new Intent("android.intent.action.CREATE_DOCUMENT");
        boolean bl = false;
        $this$promptUserForLocation_u24lambda_u248.addCategory("android.intent.category.OPENABLE");
        $this$promptUserForLocation_u24lambda_u248.setType("application/pdf");
        $this$promptUserForLocation_u24lambda_u248.putExtra("android.intent.extra.TITLE", fileName);
        Intent intent2 = intent;
        this.createFileLauncher.launch((Object)intent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveFileToPublicDirectoryScopedStorage(String filePath, String fileName) {
        ContentResolver contentResolver = this.getApplicationContext().getContentResolver();
        Intrinsics.checkNotNull((Object)contentResolver);
        Uri uri = FileUtils.INSTANCE.createPdfDocumentUri(contentResolver, fileName);
        OutputStream outputStream = contentResolver.openOutputStream(uri);
        if (outputStream != null) {
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                OutputStream outputStream2 = (OutputStream)closeable;
                boolean bl = false;
                Long l = ByteStreamsKt.copyTo$default((InputStream)new FileInputStream(new File(filePath)), (OutputStream)outputStream2, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Context context = (Context)this;
        String string2 = this.file_saved_to_downloads;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
            string2 = null;
        }
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    private final void saveFileToPublicDirectoryLegacy(String filePath, String fileName) {
        File destinationFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), fileName);
        FilesKt.copyTo$default((File)new File(filePath), (File)destinationFile, (boolean)true, (int)0, (int)4, null);
        Context context = (Context)this;
        String string2 = this.file_saved_to_downloads;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
            string2 = null;
        }
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    protected void onDestroy() {
        super.onDestroy();
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.pdfView.closePdfRender();
    }

    private static final void onPdfError$lambda$4$lambda$3(PdfViewerActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.init();
    }

    private static final void onPdfError$lambda$4(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.runOnUiThread(() -> PdfViewerActivity.onPdfError$lambda$4$lambda$3(this$0));
    }

    private static final void requestPermissionLauncher$lambda$6$lambda$5(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        this$0.requestStoragePermission();
    }

    private static final void requestPermissionLauncher$lambda$6(PdfViewerActivity this$0, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (isGranted) {
            this$0.startDownload();
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this$0);
            String string2 = this$0.permission_required_title;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required_title");
                string2 = null;
            }
            AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
            String string3 = this$0.permission_required;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required");
                string3 = null;
            }
            AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
            String string4 = this$0.pdf_viewer_grant;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_grant");
                string4 = null;
            }
            AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.requestPermissionLauncher$lambda$6$lambda$5(this$0, arg_0, arg_1));
            String string5 = this$0.pdf_viewer_cancel;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
                string5 = null;
            }
            builder4.setNegativeButton((CharSequence)string5, null).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createFileLauncher$lambda$12(PdfViewerActivity this$0, ActivityResult result) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (result.getResultCode() != -1) break block10;
            Intent intent = result.getData();
            if (intent != null && (intent = intent.getData()) != null) {
                Intent uri = intent;
                boolean bl = false;
                OutputStream outputStream = this$0.getContentResolver().openOutputStream((Uri)uri);
                if (outputStream != null) {
                    Closeable closeable = outputStream;
                    Throwable throwable = null;
                    try {
                        Long l;
                        OutputStream outputStream2 = (OutputStream)closeable;
                        boolean bl2 = false;
                        String string2 = this$0.downloadedFilePath;
                        if (string2 != null) {
                            String filePath = string2;
                            boolean bl3 = false;
                            InputStream inputStream = new FileInputStream(new File(filePath));
                            Intrinsics.checkNotNull((Object)outputStream2);
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream2, (int)0, (int)2, null);
                        } else {
                            l = null;
                        }
                        Long l2 = l;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                Context context = (Context)this$0;
                String string3 = this$0.file_saved_successfully;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_successfully");
                    string3 = null;
                }
                Toast.makeText((Context)context, (CharSequence)string3, (int)0).show();
            }
        }
    }

    public static final /* synthetic */ void access$showProgressBar(PdfViewerActivity $this, boolean $receiver) {
        $this.showProgressBar($receiver);
    }

    public static final /* synthetic */ void access$setDownloadedFilePath$p(PdfViewerActivity $this, String string2) {
        $this.downloadedFilePath = string2;
    }

    public static final /* synthetic */ void access$onPdfError(PdfViewerActivity $this, String e) {
        $this.onPdfError(e);
    }

    static {
        SAVE_TO_DOWNLOADS = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\tJL\u0010$\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u000e\u001a\u00020\t2\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\r\u00a8\u0006("}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity$Companion;", "", "()V", "ENABLE_FILE_DOWNLOAD", "", "FILE_TITLE", "FILE_URL", "FROM_ASSETS", "SAVE_TO_DOWNLOADS", "", "getSAVE_TO_DOWNLOADS", "()Z", "setSAVE_TO_DOWNLOADS", "(Z)V", "enableDownload", "getEnableDownload", "setEnableDownload", "engine", "Lcom/rajat/pdfviewer/util/PdfEngine;", "getEngine", "()Lcom/rajat/pdfviewer/util/PdfEngine;", "setEngine", "(Lcom/rajat/pdfviewer/util/PdfEngine;)V", "isFromAssets", "setFromAssets", "isPDFFromPath", "setPDFFromPath", "launchPdfFromPath", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "path", "pdfTitle", "saveTo", "Lcom/rajat/pdfviewer/util/saveTo;", "fromAssets", "launchPdfFromUrl", "pdfUrl", "headers", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PdfEngine getEngine() {
            return engine;
        }

        public final void setEngine(@NotNull PdfEngine pdfEngine) {
            Intrinsics.checkNotNullParameter((Object)((Object)pdfEngine), (String)"<set-?>");
            engine = pdfEngine;
        }

        public final boolean getEnableDownload() {
            return enableDownload;
        }

        public final void setEnableDownload(boolean bl) {
            enableDownload = bl;
        }

        public final boolean isPDFFromPath() {
            return isPDFFromPath;
        }

        public final void setPDFFromPath(boolean bl) {
            isPDFFromPath = bl;
        }

        public final boolean isFromAssets() {
            return isFromAssets;
        }

        public final void setFromAssets(boolean bl) {
            isFromAssets = bl;
        }

        public final boolean getSAVE_TO_DOWNLOADS() {
            return SAVE_TO_DOWNLOADS;
        }

        public final void setSAVE_TO_DOWNLOADS(boolean bl) {
            SAVE_TO_DOWNLOADS = bl;
        }

        @NotNull
        public final Intent launchPdfFromUrl(@Nullable Context context, @Nullable String pdfUrl, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean enableDownload, @NotNull Map<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, pdfUrl);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload);
            intent.putExtra("headers", (Parcelable)new HeaderData(headers));
            this.setPDFFromPath(false);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromUrl$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, Map map, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            if ((n & 0x20) != 0) {
                map = MapsKt.emptyMap();
            }
            return companion.launchPdfFromUrl(context, string2, string3, saveTo2, bl, map);
        }

        @NotNull
        public final Intent launchPdfFromPath(@Nullable Context context, @Nullable String path, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean fromAssets) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, path);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, false);
            intent.putExtra(PdfViewerActivity.FROM_ASSETS, fromAssets);
            this.setPDFFromPath(true);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromPath$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.launchPdfFromPath(context, string2, string3, saveTo2, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

