/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0014J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020\u001cH\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mActivePointerId", "mGestureDetector", "Landroid/view/GestureDetector;", "mIsZoomEnabled", "", "mLastTouchX", "", "mLastTouchY", "mMaxZoom", "mPosX", "mPosY", "mScaleDetector", "Landroid/view/ScaleGestureDetector;", "mScaleFactor", "maxHeight", "maxWidth", "clampPosition", "", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "initializeScaleDetector", "onDraw", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "resetZoom", "Companion", "GestureListener", "ScaleListener", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class PinchZoomRecyclerView
extends RecyclerView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mActivePointerId;
    @Nullable
    private ScaleGestureDetector mScaleDetector;
    @Nullable
    private GestureDetector mGestureDetector;
    private float mScaleFactor;
    private boolean mIsZoomEnabled;
    private float mMaxZoom;
    private float maxWidth;
    private float maxHeight;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mPosX;
    private float mPosY;
    public static final int $stable = 8;
    private static final int INVALID_POINTER_ID = -1;
    private static final float MAX_SCALE = 3.0f;
    private static final float MAX_ZOOM = 3.0f;

    public PinchZoomRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        this.mIsZoomEnabled = true;
        this.mMaxZoom = 3.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        }
        this.initializeScaleDetector(context);
    }

    public PinchZoomRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        this.mIsZoomEnabled = true;
        this.mMaxZoom = 3.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        }
        this.initializeScaleDetector(context);
    }

    public PinchZoomRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mActivePointerId = -1;
        this.mScaleFactor = 1.0f;
        this.mIsZoomEnabled = true;
        this.mMaxZoom = 3.0f;
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        }
        this.initializeScaleDetector(context);
    }

    private final void initializeScaleDetector(Context context) {
        if (!this.isInEditMode()) {
            this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.maxWidth = this.getMeasuredWidth();
        this.maxHeight = this.getMeasuredHeight();
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        boolean superHandled = super.onTouchEvent(ev);
        GestureDetector gestureDetector = this.mGestureDetector;
        if (gestureDetector != null) {
            gestureDetector.onTouchEvent(ev);
        }
        ScaleGestureDetector scaleGestureDetector = this.mScaleDetector;
        if (scaleGestureDetector != null) {
            scaleGestureDetector.onTouchEvent(ev);
        }
        switch (ev.getAction() & 0xFF) {
            case 0: {
                this.mLastTouchX = ev.getX();
                this.mLastTouchY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (this.mScaleFactor > 1.0f) {
                    float dx = x - this.mLastTouchX;
                    float dy = y - this.mLastTouchY;
                    this.mPosX += dx;
                    this.mPosY += dy;
                    this.mPosX = RangesKt.coerceAtLeast((float)(this.maxWidth - (float)this.getWidth() * this.mScaleFactor), (float)RangesKt.coerceAtMost((float)this.mPosX, (float)0.0f));
                    this.mPosY = RangesKt.coerceAtLeast((float)(this.maxHeight - (float)this.getHeight() * this.mScaleFactor), (float)RangesKt.coerceAtMost((float)this.mPosY, (float)0.0f));
                }
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                int pointerIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.mLastTouchX = ev.getX(newPointerIndex);
                this.mLastTouchY = ev.getY(newPointerIndex);
                this.mActivePointerId = ev.getPointerId(newPointerIndex);
            }
        }
        return superHandled || this.mScaleFactor > 1.0f;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(this.mPosX, this.mPosY);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        super.onDraw(canvas);
        canvas.restore();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(this.mPosX, this.mPosY);
        canvas.scale(this.mScaleFactor, this.mScaleFactor);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    private final void resetZoom() {
        this.mScaleFactor = 1.0f;
        this.mPosX = 0.0f;
        this.mPosY = 0.0f;
    }

    private final void clampPosition() {
        float maxPosX = this.maxWidth - (float)this.getWidth() * this.mScaleFactor;
        float maxPosY = this.maxHeight - (float)this.getHeight() * this.mScaleFactor;
        this.mPosX = RangesKt.coerceAtLeast((float)maxPosX, (float)RangesKt.coerceAtMost((float)this.mPosX, (float)0.0f));
        this.mPosY = RangesKt.coerceAtLeast((float)maxPosY, (float)RangesKt.coerceAtMost((float)this.mPosY, (float)0.0f));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$Companion;", "", "()V", "INVALID_POINTER_ID", "", "MAX_SCALE", "", "MAX_ZOOM", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "pdfViewer_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (PinchZoomRecyclerView.this.mIsZoomEnabled) {
                if (PinchZoomRecyclerView.this.mScaleFactor > 1.0f) {
                    PinchZoomRecyclerView.this.resetZoom();
                } else {
                    PinchZoomRecyclerView.this.mScaleFactor = PinchZoomRecyclerView.this.mMaxZoom;
                    PinchZoomRecyclerView.this.mPosX = -(e.getX() * (PinchZoomRecyclerView.this.mMaxZoom - 1.0f));
                    PinchZoomRecyclerView.this.mPosY = -(e.getY() * (PinchZoomRecyclerView.this.mMaxZoom - 1.0f));
                    PinchZoomRecyclerView.this.clampPosition();
                }
                PinchZoomRecyclerView.this.invalidate();
            }
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/rajat/pdfviewer/PinchZoomRecyclerView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/rajat/pdfviewer/PinchZoomRecyclerView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "pdfViewer_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            float scaleFactor = RangesKt.coerceAtLeast((float)1.0f, (float)RangesKt.coerceAtMost((float)(PinchZoomRecyclerView.this.mScaleFactor * detector.getScaleFactor()), (float)3.0f));
            float focusX = detector.getFocusX();
            float focusY = detector.getFocusY();
            if (!(scaleFactor == PinchZoomRecyclerView.this.mScaleFactor)) {
                float scaleDelta = scaleFactor / PinchZoomRecyclerView.this.mScaleFactor;
                PinchZoomRecyclerView pinchZoomRecyclerView = PinchZoomRecyclerView.this;
                pinchZoomRecyclerView.mPosX = pinchZoomRecyclerView.mPosX - (focusX - PinchZoomRecyclerView.this.mPosX) * (1.0f - scaleDelta);
                pinchZoomRecyclerView = PinchZoomRecyclerView.this;
                pinchZoomRecyclerView.mPosY = pinchZoomRecyclerView.mPosY - (focusY - PinchZoomRecyclerView.this.mPosY) * (1.0f - scaleDelta);
                PinchZoomRecyclerView.this.mScaleFactor = scaleFactor;
                PinchZoomRecyclerView.this.mPosX = RangesKt.coerceAtLeast((float)(PinchZoomRecyclerView.this.maxWidth - (float)PinchZoomRecyclerView.this.getWidth() * PinchZoomRecyclerView.this.mScaleFactor), (float)RangesKt.coerceAtMost((float)PinchZoomRecyclerView.this.mPosX, (float)0.0f));
                PinchZoomRecyclerView.this.mPosY = RangesKt.coerceAtLeast((float)(PinchZoomRecyclerView.this.maxHeight - (float)PinchZoomRecyclerView.this.getHeight() * PinchZoomRecyclerView.this.mScaleFactor), (float)RangesKt.coerceAtMost((float)PinchZoomRecyclerView.this.mPosY, (float)0.0f));
                PinchZoomRecyclerView.this.invalidate();
            }
            return true;
        }
    }
}

