/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.widget.TextViewCompat;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.util.ThemeUtils;
import com.rajat.pdfviewer.util.ToolbarTitleBehavior;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0001*B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003JG\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/rajat/pdfviewer/util/ToolbarStyle;", "", "showToolbar", "", "toolbarColor", "", "backIcon", "Landroid/graphics/drawable/Drawable;", "titleTextStyle", "titleBehavior", "Lcom/rajat/pdfviewer/util/ToolbarTitleBehavior;", "downloadIconTint", "<init>", "(ZILandroid/graphics/drawable/Drawable;ILcom/rajat/pdfviewer/util/ToolbarTitleBehavior;I)V", "getShowToolbar", "()Z", "getToolbarColor", "()I", "getBackIcon", "()Landroid/graphics/drawable/Drawable;", "getTitleTextStyle", "getTitleBehavior", "()Lcom/rajat/pdfviewer/util/ToolbarTitleBehavior;", "getDownloadIconTint", "applyTo", "", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "titleView", "Landroid/widget/TextView;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class ToolbarStyle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean showToolbar;
    private final int toolbarColor;
    @Nullable
    private final Drawable backIcon;
    private final int titleTextStyle;
    @NotNull
    private final ToolbarTitleBehavior titleBehavior;
    private final int downloadIconTint;
    public static final int $stable = 8;

    public ToolbarStyle(boolean showToolbar, int toolbarColor, @Nullable Drawable backIcon, int titleTextStyle, @NotNull ToolbarTitleBehavior titleBehavior, int downloadIconTint) {
        Intrinsics.checkNotNullParameter((Object)((Object)titleBehavior), (String)"titleBehavior");
        this.showToolbar = showToolbar;
        this.toolbarColor = toolbarColor;
        this.backIcon = backIcon;
        this.titleTextStyle = titleTextStyle;
        this.titleBehavior = titleBehavior;
        this.downloadIconTint = downloadIconTint;
    }

    public final boolean getShowToolbar() {
        return this.showToolbar;
    }

    public final int getToolbarColor() {
        return this.toolbarColor;
    }

    @Nullable
    public final Drawable getBackIcon() {
        return this.backIcon;
    }

    public final int getTitleTextStyle() {
        return this.titleTextStyle;
    }

    @NotNull
    public final ToolbarTitleBehavior getTitleBehavior() {
        return this.titleBehavior;
    }

    public final int getDownloadIconTint() {
        return this.downloadIconTint;
    }

    public final void applyTo(@NotNull Toolbar toolbar, @NotNull TextView titleView) {
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Intrinsics.checkNotNullParameter((Object)titleView, (String)"titleView");
        toolbar.setBackgroundColor(this.toolbarColor);
        toolbar.setNavigationIcon(this.backIcon);
        toolbar.setVisibility(this.showToolbar ? 0 : 8);
        try {
            TextViewCompat.setTextAppearance((TextView)titleView, (int)this.titleTextStyle);
        }
        catch (Exception e) {
            TextViewCompat.setTextAppearance((TextView)titleView, (int)R.style.pdfView_titleTextAppearance);
        }
        TextView $this$applyTo_u24lambda_u240 = textView = titleView;
        boolean bl = false;
        $this$applyTo_u24lambda_u240.setSingleLine(this.titleBehavior.isSingleLine());
        $this$applyTo_u24lambda_u240.setMaxLines(this.titleBehavior.getMaxLines());
        $this$applyTo_u24lambda_u240.setEllipsize(this.titleBehavior.getEllipsize());
        if (this.titleBehavior.getEllipsize() == TextUtils.TruncateAt.MARQUEE) {
            $this$applyTo_u24lambda_u240.setFocusable(true);
            $this$applyTo_u24lambda_u240.setFocusableInTouchMode(true);
            $this$applyTo_u24lambda_u240.requestFocus();
        }
    }

    public final boolean component1() {
        return this.showToolbar;
    }

    public final int component2() {
        return this.toolbarColor;
    }

    @Nullable
    public final Drawable component3() {
        return this.backIcon;
    }

    public final int component4() {
        return this.titleTextStyle;
    }

    @NotNull
    public final ToolbarTitleBehavior component5() {
        return this.titleBehavior;
    }

    public final int component6() {
        return this.downloadIconTint;
    }

    @NotNull
    public final ToolbarStyle copy(boolean showToolbar, int toolbarColor, @Nullable Drawable backIcon, int titleTextStyle, @NotNull ToolbarTitleBehavior titleBehavior, int downloadIconTint) {
        Intrinsics.checkNotNullParameter((Object)((Object)titleBehavior), (String)"titleBehavior");
        return new ToolbarStyle(showToolbar, toolbarColor, backIcon, titleTextStyle, titleBehavior, downloadIconTint);
    }

    public static /* synthetic */ ToolbarStyle copy$default(ToolbarStyle toolbarStyle, boolean bl, int n, Drawable drawable2, int n2, ToolbarTitleBehavior toolbarTitleBehavior, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            bl = toolbarStyle.showToolbar;
        }
        if ((n4 & 2) != 0) {
            n = toolbarStyle.toolbarColor;
        }
        if ((n4 & 4) != 0) {
            drawable2 = toolbarStyle.backIcon;
        }
        if ((n4 & 8) != 0) {
            n2 = toolbarStyle.titleTextStyle;
        }
        if ((n4 & 0x10) != 0) {
            toolbarTitleBehavior = toolbarStyle.titleBehavior;
        }
        if ((n4 & 0x20) != 0) {
            n3 = toolbarStyle.downloadIconTint;
        }
        return toolbarStyle.copy(bl, n, drawable2, n2, toolbarTitleBehavior, n3);
    }

    @NotNull
    public String toString() {
        return "ToolbarStyle(showToolbar=" + this.showToolbar + ", toolbarColor=" + this.toolbarColor + ", backIcon=" + this.backIcon + ", titleTextStyle=" + this.titleTextStyle + ", titleBehavior=" + (Object)((Object)this.titleBehavior) + ", downloadIconTint=" + this.downloadIconTint + ')';
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.showToolbar);
        result = result * 31 + Integer.hashCode(this.toolbarColor);
        result = result * 31 + (this.backIcon == null ? 0 : this.backIcon.hashCode());
        result = result * 31 + Integer.hashCode(this.titleTextStyle);
        result = result * 31 + this.titleBehavior.hashCode();
        result = result * 31 + Integer.hashCode(this.downloadIconTint);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolbarStyle)) {
            return false;
        }
        ToolbarStyle toolbarStyle = (ToolbarStyle)other;
        if (this.showToolbar != toolbarStyle.showToolbar) {
            return false;
        }
        if (this.toolbarColor != toolbarStyle.toolbarColor) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.backIcon, (Object)toolbarStyle.backIcon)) {
            return false;
        }
        if (this.titleTextStyle != toolbarStyle.titleTextStyle) {
            return false;
        }
        if (this.titleBehavior != toolbarStyle.titleBehavior) {
            return false;
        }
        return this.downloadIconTint == toolbarStyle.downloadIconTint;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/rajat/pdfviewer/util/ToolbarStyle$Companion;", "", "<init>", "()V", "from", "Lcom/rajat/pdfviewer/util/ToolbarStyle;", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "pdfViewer_release"})
    @SourceDebugExtension(value={"SMAP\nToolbarStyle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarStyle.kt\ncom/rajat/pdfviewer/util/ToolbarStyle$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolbarStyle from(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(R.styleable.PdfRendererView_toolbar);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray typedArray2 = typedArray;
            boolean showToolbar = ThemeUtils.INSTANCE.getBooleanFromTypedArray(typedArray2, R.styleable.PdfRendererView_toolbar_pdfView_showToolbar, true);
            Drawable drawable2 = typedArray2.getDrawable(R.styleable.PdfRendererView_toolbar_pdfView_backIcon);
            if (drawable2 == null) {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.pdf_viewer_ic_arrow_back);
            }
            Drawable backIcon = drawable2;
            int toolbarColor = ThemeUtils.INSTANCE.getColorFromTypedArray(typedArray2, R.styleable.PdfRendererView_toolbar_pdfView_toolbarColor, ContextCompat.getColor((Context)context, (int)R.color.pdf_viewer_primary));
            int titleTextStyle = ThemeUtils.INSTANCE.getResIdFromTypedArray(typedArray2, R.styleable.PdfRendererView_toolbar_pdfView_titleTextStyle, R.style.pdfView_titleTextAppearance);
            Integer n = intent.getIntExtra("title_behavior", -1);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it != -1 ? n : null;
            int behaviorIndex = n2 != null ? n2.intValue() : typedArray2.getInt(R.styleable.PdfRendererView_toolbar_pdfView_titleBehavior, ToolbarTitleBehavior.MULTI_LINE_WRAP.ordinal());
            int downloadIconTint = ThemeUtils.INSTANCE.getColorFromTypedArray(typedArray2, R.styleable.PdfRendererView_toolbar_pdfView_downloadIconTint, ContextCompat.getColor((Context)context, (int)17170443));
            typedArray2.recycle();
            return new ToolbarStyle(showToolbar, toolbarColor, backIcon, titleTextStyle, ToolbarTitleBehavior.Companion.fromXmlValue(behaviorIndex), downloadIconTint);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

