/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.activity.EdgeToEdge;
import androidx.activity.SystemBarStyle;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.material.appbar.MaterialToolbar;
import com.rajat.pdfviewer.HeaderData;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewerActivity;
import com.rajat.pdfviewer.PdfViewerViewModel;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ActivityPdfViewerBinding;
import com.rajat.pdfviewer.util.CacheStrategy;
import com.rajat.pdfviewer.util.EdgeToEdgeHelper;
import com.rajat.pdfviewer.util.FileUtils;
import com.rajat.pdfviewer.util.NetworkUtil;
import com.rajat.pdfviewer.util.ThemeValidator;
import com.rajat.pdfviewer.util.ToolbarStyle;
import com.rajat.pdfviewer.util.ToolbarTitleBehavior;
import com.rajat.pdfviewer.util.ViewerStrings;
import com.rajat.pdfviewer.util.ViewerStyle;
import com.rajat.pdfviewer.util.saveTo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 S2\u00020\u0001:\u0001SB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J\b\u0010*\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020'H\u0002J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0002J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020#H\u0002J\u0010\u00107\u001a\u00020#2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020#H\u0007J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\u0011H\u0016J\u0012\u0010=\u001a\u00020'2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010>\u001a\u00020'2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010?\u001a\u00020'2\b\u0010@\u001a\u0004\u0018\u00010\u0005H\u0082@\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020'2\u0006\u0010C\u001a\u00020\u0005H\u0002J\f\u0010D\u001a\u00020'*\u00020#H\u0002J\b\u0010G\u001a\u00020'H\u0002J\b\u0010H\u001a\u00020'H\u0002J\u0006\u0010I\u001a\u00020'J\u0010\u0010J\u001a\u00020'2\u0006\u0010K\u001a\u00020\u0005H\u0002J\u0018\u0010N\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0005H\u0002J\u0018\u0010O\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0005H\u0002J\b\u0010P\u001a\u00020'H\u0014J\u0010\u0010Q\u001a\u00020'2\u0006\u0010R\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020M0FX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "file_not_downloaded_yet", "", "file_saved_to_downloads", "file_saved_successfully", "error_no_internet_connection", "permission_required", "permission_required_title", "error_pdf_corrupted", "pdf_viewer_retry", "pdf_viewer_grant", "pdf_viewer_cancel", "pdf_viewer_error", "menuItem", "Landroid/view/MenuItem;", "fileUrl", "headers", "Lcom/rajat/pdfviewer/HeaderData;", "binding", "Lcom/rajat/pdfviewer/databinding/ActivityPdfViewerBinding;", "viewModel", "Lcom/rajat/pdfviewer/PdfViewerViewModel;", "getViewModel", "()Lcom/rajat/pdfviewer/PdfViewerViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "downloadedFilePath", "getDownloadedFilePath", "()Ljava/lang/String;", "setDownloadedFilePath", "(Ljava/lang/String;)V", "isDownloadButtonEnabled", "", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "configureToolbar", "applyEdgeToEdge", "window", "Landroid/view/Window;", "applyThemeAttributes", "extractIntentExtras", "init", "isRetryable", "error", "", "showErrorDialog", "message", "shouldRetry", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "isDownloadButtonVisible", "onOptionsItemSelected", "item", "loadFileFromNetwork", "initPdfViewer", "initPdfViewerWithPath", "filePath", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPdfError", "e", "showProgressBar", "requestPermissionLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "requestStoragePermission", "checkAndStartDownload", "startDownload", "promptUserForLocation", "fileName", "createFileLauncher", "Landroid/content/Intent;", "saveFileToPublicDirectoryScopedStorage", "saveFileToPublicDirectoryLegacy", "onDestroy", "updateDownloadButtonState", "isEnabled", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfViewerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,552:1\n70#2,11:553\n*S KotlinDebug\n*F\n+ 1 PdfViewerActivity.kt\ncom/rajat/pdfviewer/PdfViewerActivity\n*L\n73#1:553,11\n*E\n"})
public final class PdfViewerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String file_not_downloaded_yet;
    private String file_saved_to_downloads;
    private String file_saved_successfully;
    private String error_no_internet_connection;
    private String permission_required;
    private String permission_required_title;
    private String error_pdf_corrupted;
    private String pdf_viewer_retry;
    private String pdf_viewer_grant;
    private String pdf_viewer_cancel;
    private String pdf_viewer_error;
    @Nullable
    private MenuItem menuItem;
    @Nullable
    private String fileUrl;
    private HeaderData headers;
    private ActivityPdfViewerBinding binding;
    @NotNull
    private final Lazy viewModel$delegate;
    @Nullable
    private String downloadedFilePath;
    private boolean isDownloadButtonEnabled;
    private CacheStrategy cacheStrategy;
    @NotNull
    private final ActivityResultLauncher<String> requestPermissionLauncher;
    @NotNull
    private final ActivityResultLauncher<Intent> createFileLauncher;
    public static final int $stable = 8;
    @NotNull
    public static final String FILE_URL = "pdf_file_url";
    @NotNull
    public static final String FILE_TITLE = "pdf_file_title";
    @NotNull
    public static final String ENABLE_FILE_DOWNLOAD = "enable_download";
    @NotNull
    public static final String FROM_ASSETS = "from_assests";
    @NotNull
    public static final String TITLE_BEHAVIOR = "title_behavior";
    @NotNull
    public static final String ENABLE_ZOOM = "enable_zoom";
    private static boolean enableDownload;
    private static boolean isPDFFromPath;
    private static boolean isFromAssets;
    private static boolean SAVE_TO_DOWNLOADS;
    private static boolean isZoomEnabled;
    @NotNull
    public static final String CACHE_STRATEGY = "cache_strategy";

    public PdfViewerActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final ViewModelProvider.Factory invoke() {
                return this.$this_viewModels.getDefaultViewModelProviderFactory();
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PdfViewerViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
        this.requestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PdfViewerActivity.requestPermissionLauncher$lambda$8(this, arg_0));
        this.createFileLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> PdfViewerActivity.createFileLauncher$lambda$12(this, arg_0));
    }

    private final PdfViewerViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PdfViewerViewModel)((Object)lazy.getValue());
    }

    @Nullable
    public final String getDownloadedFilePath() {
        return this.downloadedFilePath;
    }

    public final void setDownloadedFilePath(@Nullable String string2) {
        this.downloadedFilePath = string2;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.Theme_PdfView_SelectedTheme);
        ThemeValidator.INSTANCE.validatePdfViewerTheme((Context)this);
        super.onCreate(savedInstanceState);
        this.binding = ActivityPdfViewerBinding.inflate(this.getLayoutInflater());
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        this.setContentView((View)activityPdfViewerBinding.getRoot());
        if (Build.VERSION.SDK_INT >= 34) {
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            this.applyEdgeToEdge(window);
        }
        this.configureToolbar();
        this.applyThemeAttributes();
        this.extractIntentExtras();
        this.init();
    }

    private final void configureToolbar() {
        ActivityPdfViewerBinding activityPdfViewerBinding;
        ActivityPdfViewerBinding activityPdfViewerBinding2;
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        ToolbarStyle toolbarStyle = ToolbarStyle.Companion.from(context, intent);
        String string2 = this.getIntent().getStringExtra(FILE_TITLE);
        if (string2 == null) {
            string2 = "PDF";
        }
        String toolbarTitle = string2;
        try {
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.hide();
            }
        }
        catch (IllegalStateException e) {
            Log.w((String)"PdfViewer", (String)("supportActionBar check failed: " + e.getMessage()));
        }
        if ((activityPdfViewerBinding2 = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding2 = null;
        }
        activityPdfViewerBinding2.myToolbar.setVisibility(0);
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding3 = this.binding;
            if (activityPdfViewerBinding3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding3 = null;
            }
            this.setSupportActionBar((Toolbar)activityPdfViewerBinding3.myToolbar);
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setDisplayShowTitleEnabled(false);
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)"PdfViewer", (String)("Can't setSupportActionBar(): " + e.getMessage()));
        }
        if ((activityPdfViewerBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        MaterialToolbar materialToolbar = activityPdfViewerBinding.myToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)materialToolbar, (String)"myToolbar");
        Toolbar toolbar = (Toolbar)materialToolbar;
        ActivityPdfViewerBinding activityPdfViewerBinding4 = this.binding;
        if (activityPdfViewerBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding4 = null;
        }
        TextView textView = activityPdfViewerBinding4.toolbarTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"toolbarTitle");
        toolbarStyle.applyTo(toolbar, textView);
        ActivityPdfViewerBinding activityPdfViewerBinding5 = this.binding;
        if (activityPdfViewerBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding5 = null;
        }
        activityPdfViewerBinding5.toolbarTitle.setText((CharSequence)toolbarTitle);
    }

    private final void applyEdgeToEdge(Window window) {
        boolean isDarkMode = EdgeToEdgeHelper.INSTANCE.isDarkModeEnabled(this.getResources().getConfiguration().uiMode);
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        int toolbarColor = ToolbarStyle.Companion.from(context, intent).getToolbarColor();
        EdgeToEdge.enable$default((ComponentActivity)((ComponentActivity)this), (SystemBarStyle)(isDarkMode ? SystemBarStyle.Companion.dark(toolbarColor) : SystemBarStyle.Companion.light(toolbarColor, toolbarColor)), null, (int)2, null);
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        ConstraintLayout constraintLayout = activityPdfViewerBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        EdgeToEdgeHelper.applyInsets$default(EdgeToEdgeHelper.INSTANCE, window, (View)constraintLayout, isDarkMode, null, 8, null);
    }

    private final void applyThemeAttributes() {
        ViewerStyle viewerStyle = ViewerStyle.Companion.from((Context)this);
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        viewerStyle.applyTo(activityPdfViewerBinding);
    }

    private final void extractIntentExtras() {
        Object object;
        enableDownload = this.getIntent().getBooleanExtra(ENABLE_FILE_DOWNLOAD, false);
        isFromAssets = this.getIntent().getBooleanExtra(FROM_ASSETS, false);
        HeaderData headerData = Build.VERSION.SDK_INT >= 33 ? (HeaderData)this.getIntent().getParcelableExtra("headers", HeaderData.class) : (HeaderData)this.getIntent().getParcelableExtra("headers");
        if (headerData == null) {
            headerData = new HeaderData(MapsKt.emptyMap());
        }
        this.headers = headerData;
        isZoomEnabled = this.getIntent().getBooleanExtra(ENABLE_ZOOM, true);
        int strategyOrdinal = this.getIntent().getIntExtra(CACHE_STRATEGY, CacheStrategy.MAXIMIZE_PERFORMANCE.ordinal());
        PdfViewerActivity pdfViewerActivity = this;
        Object object2 = (List)CacheStrategy.getEntries();
        boolean bl = 0 <= strategyOrdinal ? strategyOrdinal < object2.size() : false;
        if (bl) {
            object = object2.get(strategyOrdinal);
        } else {
            int n = strategyOrdinal;
            PdfViewerActivity pdfViewerActivity2 = pdfViewerActivity;
            boolean bl2 = false;
            object = CacheStrategy.MAXIMIZE_PERFORMANCE;
            pdfViewerActivity = pdfViewerActivity2;
        }
        pdfViewerActivity.cacheStrategy = (CacheStrategy)((Object)object);
        Object strings = object2 = ViewerStrings.Companion.from((Context)this);
        boolean bl3 = false;
        this.error_pdf_corrupted = ((ViewerStrings)strings).getErrorPdfCorrupted();
        this.error_no_internet_connection = ((ViewerStrings)strings).getErrorNoInternet();
        this.file_saved_successfully = ((ViewerStrings)strings).getFileSavedSuccessfully();
        this.file_saved_to_downloads = ((ViewerStrings)strings).getFileSavedToDownloads();
        this.file_not_downloaded_yet = ((ViewerStrings)strings).getFileNotDownloadedYet();
        this.permission_required = ((ViewerStrings)strings).getPermissionRequired();
        this.permission_required_title = ((ViewerStrings)strings).getPermissionRequiredTitle();
        this.pdf_viewer_error = ((ViewerStrings)strings).getGenericError();
        this.pdf_viewer_retry = ((ViewerStrings)strings).getRetry();
        this.pdf_viewer_cancel = ((ViewerStrings)strings).getCancel();
        this.pdf_viewer_grant = ((ViewerStrings)strings).getGrant();
    }

    private final void init() {
        block6: {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.pdfView.setStatusListener(new PdfRendererView.StatusCallBack(this){
                final /* synthetic */ PdfViewerActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onPdfLoadStart() {
                    PdfViewerActivity.access$showProgressBar(this.this$0, true);
                    PdfViewerActivity.access$updateDownloadButtonState(this.this$0, false);
                }

                public void onPdfRenderSuccess() {
                }

                public void onPdfRenderStart() {
                }

                public void onPdfLoadProgress(int progress, long downloadedBytes, Long totalBytes) {
                    PdfViewerActivity.access$showProgressBar(this.this$0, true);
                }

                public void onPdfLoadSuccess(String absolutePath) {
                    Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                    this.this$0.runOnUiThread(() -> init.1.onPdfLoadSuccess$lambda$0(this.this$0, absolutePath));
                }

                public void onError(Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.this$0.runOnUiThread(() -> init.1.onError$lambda$1(this.this$0, error));
                }

                public void onPageChanged(int currentPage, int totalPage) {
                }

                private static final void onPdfLoadSuccess$lambda$0(PdfViewerActivity this$0, String $absolutePath) {
                    PdfViewerActivity.access$showProgressBar(this$0, false);
                    this$0.setDownloadedFilePath($absolutePath);
                    if (PdfViewerActivity.access$getMenuItem$p(this$0) == null) {
                        PdfViewerActivity.access$setDownloadButtonEnabled$p(this$0, true);
                    } else {
                        PdfViewerActivity.access$updateDownloadButtonState(this$0, true);
                    }
                }

                private static final void onError$lambda$1(PdfViewerActivity this$0, Throwable $error) {
                    PdfViewerActivity.access$showProgressBar(this$0, false);
                    ViewerStrings strings = ViewerStrings.Companion.from((Context)this$0);
                    String errorMessage = ViewerStrings.Companion.getMessageForError(strings, $error);
                    PdfViewerActivity.access$showErrorDialog(this$0, errorMessage, PdfViewerActivity.access$isRetryable(this$0, $error));
                }
            });
            Object object = this.getIntent().getExtras();
            if (object == null || (object = object.getString(FILE_URL)) == null) break block6;
            Object fileUrl = object;
            boolean bl = false;
            this.fileUrl = fileUrl;
            if (isPDFFromPath) {
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (String)fileUrl, null){
                    int label;
                    final /* synthetic */ PdfViewerActivity this$0;
                    final /* synthetic */ String $fileUrl;
                    {
                        this.this$0 = $receiver;
                        this.$fileUrl = $fileUrl;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = PdfViewerActivity.access$initPdfViewerWithPath(this.this$0, this.$fileUrl, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else if (NetworkUtil.INSTANCE.checkInternetConnection((Context)this)) {
                this.loadFileFromNetwork((String)fileUrl);
            } else {
                Context context = (Context)this;
                String string2 = this.error_no_internet_connection;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"error_no_internet_connection");
                    string2 = null;
                }
                Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRetryable(Throwable error) {
        boolean bl;
        if (error instanceof UnknownHostException) return true;
        if (error instanceof SocketTimeoutException) return true;
        String string2 = error.getMessage();
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Failed to download", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string3 = error.getMessage();
        if (string3 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"Incomplete download", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void showErrorDialog(String message, boolean shouldRetry) {
        String string2;
        ViewerStrings strings = ViewerStrings.Companion.from((Context)this);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this).setTitle((CharSequence)strings.getErrorDialogTitle()).setMessage((CharSequence)message);
        if (shouldRetry) {
            String string3 = this.pdf_viewer_retry;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_retry");
                string3 = null;
            }
            builder.setPositiveButton((CharSequence)string3, (arg_0, arg_1) -> PdfViewerActivity.showErrorDialog$lambda$3(this, arg_0, arg_1));
        }
        if ((string2 = this.pdf_viewer_cancel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
            string2 = null;
        }
        builder.setNegativeButton((CharSequence)string2, null).show();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuInflater menuInflater = this.getMenuInflater();
        Intrinsics.checkNotNullExpressionValue((Object)menuInflater, (String)"getMenuInflater(...)");
        MenuInflater inflater = menuInflater;
        inflater.inflate(R.menu.menu, menu2);
        MenuItem menuItem = this.menuItem = menu2.findItem(R.id.download);
        if (menuItem != null) {
            menuItem.setVisible(enableDownload);
        }
        Context context = (Context)this;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        ToolbarStyle toolbarStyle = ToolbarStyle.Companion.from(context, intent);
        MenuItem menuItem2 = this.menuItem;
        if (menuItem2 != null && (menuItem2 = menuItem2.getIcon()) != null && (menuItem2 = menuItem2.mutate()) != null) {
            MenuItem it = menuItem2;
            boolean bl = false;
            Drawable drawable2 = DrawableCompat.wrap((Drawable)it);
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"wrap(...)");
            Drawable wrappedIcon = drawable2;
            DrawableCompat.setTint((Drawable)wrappedIcon, (int)toolbarStyle.getDownloadIconTint());
            MenuItem menuItem3 = this.menuItem;
            if (menuItem3 != null) {
                menuItem3.setIcon(wrappedIcon);
            }
        }
        this.updateDownloadButtonState(this.isDownloadButtonEnabled);
        return true;
    }

    @TestOnly
    public final boolean isDownloadButtonVisible() {
        MenuItem menuItem = this.menuItem;
        return menuItem != null ? menuItem.isVisible() : false;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.download) {
            this.checkAndStartDownload();
            bl = true;
        } else if (n == 16908332) {
            this.finish();
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    private final void loadFileFromNetwork(String fileUrl) {
        this.initPdfViewer(fileUrl);
    }

    private final void initPdfViewer(String fileUrl) {
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            this.onPdfError("");
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding = null;
            }
            activityPdfViewerBinding.pdfView.setZoomEnabled(isZoomEnabled);
            ActivityPdfViewerBinding activityPdfViewerBinding2 = this.binding;
            if (activityPdfViewerBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                activityPdfViewerBinding2 = null;
            }
            PdfRendererView pdfRendererView = activityPdfViewerBinding2.pdfView;
            String string2 = fileUrl;
            Intrinsics.checkNotNull((Object)string2);
            HeaderData headerData = this.headers;
            if (headerData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                headerData = null;
            }
            LifecycleCoroutineScope lifecycleCoroutineScope = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this));
            Lifecycle lifecycle = this.getLifecycle();
            CacheStrategy cacheStrategy = this.cacheStrategy;
            if (cacheStrategy == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheStrategy");
                cacheStrategy = null;
            }
            pdfRendererView.initWithUrl(string2, headerData, lifecycleCoroutineScope, lifecycle, cacheStrategy);
        }
        catch (Exception e) {
            this.onPdfError(e.toString());
        }
    }

    /*
     * Exception decompiling
     */
    private final Object initPdfViewerWithPath(String var1_1, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void onPdfError(String e) {
        Log.e((String)"Pdf render error", (String)e);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        String string2 = this.pdf_viewer_error;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_error");
            string2 = null;
        }
        AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
        String string3 = this.error_pdf_corrupted;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"error_pdf_corrupted");
            string3 = null;
        }
        AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
        String string4 = this.pdf_viewer_retry;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_retry");
            string4 = null;
        }
        AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.onPdfError$lambda$6(this, arg_0, arg_1));
        String string5 = this.pdf_viewer_cancel;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
            string5 = null;
        }
        builder4.setNegativeButton((CharSequence)string5, null).show();
    }

    private final void showProgressBar(boolean $this$showProgressBar) {
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.progressBar.setVisibility($this$showProgressBar ? 0 : 8);
    }

    private final void requestStoragePermission() {
        this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private final void checkAndStartDownload() {
        if (Build.VERSION.SDK_INT < 30) {
            if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.startDownload();
            } else {
                this.requestPermissionLauncher.launch((Object)"android.permission.WRITE_EXTERNAL_STORAGE");
            }
        } else {
            this.startDownload();
        }
    }

    public final void startDownload() {
        String string2 = this.getIntent().getStringExtra(FILE_TITLE);
        if (string2 == null) {
            string2 = "downloaded_file.pdf";
        }
        String fileName = string2;
        String string3 = this.downloadedFilePath;
        if (string3 != null) {
            String filePath = string3;
            boolean bl = false;
            if (SAVE_TO_DOWNLOADS) {
                if (Build.VERSION.SDK_INT >= 29) {
                    this.saveFileToPublicDirectoryScopedStorage(filePath, fileName);
                } else {
                    this.saveFileToPublicDirectoryLegacy(filePath, fileName);
                }
            } else {
                this.promptUserForLocation(fileName);
            }
        } else {
            Context context = (Context)this;
            String string4 = this.file_not_downloaded_yet;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file_not_downloaded_yet");
                string4 = null;
            }
            Toast.makeText((Context)context, (CharSequence)string4, (int)0).show();
        }
    }

    private final void promptUserForLocation(String fileName) {
        Intent intent;
        Intent $this$promptUserForLocation_u24lambda_u2410 = intent = new Intent("android.intent.action.CREATE_DOCUMENT");
        boolean bl = false;
        $this$promptUserForLocation_u24lambda_u2410.addCategory("android.intent.category.OPENABLE");
        $this$promptUserForLocation_u24lambda_u2410.setType("application/pdf");
        $this$promptUserForLocation_u24lambda_u2410.putExtra("android.intent.extra.TITLE", fileName);
        Intent intent2 = intent;
        this.createFileLauncher.launch((Object)intent2);
    }

    private final void saveFileToPublicDirectoryScopedStorage(String filePath, String fileName) {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, fileName, filePath, null){
            int label;
            final /* synthetic */ PdfViewerActivity this$0;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $filePath;
            {
                this.this$0 = $receiver;
                this.$fileName = $fileName;
                this.$filePath = $filePath;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.this$0.getContentResolver();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getContentResolver(...)");
                        this.label = 1;
                        v1 = FileUtils.INSTANCE.createPdfDocumentUri(v0, this.$fileName, (Continuation<? super Uri>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        uri = (Uri)v1;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this.this$0, uri, this.$filePath, null){
                            int label;
                            final /* synthetic */ PdfViewerActivity this$0;
                            final /* synthetic */ Uri $uri;
                            final /* synthetic */ String $filePath;
                            {
                                this.this$0 = $receiver;
                                this.$uri = $uri;
                                this.$filePath = $filePath;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Long l;
                                        ResultKt.throwOnFailure((Object)object);
                                        OutputStream outputStream = this.this$0.getContentResolver().openOutputStream(this.$uri);
                                        if (outputStream != null) {
                                            Closeable closeable = outputStream;
                                            String string2 = this.$filePath;
                                            Throwable throwable = null;
                                            try {
                                                OutputStream outputStream2 = (OutputStream)closeable;
                                                boolean bl = false;
                                                Long l2 = Boxing.boxLong((long)ByteStreamsKt.copyTo$default((InputStream)new FileInputStream(new File(string2)), (OutputStream)outputStream2, (int)0, (int)2, null));
                                                l = l2;
                                            }
                                            catch (Throwable throwable2) {
                                                throwable = throwable2;
                                                throw throwable2;
                                            }
                                            finally {
                                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                            }
                                        } else {
                                            l = null;
                                        }
                                        return l;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Long> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl24:
                        // 2 sources

                        this.label = 3;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ PdfViewerActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Context context = (Context)this.this$0;
                                        String string2 = PdfViewerActivity.access$getFile_saved_to_downloads$p(this.this$0);
                                        if (string2 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
                                            string2 = null;
                                        }
                                        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl32
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void saveFileToPublicDirectoryLegacy(String filePath, String fileName) {
        File destinationFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), fileName);
        FilesKt.copyTo$default((File)new File(filePath), (File)destinationFile, (boolean)true, (int)0, (int)4, null);
        Context context = (Context)this;
        String string2 = this.file_saved_to_downloads;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_to_downloads");
            string2 = null;
        }
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    protected void onDestroy() {
        super.onDestroy();
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityPdfViewerBinding = null;
        }
        activityPdfViewerBinding.pdfView.closePdfRender();
    }

    private final void updateDownloadButtonState(boolean isEnabled) {
        block1: {
            this.isDownloadButtonEnabled = isEnabled;
            MenuItem menuItem = this.menuItem;
            if (menuItem == null) break block1;
            MenuItem item = menuItem;
            boolean bl = false;
            item.setEnabled(isEnabled);
            Drawable drawable2 = item.getIcon();
            if (drawable2 != null) {
                drawable2.setAlpha(isEnabled ? 255 : 100);
            }
        }
    }

    private static final void showErrorDialog$lambda$3(PdfViewerActivity this$0, DialogInterface dialogInterface, int n) {
        this$0.loadFileFromNetwork(this$0.fileUrl);
    }

    private static final void onPdfError$lambda$6$lambda$5(PdfViewerActivity this$0) {
        this$0.init();
    }

    private static final void onPdfError$lambda$6(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        this$0.runOnUiThread(() -> PdfViewerActivity.onPdfError$lambda$6$lambda$5(this$0));
    }

    private static final void requestPermissionLauncher$lambda$8$lambda$7(PdfViewerActivity this$0, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        this$0.requestStoragePermission();
    }

    private static final void requestPermissionLauncher$lambda$8(PdfViewerActivity this$0, boolean isGranted) {
        if (isGranted) {
            this$0.startDownload();
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this$0);
            String string2 = this$0.permission_required_title;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required_title");
                string2 = null;
            }
            AlertDialog.Builder builder2 = builder.setTitle((CharSequence)string2);
            String string3 = this$0.permission_required;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permission_required");
                string3 = null;
            }
            AlertDialog.Builder builder3 = builder2.setMessage((CharSequence)string3);
            String string4 = this$0.pdf_viewer_grant;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_grant");
                string4 = null;
            }
            AlertDialog.Builder builder4 = builder3.setPositiveButton((CharSequence)string4, (arg_0, arg_1) -> PdfViewerActivity.requestPermissionLauncher$lambda$8$lambda$7(this$0, arg_0, arg_1));
            String string5 = this$0.pdf_viewer_cancel;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdf_viewer_cancel");
                string5 = null;
            }
            builder4.setNegativeButton((CharSequence)string5, null).show();
        }
    }

    private static final void createFileLauncher$lambda$12(PdfViewerActivity this$0, ActivityResult result) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getResultCode() != -1) break block1;
            Intent intent = result.getData();
            if (intent != null && (intent = intent.getData()) != null) {
                Intent uri = intent;
                boolean bl = false;
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this$0))), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (Uri)uri, null){
                    int label;
                    final /* synthetic */ PdfViewerActivity this$0;
                    final /* synthetic */ Uri $uri;
                    {
                        this.this$0 = $receiver;
                        this.$uri = $uri;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = this.this$0.getDownloadedFilePath();
                                if (v0 == null) {
                                    return Unit.INSTANCE;
                                }
                                file = new File(v0);
                                v1 = this.this$0.getContentResolver().openOutputStream(this.$uri);
                                if (v1 == null) ** GOTO lbl41
                                var3_5 = v1;
                                var4_6 = null;
                                try {
                                    outputStream = (OutputStream)var3_5;
                                    $i$a$-use-PdfViewerActivity$createFileLauncher$1$1$1$1 = false;
                                    var7_11 = new FileInputStream(file);
                                    var8_12 = null;
                                    try {
                                        inputStream = (FileInputStream)var7_11;
                                        $i$a$-use-PdfViewerActivity$createFileLauncher$1$1$1$1$1 = false;
                                        var9_14 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                                    }
                                    catch (Throwable var11_16) {
                                        var8_12 = var11_16;
                                        throw var11_16;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)var7_11, (Throwable)var8_12);
                                    }
                                    var5_7 = Boxing.boxLong((long)var9_14);
                                }
                                catch (Throwable var6_9) {
                                    var4_6 = var6_9;
                                    throw var6_9;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var3_5, (Throwable)var4_6);
                                }
lbl41:
                                // 2 sources

                                this.label = 1;
                                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ PdfViewerActivity this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                Context context = (Context)this.this$0;
                                                String string2 = PdfViewerActivity.access$getFile_saved_successfully$p(this.this$0);
                                                if (string2 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"file_saved_successfully");
                                                    string2 = null;
                                                }
                                                Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                ** if (v2 != var12_2) goto lbl45
lbl44:
                                // 1 sources

                                return var12_2;
lbl45:
                                // 1 sources

                                ** GOTO lbl63
                            }
                            case 1: {
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
                                    ** GOTO lbl63
                                }
                                catch (Exception e) {
                                    Log.e((String)"PdfViewerActivity", (String)("Error saving PDF: " + e.getMessage()), (Throwable)e);
                                    this.label = 2;
                                    v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ PdfViewerActivity this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    Toast.makeText((Context)((Context)this.this$0), (CharSequence)"Failed to save PDF", (int)0).show();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (v3 == var12_2) {
                                        return var12_2;
                                    }
                                    ** GOTO lbl63
                                }
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl63:
                                // 4 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }
    }

    public static final /* synthetic */ void access$showProgressBar(PdfViewerActivity $this, boolean $receiver) {
        $this.showProgressBar($receiver);
    }

    public static final /* synthetic */ void access$updateDownloadButtonState(PdfViewerActivity $this, boolean isEnabled) {
        $this.updateDownloadButtonState(isEnabled);
    }

    public static final /* synthetic */ MenuItem access$getMenuItem$p(PdfViewerActivity $this) {
        return $this.menuItem;
    }

    public static final /* synthetic */ void access$setDownloadButtonEnabled$p(PdfViewerActivity $this, boolean bl) {
        $this.isDownloadButtonEnabled = bl;
    }

    public static final /* synthetic */ void access$showErrorDialog(PdfViewerActivity $this, String message, boolean shouldRetry) {
        $this.showErrorDialog(message, shouldRetry);
    }

    public static final /* synthetic */ boolean access$isRetryable(PdfViewerActivity $this, Throwable error) {
        return $this.isRetryable(error);
    }

    public static final /* synthetic */ Object access$initPdfViewerWithPath(PdfViewerActivity $this, String filePath, Continuation $completion) {
        return $this.initPdfViewerWithPath(filePath, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ String access$getFile_saved_to_downloads$p(PdfViewerActivity $this) {
        return $this.file_saved_to_downloads;
    }

    public static final /* synthetic */ String access$getFile_saved_successfully$p(PdfViewerActivity $this) {
        return $this.file_saved_successfully;
    }

    static {
        SAVE_TO_DOWNLOADS = true;
        isZoomEnabled = true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jl\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010#\u001a\u00020\f2\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020)JV\u0010*\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010+\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010,\u001a\u00020\f2\b\b\u0002\u0010#\u001a\u00020\f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity$Companion;", "", "<init>", "()V", "FILE_URL", "", "FILE_TITLE", "ENABLE_FILE_DOWNLOAD", "FROM_ASSETS", "TITLE_BEHAVIOR", "ENABLE_ZOOM", "enableDownload", "", "getEnableDownload", "()Z", "setEnableDownload", "(Z)V", "isPDFFromPath", "setPDFFromPath", "isFromAssets", "setFromAssets", "SAVE_TO_DOWNLOADS", "getSAVE_TO_DOWNLOADS", "setSAVE_TO_DOWNLOADS", "isZoomEnabled", "setZoomEnabled", "CACHE_STRATEGY", "launchPdfFromUrl", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "pdfUrl", "pdfTitle", "saveTo", "Lcom/rajat/pdfviewer/util/saveTo;", "enableZoom", "headers", "", "toolbarTitleBehavior", "Lcom/rajat/pdfviewer/util/ToolbarTitleBehavior;", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "launchPdfFromPath", "path", "fromAssets", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getEnableDownload() {
            return enableDownload;
        }

        public final void setEnableDownload(boolean bl) {
            enableDownload = bl;
        }

        public final boolean isPDFFromPath() {
            return isPDFFromPath;
        }

        public final void setPDFFromPath(boolean bl) {
            isPDFFromPath = bl;
        }

        public final boolean isFromAssets() {
            return isFromAssets;
        }

        public final void setFromAssets(boolean bl) {
            isFromAssets = bl;
        }

        public final boolean getSAVE_TO_DOWNLOADS() {
            return SAVE_TO_DOWNLOADS;
        }

        public final void setSAVE_TO_DOWNLOADS(boolean bl) {
            SAVE_TO_DOWNLOADS = bl;
        }

        public final boolean isZoomEnabled() {
            return isZoomEnabled;
        }

        public final void setZoomEnabled(boolean bl) {
            isZoomEnabled = bl;
        }

        @NotNull
        public final Intent launchPdfFromUrl(@Nullable Context context, @Nullable String pdfUrl, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean enableDownload, boolean enableZoom, @NotNull Map<String, String> headers, @Nullable ToolbarTitleBehavior toolbarTitleBehavior, @NotNull CacheStrategy cacheStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, pdfUrl);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload);
            intent.putExtra("headers", (Parcelable)new HeaderData(headers));
            intent.putExtra(PdfViewerActivity.ENABLE_ZOOM, enableZoom);
            ToolbarTitleBehavior toolbarTitleBehavior2 = toolbarTitleBehavior;
            if (toolbarTitleBehavior2 != null) {
                ToolbarTitleBehavior it = toolbarTitleBehavior2;
                boolean bl = false;
                intent.putExtra(PdfViewerActivity.TITLE_BEHAVIOR, it.ordinal());
            }
            intent.putExtra(PdfViewerActivity.CACHE_STRATEGY, cacheStrategy.ordinal());
            this.setPDFFromPath(false);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromUrl$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, boolean bl2, Map map, ToolbarTitleBehavior toolbarTitleBehavior, CacheStrategy cacheStrategy, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x80) != 0) {
                toolbarTitleBehavior = null;
            }
            if ((n & 0x100) != 0) {
                cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
            }
            return companion.launchPdfFromUrl(context, string2, string3, saveTo2, bl, bl2, map, toolbarTitleBehavior, cacheStrategy);
        }

        @NotNull
        public final Intent launchPdfFromPath(@Nullable Context context, @Nullable String path, @Nullable String pdfTitle, @NotNull saveTo saveTo2, boolean fromAssets, boolean enableZoom, @Nullable ToolbarTitleBehavior toolbarTitleBehavior, @NotNull CacheStrategy cacheStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)saveTo2), (String)"saveTo");
            Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, path);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, false);
            intent.putExtra(PdfViewerActivity.FROM_ASSETS, fromAssets);
            ToolbarTitleBehavior toolbarTitleBehavior2 = toolbarTitleBehavior;
            if (toolbarTitleBehavior2 != null) {
                ToolbarTitleBehavior it = toolbarTitleBehavior2;
                boolean bl = false;
                intent.putExtra(PdfViewerActivity.TITLE_BEHAVIOR, it.ordinal());
            }
            intent.putExtra(PdfViewerActivity.ENABLE_ZOOM, enableZoom);
            intent.putExtra(PdfViewerActivity.CACHE_STRATEGY, cacheStrategy.ordinal());
            this.setPDFFromPath(true);
            this.setSAVE_TO_DOWNLOADS(saveTo2 == saveTo.DOWNLOADS);
            return intent;
        }

        public static /* synthetic */ Intent launchPdfFromPath$default(Companion companion, Context context, String string2, String string3, saveTo saveTo2, boolean bl, boolean bl2, ToolbarTitleBehavior toolbarTitleBehavior, CacheStrategy cacheStrategy, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                toolbarTitleBehavior = null;
            }
            if ((n & 0x80) != 0) {
                cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
            }
            return companion.launchPdfFromPath(context, string2, string3, saveTo2, bl, bl2, toolbarTitleBehavior, cacheStrategy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

