/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.util.TypedValue;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/rajat/pdfviewer/util/ThemeValidator;", "", "()V", "hasLoggedOnce", "", "validatePdfViewerTheme", "", "context", "Landroid/content/Context;", "validateThemeAttributes", "attrs", "", "", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nThemeValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeValidator.kt\ncom/rajat/pdfviewer/util/ThemeValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1855#2,2:36\n*S KotlinDebug\n*F\n+ 1 ThemeValidator.kt\ncom/rajat/pdfviewer/util/ThemeValidator\n*L\n17#1:36,2\n*E\n"})
public final class ThemeValidator {
    @NotNull
    public static final ThemeValidator INSTANCE = new ThemeValidator();
    private static boolean hasLoggedOnce;
    public static final int $stable;

    private ThemeValidator() {
    }

    public final void validateThemeAttributes(@NotNull Context context, @NotNull List<Integer> attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (hasLoggedOnce) {
            return;
        }
        hasLoggedOnce = true;
        Resources.Theme theme = context.getTheme();
        Iterable $this$forEach$iv = attrs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int attr2 = ((Number)element$iv).intValue();
            boolean bl = false;
            TypedValue resolved = new TypedValue();
            boolean success = theme.resolveAttribute(attr2, resolved, true);
            if (success) continue;
            Log.w((String)"PdfViewerTheme", (String)("\u26a0\ufe0f Missing theme attribute: " + context.getResources().getResourceName(attr2)));
        }
    }

    public final void validatePdfViewerTheme(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new Integer[]{0x1010031, R.attr.pdfView_toolbarColor, R.attr.pdfView_backgroundColor, R.attr.pdfView_titleTextStyle};
        this.validateThemeAttributes(context, CollectionsKt.listOf((Object[])objectArray));
    }

    static {
        $stable = 8;
    }
}

