/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.util.LruCache;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.util.CacheHelper;
import com.rajat.pdfviewer.util.CacheStrategy;
import com.rajat.pdfviewer.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000eJ\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/rajat/pdfviewer/util/CacheManager;", "", "context", "Landroid/content/Context;", "currentOpenedFileName", "", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "(Landroid/content/Context;Ljava/lang/String;Lcom/rajat/pdfviewer/util/CacheStrategy;)V", "cacheDir", "Ljava/io/File;", "memoryCache", "Landroid/util/LruCache;", "", "Landroid/graphics/Bitmap;", "addBitmapToCache", "", "pageNo", "bitmap", "createMemoryCache", "decodeBitmapFromDiskCache", "getBitmapFromCache", "pageExistsInCache", "", "writeBitmapToCache", "Companion", "pdfViewer_release"})
@StabilityInferred(parameters=0)
public final class CacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LruCache<Integer, Bitmap> memoryCache;
    @NotNull
    private final File cacheDir;
    public static final int $stable = 8;
    @NotNull
    public static final String CACHE_PATH = "___pdf___cache___";

    public CacheManager(@NotNull Context context, @NotNull String currentOpenedFileName, @NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentOpenedFileName, (String)"currentOpenedFileName");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
        this.memoryCache = this.createMemoryCache();
        this.cacheDir = new File(context.getCacheDir(), "___pdf___cache___/" + currentOpenedFileName);
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        CacheHelper.INSTANCE.handleCacheStrategy("CacheManager", this.cacheDir, cacheStrategy, currentOpenedFileName, 5);
    }

    public /* synthetic */ CacheManager(Context context, String string2, CacheStrategy cacheStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            cacheStrategy = CacheStrategy.MAXIMIZE_PERFORMANCE;
        }
        this(context, string2, cacheStrategy);
    }

    private final LruCache<Integer, Bitmap> createMemoryCache() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / (long)1024);
        int cacheSize = maxMemory / 6;
        return (LruCache)new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(int key, @NotNull Bitmap value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getByteCount() / 1024;
            }
        };
    }

    @Nullable
    public final Bitmap getBitmapFromCache(int pageNo) {
        Bitmap bitmap = (Bitmap)this.memoryCache.get((Object)pageNo);
        if (bitmap == null) {
            Bitmap bitmap2 = this.decodeBitmapFromDiskCache(pageNo);
            if (bitmap2 != null) {
                Bitmap bitmap3;
                Bitmap it = bitmap3 = bitmap2;
                boolean bl = false;
                this.memoryCache.put((Object)pageNo, (Object)it);
                bitmap = bitmap3;
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private final Bitmap decodeBitmapFromDiskCache(int pageNo) {
        File file = new File(this.cacheDir, FileUtils.cachedFileNameWithFormat$default(FileUtils.INSTANCE, pageNo, null, 2, null));
        return file.exists() ? BitmapFactory.decodeFile((String)file.getAbsolutePath()) : null;
    }

    public final void addBitmapToCache(int pageNo, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.memoryCache.put((Object)pageNo, (Object)bitmap);
        this.writeBitmapToCache(pageNo, bitmap);
    }

    private final void writeBitmapToCache(int pageNo, Bitmap bitmap) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pageNo, bitmap, null){
            int label;
            final /* synthetic */ CacheManager this$0;
            final /* synthetic */ int $pageNo;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$pageNo = $pageNo;
                this.$bitmap = $bitmap;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            if (!CacheManager.access$getCacheDir$p(this.this$0).exists()) {
                                CacheManager.access$getCacheDir$p(this.this$0).mkdirs();
                            }
                            File savePath = new File(CacheManager.access$getCacheDir$p(this.this$0), FileUtils.cachedFileNameWithFormat$default(FileUtils.INSTANCE, Boxing.boxInt((int)this.$pageNo), null, 2, null));
                            File file = savePath.getParentFile();
                            if (file != null) {
                                File it = file;
                                boolean bl = false;
                                if (!it.exists()) {
                                    it.mkdirs();
                                }
                            }
                            Closeable closeable = new FileOutputStream(savePath);
                            Bitmap bitmap = this.$bitmap;
                            Throwable throwable = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)closeable;
                                boolean bl = false;
                                boolean bl2 = bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)"CacheManager", (String)"Error writing bitmap to cache", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean pageExistsInCache(int pageNo) {
        return new File(this.cacheDir, FileUtils.cachedFileNameWithFormat$default(FileUtils.INSTANCE, pageNo, null, 2, null)).exists();
    }

    public static final /* synthetic */ File access$getCacheDir$p(CacheManager $this) {
        return $this.cacheDir;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/rajat/pdfviewer/util/CacheManager$Companion;", "", "()V", "CACHE_PATH", "", "pdfViewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

