/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.util.CacheStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/rajat/pdfviewer/util/CacheHelper;", "", "()V", "clearAllPreviousCache", "", "origin", "", "cacheDir", "Ljava/io/File;", "keepFileName", "enforceCacheLimit", "maxCachedPdfs", "", "handleCacheStrategy", "cacheStrategy", "Lcom/rajat/pdfviewer/util/CacheStrategy;", "newFileName", "updateCacheAccessTime", "pdfViewer_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCacheHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheHelper.kt\ncom/rajat/pdfviewer/util/CacheHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n13309#2,2:69\n3792#2:71\n4307#2,2:72\n2333#3,14:74\n*S KotlinDebug\n*F\n+ 1 CacheHelper.kt\ncom/rajat/pdfviewer/util/CacheHelper\n*L\n37#1:69,2\n53#1:71\n53#1:72,2\n56#1:74,14\n*E\n"})
public final class CacheHelper {
    @NotNull
    public static final CacheHelper INSTANCE = new CacheHelper();
    public static final int $stable;

    private CacheHelper() {
    }

    public final void handleCacheStrategy(@NotNull String origin, @NotNull File cacheDir, @NotNull CacheStrategy cacheStrategy, @NotNull String newFileName, int maxCachedPdfs) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheStrategy), (String)"cacheStrategy");
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        Log.d((String)"CacheHelper", (String)('[' + origin + "] Cache Strategy: " + (Object)((Object)cacheStrategy) + " | Directory: " + cacheDir + " | File: " + newFileName));
        switch (WhenMappings.$EnumSwitchMapping$0[cacheStrategy.ordinal()]) {
            case 1: {
                this.clearAllPreviousCache(origin, cacheDir, newFileName);
                break;
            }
            case 2: {
                this.updateCacheAccessTime(cacheDir);
                this.enforceCacheLimit(origin, cacheDir, maxCachedPdfs);
            }
        }
    }

    private final void clearAllPreviousCache(String origin, File cacheDir, String keepFileName) {
        File[] cachedFiles;
        File file = cacheDir.getParentFile();
        Object object = file != null ? file.listFiles() : null;
        if (object == null) {
            return;
        }
        File[] $this$forEach$iv = cachedFiles = object;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File file2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Log.d((String)"CacheHelper", (String)("From " + origin + " : Deleting old cached file: " + file2.getAbsolutePath()));
            if (Intrinsics.areEqual((Object)file2.getName(), (Object)keepFileName)) continue;
            Intrinsics.checkNotNull((Object)file2);
            FilesKt.deleteRecursively((File)file2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enforceCacheLimit(String origin, File cacheDir, int maxCachedPdfs) {
        block9: {
            Object v1;
            Collection destination$iv$iv;
            File[] fileArray = cacheDir.getParentFile();
            if (fileArray != null && (fileArray = fileArray.listFiles()) != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
            } else {
                return;
            }
            List cachedFolders = (List)destination$iv$iv;
            if (cachedFolders.size() < Math.max(maxCachedPdfs, 1)) break block9;
            Iterable $this$minByOrNull$iv = cachedFolders;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    File it = (File)minElem$iv;
                    boolean bl = false;
                    long minValue$iv = it.lastModified();
                    do {
                        Object e$iv = iterator$iv.next();
                        File it2 = (File)e$iv;
                        $i$a$-minByOrNull-CacheHelper$enforceCacheLimit$1 = false;
                        long v$iv = it2.lastModified();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            File file = v1;
            if (file != null) {
                File it = file;
                boolean bl = false;
                Log.d((String)"CacheHelper", (String)('[' + origin + "] Evicting old cached folder: " + it.getAbsolutePath()));
                FilesKt.deleteRecursively((File)it);
            }
        }
    }

    private final void updateCacheAccessTime(File cacheDir) {
        cacheDir.setLastModified(System.currentTimeMillis());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CacheStrategy.values().length];
            try {
                nArray[CacheStrategy.MINIMIZE_CACHE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheStrategy.MAXIMIZE_PERFORMANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

