/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.HeaderData;
import com.rajat.pdfviewer.PdfDownloader;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewAdapter;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.util.PdfEngine;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001(\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001XB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00104\u001a\u00020\u001dH\u0002J\u0006\u00105\u001a\u00020\u001dJ\u001a\u00106\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\bJ\f\u0010;\u001a\b\u0012\u0004\u0012\u0002090<J\u0010\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010=\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010B\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020AJ\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020EJ(\u0010F\u001a\u00020\u001d2\u0006\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020\u001d2\u0006\u0010P\u001a\u00020\bJ\u0012\u0010Q\u001a\u00020\u001d2\b\u0010R\u001a\u0004\u0018\u00010SH\u0014J\n\u0010T\u001a\u0004\u0018\u00010SH\u0014J\u0010\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020WH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u000e\u0010*\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006Y"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView;", "Landroid/widget/FrameLayout;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "disableScreenshots", "", "divider", "Landroid/graphics/drawable/Drawable;", "enableLoadingForPages", "engine", "Lcom/rajat/pdfviewer/util/PdfEngine;", "pageMargin", "Landroid/graphics/Rect;", "pageNo", "Landroid/widget/TextView;", "pdfRendererCore", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pdfRendererCoreInitialised", "pdfViewAdapter", "Lcom/rajat/pdfviewer/PdfViewAdapter;", "positionToUseForState", "postInitializationAction", "Lkotlin/Function0;", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "setRecyclerView", "(Landroidx/recyclerview/widget/RecyclerView;)V", "restoredScrollPosition", "runnable", "Ljava/lang/Runnable;", "scrollListener", "com/rajat/pdfviewer/PdfRendererView$scrollListener$1", "Lcom/rajat/pdfviewer/PdfRendererView$scrollListener$1;", "showDivider", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "getStatusListener", "()Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "setStatusListener", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "totalPageCount", "getTotalPageCount", "()I", "applyScreenshotSecurity", "closePdfRender", "getAttrs", "defStyle", "getBitmapByPage", "Landroid/graphics/Bitmap;", "page", "getLoadedBitmaps", "", "init", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "file", "Ljava/io/File;", "initWithFile", "initWithUri", "uri", "Landroid/net/Uri;", "initWithUrl", "url", "", "headers", "Lcom/rajat/pdfviewer/HeaderData;", "lifecycleCoroutineScope", "Landroidx/lifecycle/LifecycleCoroutineScope;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "jumpToPage", "pageNumber", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setTypeArray", "typedArray", "Landroid/content/res/TypedArray;", "StatusCallBack", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPdfRendererView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfRendererView.kt\ncom/rajat/pdfviewer/PdfRendererView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1#2:296\n1#2:309\n1109#3,2:297\n1603#4,9:299\n1855#4:308\n1856#4:310\n1612#4:311\n*S KotlinDebug\n*F\n+ 1 PdfRendererView.kt\ncom/rajat/pdfviewer/PdfRendererView\n*L\n290#1:309\n257#1:297,2\n290#1:299,9\n290#1:308\n290#1:310\n290#1:311\n*E\n"})
public final class PdfRendererView
extends FrameLayout
implements LifecycleObserver {
    public RecyclerView recyclerView;
    private TextView pageNo;
    private PdfRendererCore pdfRendererCore;
    private PdfViewAdapter pdfViewAdapter;
    @NotNull
    private PdfEngine engine;
    private boolean showDivider;
    @Nullable
    private Drawable divider;
    @NotNull
    private Runnable runnable;
    private boolean enableLoadingForPages;
    private boolean pdfRendererCoreInitialised;
    @NotNull
    private Rect pageMargin;
    @Nullable
    private StatusCallBack statusListener;
    private int positionToUseForState;
    private int restoredScrollPosition;
    private boolean disableScreenshots;
    @Nullable
    private Function0<Unit> postInitializationAction;
    @NotNull
    private final scrollListener.1 scrollListener;
    public static final int $stable = 8;

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.engine = PdfEngine.INTERNAL;
        this.showDivider = true;
        this.runnable = PdfRendererView::runnable$lambda$0;
        this.pageMargin = new Rect(0, 0, 0, 0);
        this.restoredScrollPosition = -1;
        this.getAttrs(attrs, defStyleAttr);
        this.scrollListener = new RecyclerView.OnScrollListener(this, context){
            private int lastFirstVisiblePosition;
            private int lastCompletelyVisiblePosition;
            final /* synthetic */ PdfRendererView this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.lastFirstVisiblePosition = -1;
                this.lastCompletelyVisiblePosition = -1;
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                boolean isPositionChanged;
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
                int firstVisiblePosition = layoutManager2.findFirstVisibleItemPosition();
                int firstCompletelyVisiblePosition = layoutManager2.findFirstCompletelyVisibleItemPosition();
                boolean bl = isPositionChanged = firstVisiblePosition != this.lastFirstVisiblePosition || firstCompletelyVisiblePosition != this.lastCompletelyVisiblePosition;
                if (isPositionChanged) {
                    int positionToUse = firstCompletelyVisiblePosition != -1 ? firstCompletelyVisiblePosition : firstVisiblePosition;
                    PdfRendererView.access$setPositionToUseForState$p(this.this$0, positionToUse);
                    this.updatePageNumberDisplay(positionToUse);
                    this.lastFirstVisiblePosition = firstVisiblePosition;
                    this.lastCompletelyVisiblePosition = firstCompletelyVisiblePosition;
                } else {
                    PdfRendererView.access$setPositionToUseForState$p(this.this$0, firstVisiblePosition);
                }
            }

            private final void updatePageNumberDisplay(int position) {
                block5: {
                    if (position == -1) break block5;
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    Object[] objectArray = new Object[]{position + 1, this.this$0.getTotalPageCount()};
                    textView.setText((CharSequence)this.$context.getString(R.string.pdfView_page_no, objectArray));
                    TextView textView2 = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView2 = null;
                    }
                    textView2.setVisibility(0);
                    if (position == 0) {
                        TextView textView3 = PdfRendererView.access$getPageNo$p(this.this$0);
                        if (textView3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                            textView3 = null;
                        }
                        textView3.postDelayed(() -> scrollListener.1.updatePageNumberDisplay$lambda$0(this.this$0), 3000L);
                    }
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack != null) {
                        statusCallBack.onPageChanged(position, this.this$0.getTotalPageCount());
                    }
                }
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    textView.postDelayed(PdfRendererView.access$getRunnable$p(this.this$0), 3000L);
                } else {
                    TextView textView = PdfRendererView.access$getPageNo$p(this.this$0);
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                        textView = null;
                    }
                    textView.removeCallbacks(PdfRendererView.access$getRunnable$p(this.this$0));
                }
            }

            private static final void updatePageNumberDisplay$lambda$0(PdfRendererView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                TextView textView = PdfRendererView.access$getPageNo$p(this$0);
                if (textView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
                    textView = null;
                }
                textView.setVisibility(8);
            }
        };
    }

    public /* synthetic */ PdfRendererView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final RecyclerView getRecyclerView() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            return recyclerView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        return null;
    }

    public final void setRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"<set-?>");
        this.recyclerView = recyclerView;
    }

    @Nullable
    public final StatusCallBack getStatusListener() {
        return this.statusListener;
    }

    public final void setStatusListener(@Nullable StatusCallBack statusCallBack) {
        this.statusListener = statusCallBack;
    }

    public final int getTotalPageCount() {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        return pdfRendererCore.getPageCount();
    }

    public final void initWithUrl(@NotNull String url, @NotNull HeaderData headers, @NotNull LifecycleCoroutineScope lifecycleCoroutineScope, @NotNull Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)lifecycleCoroutineScope, (String)"lifecycleCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        lifecycle.addObserver((LifecycleObserver)this);
        new PdfDownloader((CoroutineScope)lifecycleCoroutineScope, headers, url, new PdfDownloader.StatusListener(this){
            final /* synthetic */ PdfRendererView this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Context getContext() {
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                return context;
            }

            public void onDownloadStart() {
                block0: {
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onPdfLoadStart();
                }
            }

            public void onDownloadProgress(long currentBytes, long totalBytes) {
                block1: {
                    int progress = (int)((float)currentBytes / (float)totalBytes * 100.0f);
                    if (progress >= 100) {
                        progress = 100;
                    }
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block1;
                    statusCallBack.onPdfLoadProgress(progress, currentBytes, totalBytes);
                }
            }

            public void onDownloadSuccess(@NotNull String absolutePath) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                    this.this$0.initWithFile(new File(absolutePath));
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onPdfLoadSuccess(absolutePath);
                }
            }

            public void onError(@NotNull Throwable error) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    error.printStackTrace();
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onError(error);
                }
            }
        });
    }

    public static /* synthetic */ void initWithUrl$default(PdfRendererView pdfRendererView, String string2, HeaderData headerData, LifecycleCoroutineScope lifecycleCoroutineScope, Lifecycle lifecycle, int n, Object object) {
        if ((n & 2) != 0) {
            headerData = new HeaderData(null, 1, null);
        }
        pdfRendererView.initWithUrl(string2, headerData, lifecycleCoroutineScope, lifecycle);
    }

    public final void initWithFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.init(file);
    }

    public final void initWithUri(@NotNull Uri uri) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ParcelFileDescriptor parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(uri, "r");
        if (parcelFileDescriptor == null) {
            return;
        }
        ParcelFileDescriptor fileDescriptor = parcelFileDescriptor;
        this.init(fileDescriptor);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle savedState = new Bundle();
        savedState.putParcelable("superState", superState);
        if (this.recyclerView != null) {
            savedState.putInt("scrollPosition", this.positionToUseForState);
        }
        return (Parcelable)savedState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable savedState = state;
        if (savedState instanceof Bundle) {
            Parcelable superState = Build.VERSION.SDK_INT >= 33 ? (Parcelable)((Bundle)savedState).getParcelable("superState", Parcelable.class) : ((Bundle)savedState).getParcelable("superState");
            super.onRestoreInstanceState(superState);
            this.restoredScrollPosition = ((Bundle)savedState).getInt("scrollPosition", this.positionToUseForState);
        } else {
            super.onRestoreInstanceState(savedState);
        }
    }

    private final void init(File file) {
        ParcelFileDescriptor fileDescriptor = PdfRendererCore.Companion.getFileDescriptor$pdfViewer_release(file);
        this.init(fileDescriptor);
    }

    private final void init(ParcelFileDescriptor fileDescriptor) {
        RecyclerView recyclerView;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.pdfRendererCore = new PdfRendererCore(context, fileDescriptor);
        this.pdfRendererCoreInitialised = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        this.pdfViewAdapter = new PdfViewAdapter(context2, pdfRendererCore, this.pageMargin, this.enableLoadingForPages);
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.setRecyclerView((RecyclerView)view);
        View view2 = this.findViewById(R.id.pageNumber);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.pageNo = (TextView)view2;
        RecyclerView $this$init_u24lambda_u244 = recyclerView = this.getRecyclerView();
        boolean bl = false;
        PdfViewAdapter pdfViewAdapter = this.pdfViewAdapter;
        if (pdfViewAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfViewAdapter");
            pdfViewAdapter = null;
        }
        $this$init_u24lambda_u244.setAdapter((RecyclerView.Adapter)pdfViewAdapter);
        $this$init_u24lambda_u244.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$init_u24lambda_u244.getContext(), 1, false));
        $this$init_u24lambda_u244.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (this.showDivider) {
            DividerItemDecoration dividerItemDecoration;
            DividerItemDecoration $this$init_u24lambda_u244_u24lambda_u242 = dividerItemDecoration = new DividerItemDecoration($this$init_u24lambda_u244.getContext(), 1);
            boolean bl2 = false;
            Drawable drawable = this.divider;
            if (drawable != null) {
                Drawable it = drawable;
                boolean bl3 = false;
                $this$init_u24lambda_u244_u24lambda_u242.setDrawable(it);
            }
            DividerItemDecoration it = dividerItemDecoration;
            boolean bl4 = false;
            $this$init_u24lambda_u244.addItemDecoration((RecyclerView.ItemDecoration)it);
        }
        $this$init_u24lambda_u244.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        new Handler(Looper.getMainLooper()).postDelayed(() -> PdfRendererView.init$lambda$5(this), 500L);
        this.runnable = () -> PdfRendererView.init$lambda$6(this);
        this.getRecyclerView().post(() -> PdfRendererView.init$lambda$7(this));
    }

    public final void jumpToPage(int pageNumber) {
        Function0 action2 = (Function0)new Function0<Unit>(pageNumber, this){
            final /* synthetic */ int $pageNumber;
            final /* synthetic */ PdfRendererView this$0;
            {
                this.$pageNumber = $pageNumber;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                boolean bl = 0 <= this.$pageNumber ? this.$pageNumber < this.this$0.getTotalPageCount() : false;
                if (bl) {
                    this.this$0.getRecyclerView().post(() -> jumpToPage.action.1.invoke$lambda$0(this.this$0, this.$pageNumber));
                }
            }

            private static final void invoke$lambda$0(PdfRendererView this$0, int $pageNumber) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                this$0.getRecyclerView().scrollToPosition($pageNumber);
            }
        };
        if (this.pdfRendererCore != null) {
            action2.invoke();
        } else {
            this.postInitializationAction = action2;
        }
    }

    private final void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PdfRendererView, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        this.setTypeArray(typedArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final void setTypeArray(TypedArray typedArray) {
        void $this$setTypeArray_u24lambda_u249;
        Rect rect;
        void element$iv;
        PdfRendererView pdfRendererView;
        block2: {
            void $this$first$iv;
            int engineValue = typedArray.getInt(R.styleable.PdfRendererView_pdfView_engine, PdfEngine.INTERNAL.getValue());
            PdfEngine[] pdfEngineArray = PdfEngine.values();
            pdfRendererView = this;
            boolean $i$f$first = false;
            int n = ((void)$this$first$iv).length;
            for (int i = 0; i < n; ++i) {
                void it = element$iv = $this$first$iv[i];
                boolean bl = false;
                if (!(it.getValue() == engineValue)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        pdfRendererView.engine = element$iv;
        this.showDivider = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_showDivider, true);
        this.divider = typedArray.getDrawable(R.styleable.PdfRendererView_pdfView_divider);
        this.enableLoadingForPages = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_enableLoadingForPages, this.enableLoadingForPages);
        int marginDim = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_margin, 0);
        Rect rect2 = rect = new Rect(marginDim, marginDim, marginDim, marginDim);
        pdfRendererView = this;
        boolean bl = false;
        $this$setTypeArray_u24lambda_u249.top = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginTop, $this$setTypeArray_u24lambda_u249.top);
        $this$setTypeArray_u24lambda_u249.left = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginLeft, $this$setTypeArray_u24lambda_u249.left);
        $this$setTypeArray_u24lambda_u249.right = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginRight, $this$setTypeArray_u24lambda_u249.right);
        $this$setTypeArray_u24lambda_u249.bottom = typedArray.getDimensionPixelSize(R.styleable.PdfRendererView_pdfView_page_marginBottom, $this$setTypeArray_u24lambda_u249.bottom);
        pdfRendererView.pageMargin = rect;
        this.disableScreenshots = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_disableScreenshots, false);
        this.applyScreenshotSecurity();
        typedArray.recycle();
    }

    private final void applyScreenshotSecurity() {
        block0: {
            Context context;
            Activity activity;
            if (!this.disableScreenshots || (activity = (context = this.getContext()) instanceof Activity ? (Activity)context : null) == null || (activity = activity.getWindow()) == null) break block0;
            activity.addFlags(8192);
        }
    }

    public final void closePdfRender() {
        if (this.pdfRendererCoreInitialised) {
            PdfRendererCore pdfRendererCore = this.pdfRendererCore;
            if (pdfRendererCore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
                pdfRendererCore = null;
            }
            pdfRendererCore.closePdfRender();
            this.pdfRendererCoreInitialised = false;
        }
    }

    @Nullable
    public final Bitmap getBitmapByPage(int page) {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        return pdfRendererCore.getBitmapFromCache$pdfViewer_release(page);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bitmap> getLoadedBitmaps() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)this.getTotalPageCount());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Bitmap it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int page = element$iv$iv;
            boolean bl2 = false;
            if (this.getBitmapByPage(page) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void runnable$lambda$0() {
    }

    private static final void init$lambda$5(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.restoredScrollPosition != -1) {
            this$0.getRecyclerView().scrollToPosition(this$0.restoredScrollPosition);
            this$0.restoredScrollPosition = -1;
        }
    }

    private static final void init$lambda$6(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TextView textView = this$0.pageNo;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageNo");
            textView = null;
        }
        textView.setVisibility(8);
    }

    private static final void init$lambda$7(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function0<Unit> function0 = this$0.postInitializationAction;
        if (function0 != null) {
            function0.invoke();
        }
        this$0.postInitializationAction = null;
    }

    public static final /* synthetic */ void access$setPositionToUseForState$p(PdfRendererView $this, int n) {
        $this.positionToUseForState = n;
    }

    public static final /* synthetic */ TextView access$getPageNo$p(PdfRendererView $this) {
        return $this.pageNo;
    }

    public static final /* synthetic */ Runnable access$getRunnable$p(PdfRendererView $this) {
        return $this.runnable;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J'\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "", "onError", "", "error", "", "onPageChanged", "currentPage", "", "totalPage", "onPdfLoadProgress", "progress", "downloadedBytes", "", "totalBytes", "(IJLjava/lang/Long;)V", "onPdfLoadStart", "onPdfLoadSuccess", "absolutePath", "", "pdfViewer_release"})
    public static interface StatusCallBack {
        public void onPdfLoadStart();

        public void onPdfLoadProgress(int var1, long var2, @Nullable Long var4);

        public void onPdfLoadSuccess(@NotNull String var1);

        public void onError(@NotNull Throwable var1);

        public void onPageChanged(int var1, int var2);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onPdfLoadStart(@NotNull StatusCallBack $this) {
            }

            public static void onPdfLoadProgress(@NotNull StatusCallBack $this, int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public static void onPdfLoadSuccess(@NotNull StatusCallBack $this, @NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
            }

            public static void onError(@NotNull StatusCallBack $this, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public static void onPageChanged(@NotNull StatusCallBack $this, int currentPage, int totalPage) {
            }
        }
    }
}

