/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import com.rajat.pdfviewer.PdfEngine;
import com.rajat.pdfviewer.PdfQuality;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.R;
import com.rajat.pdfviewer.databinding.ActivityPdfViewerBinding;
import java.io.Serializable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0012\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0012H\u0002J\u0012\u0010$\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J-\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060'2\u0006\u0010(\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u0012H\u0014J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0006H\u0002J\f\u0010.\u001a\u00020\u0012*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u00060"}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "binding", "Lcom/rajat/pdfviewer/databinding/ActivityPdfViewerBinding;", "fileUrl", "", "menuItem", "Landroid/view/MenuItem;", "onComplete", "Landroid/content/BroadcastReceiver;", "permissionGranted", "", "Ljava/lang/Boolean;", "checkInternetConnection", "context", "Landroid/content/Context;", "checkPermission", "", "requestCode", "", "checkPermissionOnInit", "downloadPdf", "initPdfViewer", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "loadFileFromNetwork", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "onPdfError", "onPrepareOptionsMenu", "onRequestPermissionsResult", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onStop", "setUpToolbar", "toolbarTitle", "showProgressBar", "Companion", "pdfViewer_release"})
public final class PdfViewerActivity
extends AppCompatActivity {
    private Boolean permissionGranted = false;
    private ActivityPdfViewerBinding binding;
    private MenuItem menuItem;
    private String fileUrl;
    private BroadcastReceiver onComplete = new BroadcastReceiver(){

        public void onReceive(@Nullable Context context, @Nullable Intent intent) {
            block0: {
                Toast.makeText((Context)context, (CharSequence)"File is Downloaded Successfully", (int)0).show();
                Context context2 = context;
                if (context2 == null) break block0;
                context2.unregisterReceiver((BroadcastReceiver)this);
            }
        }
    };
    @NotNull
    public static final String FILE_URL = "pdf_file_url";
    @NotNull
    public static final String FILE_DIRECTORY = "pdf_file_directory";
    @NotNull
    public static final String FILE_TITLE = "pdf_file_title";
    @NotNull
    public static final String ENABLE_FILE_DOWNLOAD = "enable_download";
    @NotNull
    public static final String IS_GOOGLE_ENGINE = "is_google_engine";
    public static final int PERMISSION_CODE = 4040;
    @NotNull
    private static PdfEngine engine;
    private static boolean enableDownload;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewDataBinding viewDataBinding = DataBindingUtil.setContentView((Activity)((Activity)this), (int)R.layout.activity_pdf_viewer);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"DataBindingUtil.setConte\u2026yout.activity_pdf_viewer)");
        this.binding = (ActivityPdfViewerBinding)viewDataBinding;
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        String string = bundle.getString(FILE_TITLE, "PDF");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"intent.extras!!.getStrin\u2026      \"PDF\"\n            )");
        this.setUpToolbar(string);
        Intent intent2 = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"intent");
        Bundle bundle2 = intent2.getExtras();
        if (bundle2 == null) {
            Intrinsics.throwNpe();
        }
        enableDownload = bundle2.getBoolean(ENABLE_FILE_DOWNLOAD, true);
        Intent intent3 = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent3, (String)"intent");
        Bundle bundle3 = intent3.getExtras();
        if (bundle3 == null) {
            Intrinsics.throwNpe();
        }
        engine = bundle3.getBoolean(IS_GOOGLE_ENGINE, true) ? PdfEngine.GOOGLE : PdfEngine.INTERNAL;
        Intent intent4 = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent4, (String)"intent");
        Bundle bundle4 = intent4.getExtras();
        if (bundle4 == null) {
            Intrinsics.throwNpe();
        }
        if (bundle4.containsKey(FILE_URL)) {
            Intent intent5 = this.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent5, (String)"intent");
            Bundle bundle5 = intent5.getExtras();
            if (bundle5 == null) {
                Intrinsics.throwNpe();
            }
            this.fileUrl = bundle5.getString(FILE_URL);
            if (this.checkInternetConnection((Context)this)) {
                this.loadFileFromNetwork(this.fileUrl);
            } else {
                Toast.makeText((Context)((Context)this), (CharSequence)"No Internet Connection. Please Check your internet connection.", (int)0).show();
            }
        }
    }

    private final boolean checkInternetConnection(Context context) {
        int result;
        block7: {
            ConnectivityManager cm;
            block6: {
                NetworkCapabilities $this$run;
                block9: {
                    block8: {
                        result = 0;
                        cm = (ConnectivityManager)context.getSystemService("connectivity");
                        if (Build.VERSION.SDK_INT < 23) break block6;
                        ConnectivityManager connectivityManager = cm;
                        if (connectivityManager == null) break block7;
                        ConnectivityManager connectivityManager2 = connectivityManager;
                        boolean bl = false;
                        boolean bl2 = false;
                        ConnectivityManager $this$run2 = connectivityManager2;
                        boolean bl3 = false;
                        NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
                        if (networkCapabilities == null) break block7;
                        NetworkCapabilities networkCapabilities2 = networkCapabilities;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        $this$run = networkCapabilities2;
                        boolean bl6 = false;
                        if (!$this$run.hasTransport(1)) break block8;
                        result = 2;
                        break block7;
                    }
                    if (!$this$run.hasTransport(0)) break block9;
                    result = 1;
                    break block7;
                }
                if (!$this$run.hasTransport(4)) break block7;
                result = 3;
                break block7;
            }
            ConnectivityManager connectivityManager = cm;
            if (connectivityManager == null) break block7;
            ConnectivityManager connectivityManager3 = connectivityManager;
            boolean bl = false;
            boolean bl7 = false;
            ConnectivityManager $this$run = connectivityManager3;
            boolean bl8 = false;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null) {
                NetworkInfo networkInfo2 = networkInfo;
                boolean bl9 = false;
                boolean bl10 = false;
                NetworkInfo $this$run3 = networkInfo2;
                boolean bl11 = false;
                switch ($this$run3.getType()) {
                    case 1: {
                        result = 2;
                        break;
                    }
                    case 0: {
                        result = 1;
                        break;
                    }
                    case 17: {
                        result = 3;
                    }
                }
            }
        }
        return result != 0;
    }

    private final void setUpToolbar(String toolbarTitle) {
        block3: {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            this.setSupportActionBar(activityPdfViewerBinding.toolbar);
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setDisplayHomeAsUpEnabled(true);
            }
            ActionBar actionBar2 = this.getSupportActionBar();
            if (actionBar2 != null) {
                actionBar2.setDisplayShowHomeEnabled(true);
            }
            ActionBar actionBar3 = this.getSupportActionBar();
            if (actionBar3 == null) break block3;
            actionBar3.setTitle((CharSequence)toolbarTitle);
        }
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu, menu2);
        Menu menu3 = menu2;
        this.menuItem = menu3 != null ? menu3.findItem(R.id.download) : null;
        return true;
    }

    public boolean onPrepareOptionsMenu(@Nullable Menu menu2) {
        block0: {
            MenuItem menuItem = this.menuItem;
            if (menuItem == null) break block0;
            menuItem.setVisible(enableDownload);
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (item.getItemId() == R.id.download) {
            this.checkPermission(4040);
        }
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    private final void loadFileFromNetwork(String fileUrl) {
        this.initPdfViewer(fileUrl, engine);
    }

    private final void initPdfViewer(String fileUrl, PdfEngine engine) {
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            this.onPdfError();
        }
        try {
            ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
            if (activityPdfViewerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            PdfRendererView pdfRendererView = activityPdfViewerBinding.pdfView;
            String string = fileUrl;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            pdfRendererView.initWithUrl(string, PdfQuality.NORMAL, engine);
        }
        catch (Exception e) {
            this.onPdfError();
        }
        this.checkPermissionOnInit();
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        activityPdfViewerBinding.pdfView.setStatusListener(new PdfRendererView.StatusCallBack(this){
            final /* synthetic */ PdfViewerActivity this$0;

            public void onDownloadStart() {
                PdfViewerActivity.access$showProgressBar(this.this$0, true);
            }

            public void onDownloadProgress(int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public void onDownloadSuccess() {
                PdfViewerActivity.access$showProgressBar(this.this$0, false);
            }

            public void onError(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                PdfViewerActivity.access$onPdfError(this.this$0);
            }

            public void onPageChanged(int currentPage, int totalPage) {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void checkPermissionOnInit() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.permissionGranted = true;
        }
    }

    private final void onPdfError() {
        Toast.makeText((Context)((Context)this), (CharSequence)"Pdf has been corrupted", (int)0).show();
        this.showProgressBar(true);
        this.finish();
    }

    private final void showProgressBar(boolean $this$showProgressBar) {
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ProgressBar progressBar = activityPdfViewerBinding.progressBar;
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"binding.progressBar");
        progressBar.setVisibility($this$showProgressBar ? 0 : 8);
    }

    private final void downloadPdf() {
        try {
            String directoryName = this.getIntent().getStringExtra(FILE_DIRECTORY);
            String fileName = this.getIntent().getStringExtra(FILE_TITLE);
            String fileUrl = this.getIntent().getStringExtra(FILE_URL);
            String filePath = TextUtils.isEmpty((CharSequence)directoryName) ? '/' + fileName + ".pdf" : '/' + directoryName + '/' + fileName + ".pdf";
            try {
                Uri downloadUrl = Uri.parse((String)fileUrl);
                DownloadManager downloadManger = (DownloadManager)this.getSystemService("download");
                DownloadManager.Request request = new DownloadManager.Request(downloadUrl);
                request.setAllowedNetworkTypes(3);
                request.setAllowedOverRoaming(true);
                request.setTitle((CharSequence)fileName);
                request.setDescription((CharSequence)("Downloading " + fileName));
                request.setVisibleInDownloadsUi(true);
                request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, filePath);
                request.setNotificationVisibility(1);
                this.registerReceiver(this.onComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
                Boolean bl = this.permissionGranted;
                if (bl == null) {
                    Intrinsics.throwNpe();
                }
                if (bl.booleanValue()) {
                    DownloadManager downloadManager = downloadManger;
                    if (downloadManager == null) {
                        Intrinsics.throwNpe();
                    }
                    downloadManager.enqueue(request);
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)((Context)this), (CharSequence)"Unable to download file", (int)0).show();
            }
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)e.toString());
        }
    }

    private final void checkPermission(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)requestCode);
        } else {
            this.permissionGranted = true;
            this.downloadPdf();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 4040) {
            int[] nArray = grantResults;
            boolean bl = false;
            int[] nArray2 = nArray;
            boolean bl2 = false;
            if (!(nArray2.length == 0) && grantResults[0] == 0) {
                this.permissionGranted = true;
                this.downloadPdf();
            }
        }
    }

    protected void onStop() {
        super.onStop();
        ActivityPdfViewerBinding activityPdfViewerBinding = this.binding;
        if (activityPdfViewerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        activityPdfViewerBinding.pdfView.closePdfRender();
    }

    static {
        Companion = new Companion(null);
        engine = PdfEngine.INTERNAL;
        enableDownload = true;
    }

    public static final /* synthetic */ void access$showProgressBar(PdfViewerActivity $this, boolean $this$access_u24showProgressBar) {
        $this.showProgressBar($this$access_u24showProgressBar);
    }

    public static final /* synthetic */ void access$onPdfError(PdfViewerActivity $this) {
        $this.onPdfError();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/rajat/pdfviewer/PdfViewerActivity$Companion;", "", "()V", "ENABLE_FILE_DOWNLOAD", "", "FILE_DIRECTORY", "FILE_TITLE", "FILE_URL", "IS_GOOGLE_ENGINE", "PERMISSION_CODE", "", "enableDownload", "", "getEnableDownload", "()Z", "setEnableDownload", "(Z)V", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "getEngine", "()Lcom/rajat/pdfviewer/PdfEngine;", "setEngine", "(Lcom/rajat/pdfviewer/PdfEngine;)V", "buildIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "pdfUrl", "isGoogleEngine", "pdfTitle", "directoryName", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Z)Landroid/content/Intent;", "pdfViewer_release"})
    public static final class Companion {
        @NotNull
        public final PdfEngine getEngine() {
            return engine;
        }

        public final void setEngine(@NotNull PdfEngine pdfEngine) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfEngine), (String)"<set-?>");
            engine = pdfEngine;
        }

        public final boolean getEnableDownload() {
            return enableDownload;
        }

        public final void setEnableDownload(boolean bl) {
            enableDownload = bl;
        }

        @NotNull
        public final Intent buildIntent(@Nullable Context context, @Nullable String pdfUrl, @Nullable Boolean isGoogleEngine, @Nullable String pdfTitle, @Nullable String directoryName, boolean enableDownload) {
            Intent intent = new Intent(context, PdfViewerActivity.class);
            intent.putExtra(PdfViewerActivity.FILE_URL, pdfUrl);
            intent.putExtra(PdfViewerActivity.FILE_TITLE, pdfTitle);
            intent.putExtra(PdfViewerActivity.FILE_DIRECTORY, directoryName);
            intent.putExtra(PdfViewerActivity.ENABLE_FILE_DOWNLOAD, enableDownload);
            intent.putExtra(PdfViewerActivity.IS_GOOGLE_ENGINE, (Serializable)isGoogleEngine);
            return intent;
        }

        public static /* synthetic */ Intent buildIntent$default(Companion companion, Context context, String string, Boolean bl, String string2, String string3, boolean bl2, int n, Object object) {
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            return companion.buildIntent(context, string, bl, string2, string3, bl2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

