/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.PdfDownloader;
import com.rajat.pdfviewer.PdfEngine;
import com.rajat.pdfviewer.PdfQuality;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewAdapter;
import com.rajat.pdfviewer.R;
import java.io.File;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0018\u0018\u00002\u00020\u0001:\u000267B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010%\u001a\u00020&2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0012H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0003J\u0018\u0010/\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0012J\u0018\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020.2\b\b\u0002\u0010+\u001a\u00020\u0012J\"\u00102\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010+\u001a\u00020\u00122\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00068"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "divider", "Landroid/graphics/drawable/Drawable;", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "pdfRendererCore", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pdfViewAdapter", "Lcom/rajat/pdfviewer/PdfViewAdapter;", "quality", "Lcom/rajat/pdfviewer/PdfQuality;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "runnable", "Ljava/lang/Runnable;", "scrollListener", "com/rajat/pdfviewer/PdfRendererView$scrollListener$1", "Lcom/rajat/pdfviewer/PdfRendererView$scrollListener$1;", "showDivider", "", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "getStatusListener", "()Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "setStatusListener", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "totalPageCount", "getTotalPageCount", "()I", "getAttrs", "", "defStyle", "init", "file", "Ljava/io/File;", "pdfQuality", "initUnderKitkat", "url", "", "initWithFile", "initWithPath", "path", "initWithUrl", "setTypeArray", "typedArray", "Landroid/content/res/TypedArray;", "PdfWebViewClient", "StatusCallBack", "pdfViewer_release"})
public final class PdfRendererView
extends FrameLayout {
    private RecyclerView recyclerView;
    private PdfRendererCore pdfRendererCore;
    private PdfViewAdapter pdfViewAdapter;
    private PdfQuality quality;
    private PdfEngine engine;
    private boolean showDivider;
    private Drawable divider;
    private Runnable runnable;
    @Nullable
    private StatusCallBack statusListener;
    private final scrollListener.1 scrollListener;
    private HashMap _$_findViewCache;

    @Nullable
    public final StatusCallBack getStatusListener() {
        return this.statusListener;
    }

    public final void setStatusListener(@Nullable StatusCallBack statusCallBack) {
        this.statusListener = statusCallBack;
    }

    public final int getTotalPageCount() {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
        }
        return pdfRendererCore.getPageCount();
    }

    public final void initWithUrl(@NotNull String url, @NotNull PdfQuality pdfQuality, @NotNull PdfEngine engine) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pdfQuality), (String)"pdfQuality");
        Intrinsics.checkParameterIsNotNull((Object)((Object)engine), (String)"engine");
        if (Build.VERSION.SDK_INT < 21 || engine == PdfEngine.GOOGLE) {
            this.initUnderKitkat(url);
            StatusCallBack statusCallBack = this.statusListener;
            if (statusCallBack != null) {
                statusCallBack.onDownloadStart();
            }
            return;
        }
        new PdfDownloader(url, new PdfDownloader.StatusListener(this, pdfQuality){
            final /* synthetic */ PdfRendererView this$0;
            final /* synthetic */ PdfQuality $pdfQuality;

            @NotNull
            public Context getContext() {
                Context context = this.this$0.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                return context;
            }

            public void onDownloadStart() {
                block0: {
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onDownloadStart();
                }
            }

            public void onDownloadProgress(long currentBytes, long totalBytes) {
                block1: {
                    int progress = (int)((float)currentBytes / (float)totalBytes * 100.0f);
                    if (progress >= 100) {
                        progress = 100;
                    }
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block1;
                    statusCallBack.onDownloadProgress(progress, currentBytes, totalBytes);
                }
            }

            public void onDownloadSuccess(@NotNull String absolutePath) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)absolutePath, (String)"absolutePath");
                    this.this$0.initWithPath(absolutePath, this.$pdfQuality);
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onDownloadSuccess();
                }
            }

            public void onError(@NotNull Throwable error) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    error.printStackTrace();
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onError(error);
                }
            }
            {
                this.this$0 = $outer;
                this.$pdfQuality = $captured_local_variable$1;
            }
        });
    }

    public static /* synthetic */ void initWithUrl$default(PdfRendererView pdfRendererView, String string, PdfQuality pdfQuality, PdfEngine pdfEngine, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        if ((n & 4) != 0) {
            pdfEngine = pdfRendererView.engine;
        }
        pdfRendererView.initWithUrl(string, pdfQuality, pdfEngine);
    }

    public final void initWithPath(@NotNull String path, @NotNull PdfQuality pdfQuality) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pdfQuality), (String)"pdfQuality");
        if (Build.VERSION.SDK_INT < 21) {
            throw (Throwable)new UnsupportedOperationException("should be over API 21");
        }
        this.initWithFile(new File(path), pdfQuality);
    }

    public static /* synthetic */ void initWithPath$default(PdfRendererView pdfRendererView, String string, PdfQuality pdfQuality, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        pdfRendererView.initWithPath(string, pdfQuality);
    }

    public final void initWithFile(@NotNull File file, @NotNull PdfQuality pdfQuality) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pdfQuality), (String)"pdfQuality");
        if (Build.VERSION.SDK_INT < 21) {
            throw (Throwable)new UnsupportedOperationException("should be over API 21");
        }
        this.init(file, pdfQuality);
    }

    public static /* synthetic */ void initWithFile$default(PdfRendererView pdfRendererView, File file, PdfQuality pdfQuality, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        pdfRendererView.initWithFile(file, pdfQuality);
    }

    private final void init(File file, PdfQuality pdfQuality) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        PdfRendererCore pdfRendererCore = this.pdfRendererCore = new PdfRendererCore(context, file, pdfQuality);
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
        }
        this.pdfViewAdapter = new PdfViewAdapter(pdfRendererCore);
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.recyclerView)");
        RecyclerView recyclerView = this.recyclerView = (RecyclerView)view;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        RecyclerView recyclerView2 = recyclerView;
        boolean bl = false;
        boolean bl2 = false;
        RecyclerView $this$apply = recyclerView2;
        boolean bl3 = false;
        PdfViewAdapter pdfViewAdapter = this.pdfViewAdapter;
        if (pdfViewAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfViewAdapter");
        }
        $this$apply.setAdapter((RecyclerView.Adapter)pdfViewAdapter);
        $this$apply.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$apply.getContext(), 1, false));
        $this$apply.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (this.showDivider) {
            DividerItemDecoration dividerItemDecoration = new DividerItemDecoration($this$apply.getContext(), 1);
            boolean bl4 = false;
            boolean bl5 = false;
            DividerItemDecoration $this$apply2 = dividerItemDecoration;
            boolean bl6 = false;
            Drawable drawable = this.divider;
            if (drawable != null) {
                Drawable drawable2 = drawable;
                boolean bl7 = false;
                boolean bl8 = false;
                Drawable it = drawable2;
                boolean bl9 = false;
                $this$apply2.setDrawable(it);
            }
            bl4 = false;
            bl5 = false;
            DividerItemDecoration it = dividerItemDecoration;
            boolean bl10 = false;
            $this$apply.addItemDecoration((RecyclerView.ItemDecoration)it);
        }
        $this$apply.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.runnable = new Runnable(this){
            final /* synthetic */ PdfRendererView this$0;

            public final void run() {
                TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.pageNo);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"pageNo");
                textView.setVisibility(8);
            }
            {
                this.this$0 = pdfRendererView;
            }
        };
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void initUnderKitkat(String url) {
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.recyclerView)");
        RecyclerView recyclerView = this.recyclerView = (RecyclerView)view;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        recyclerView.setVisibility(8);
        WebView webView = (WebView)this._$_findCachedViewById(R.id.webView);
        Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"webView");
        webView.setVisibility(0);
        WebView webView2 = (WebView)this._$_findCachedViewById(R.id.webView);
        Intrinsics.checkExpressionValueIsNotNull((Object)webView2, (String)"webView");
        WebSettings webSettings = webView2.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings, (String)"webView.settings");
        webSettings.setJavaScriptEnabled(true);
        WebView webView3 = (WebView)this._$_findCachedViewById(R.id.webView);
        Intrinsics.checkExpressionValueIsNotNull((Object)webView3, (String)"webView");
        webView3.setWebViewClient((WebViewClient)new PdfWebViewClient(this.statusListener));
        ((WebView)this._$_findCachedViewById(R.id.webView)).loadUrl("https://drive.google.com/viewer/viewer?hl=en&embedded=true&url=" + URLEncoder.encode(url, "UTF-8"));
    }

    private final void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray;
        TypedArray typedArray2 = typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PdfRendererView, defStyle, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray2, (String)"typedArray");
        this.setTypeArray(typedArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final void setTypeArray(TypedArray typedArray) {
        void element$iv;
        void var13_18;
        block5: {
            void $this$first$iv;
            void element$iv2;
            int n;
            PdfRendererView pdfRendererView;
            block4: {
                void $this$first$iv2;
                int ratio = typedArray.getInt(R.styleable.PdfRendererView_pdfView_quality, PdfQuality.NORMAL.getRatio());
                PdfQuality[] pdfQualityArray = PdfQuality.values();
                pdfRendererView = this;
                boolean $i$f$first = false;
                void var5_8 = $this$first$iv2;
                int n2 = ((void)var5_8).length;
                for (n = 0; n < n2; ++n) {
                    void it = element$iv2 = var5_8[n];
                    boolean bl = false;
                    if (!(it.getRatio() == ratio)) {
                        continue;
                    }
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            var13_18 = element$iv2;
            pdfRendererView.quality = var13_18;
            int engineValue = typedArray.getInt(R.styleable.PdfRendererView_pdfView_engine, PdfEngine.INTERNAL.getValue());
            PdfEngine[] $i$f$first = PdfEngine.values();
            pdfRendererView = this;
            boolean $i$f$first2 = false;
            void var6_11 = $this$first$iv;
            n = ((void)var6_11).length;
            for (int i = 0; i < n; ++i) {
                void it = element$iv = var6_11[i];
                boolean bl = false;
                if (!(it.getValue() == engineValue)) {
                    continue;
                }
                break block5;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        var13_18 = element$iv;
        pdfRendererView.engine = var13_18;
        this.showDivider = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_showDivider, true);
        this.divider = typedArray.getDrawable(R.styleable.PdfRendererView_pdfView_divider);
        typedArray.recycle();
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.quality = PdfQuality.NORMAL;
        this.engine = PdfEngine.INTERNAL;
        this.showDivider = true;
        this.runnable = runnable.1.INSTANCE;
        this.scrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ PdfRendererView this$0;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                block5: {
                    int foundPosition;
                    LinearLayoutManager $this$run;
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                        super.onScrolled(recyclerView, dx, dy);
                        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                        if (layoutManager == null) {
                            throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                        }
                        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                        boolean bl = false;
                        boolean bl2 = false;
                        $this$run = linearLayoutManager;
                        boolean bl3 = false;
                        foundPosition = $this$run.findFirstCompletelyVisibleItemPosition();
                        TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.pageNo);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        TextView $this$run2 = textView;
                        boolean bl6 = false;
                        if (foundPosition != -1) {
                            $this$run2.setText((CharSequence)(foundPosition + 1 + " of " + this.this$0.getTotalPageCount()));
                        }
                        TextView textView2 = (TextView)((View)$this$run2).findViewById(R.id.pageNo);
                        Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"pageNo");
                        textView2.setVisibility(0);
                        if (foundPosition == 0) {
                            ((TextView)this.this$0._$_findCachedViewById(R.id.pageNo)).postDelayed(new Runnable(this){
                                final /* synthetic */ scrollListener.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void run() {
                                    TextView textView = (TextView)this.this$0.this$0._$_findCachedViewById(R.id.pageNo);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"pageNo");
                                    textView.setVisibility(8);
                                }
                            }, 3000L);
                        }
                        if (foundPosition == -1) break block4;
                        StatusCallBack statusCallBack = this.this$0.getStatusListener();
                        if (statusCallBack == null) break block5;
                        statusCallBack.onPageChanged(foundPosition, this.this$0.getTotalPageCount());
                        break block5;
                    }
                    foundPosition = $this$run.findFirstVisibleItemPosition();
                    if (foundPosition == -1) break block5;
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack != null) {
                        statusCallBack.onPageChanged(foundPosition, this.this$0.getTotalPageCount());
                    }
                }
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    ((TextView)this.this$0._$_findCachedViewById(R.id.pageNo)).postDelayed(PdfRendererView.access$getRunnable$p(this.this$0), 3000L);
                } else {
                    ((TextView)this.this$0._$_findCachedViewById(R.id.pageNo)).removeCallbacks(PdfRendererView.access$getRunnable$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.getAttrs(attrs, defStyleAttr);
    }

    public /* synthetic */ PdfRendererView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ Runnable access$getRunnable$p(PdfRendererView $this) {
        return $this.runnable;
    }

    public static final /* synthetic */ void access$setRunnable$p(PdfRendererView $this, Runnable runnable2) {
        $this.runnable = runnable2;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "", "onDownloadProgress", "", "progress", "", "downloadedBytes", "", "totalBytes", "(IJLjava/lang/Long;)V", "onDownloadStart", "onDownloadSuccess", "onError", "error", "", "onPageChanged", "currentPage", "totalPage", "pdfViewer_release"})
    public static interface StatusCallBack {
        public void onDownloadStart();

        public void onDownloadProgress(int var1, long var2, @Nullable Long var4);

        public void onDownloadSuccess();

        public void onError(@NotNull Throwable var1);

        public void onPageChanged(int var1, int var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onDownloadStart(StatusCallBack $this) {
            }

            public static void onDownloadProgress(StatusCallBack $this, int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public static void onDownloadSuccess(StatusCallBack $this) {
            }

            public static void onError(StatusCallBack $this, @NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            }

            public static void onPageChanged(StatusCallBack $this, int currentPage, int totalPage) {
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J.\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$PdfWebViewClient;", "Landroid/webkit/WebViewClient;", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "errorCode", "", "description", "failingUrl", "pdfViewer_release"})
    public static final class PdfWebViewClient
    extends WebViewClient {
        private final StatusCallBack statusListener;

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            block0: {
                super.onPageFinished(view, url);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onDownloadSuccess();
            }
        }

        public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
            block0: {
                super.onReceivedError(view, request, error);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onError(new Throwable("Web resource error"));
            }
        }

        public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
            block0: {
                super.onReceivedError(view, errorCode, description, failingUrl);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onError(new Throwable("Web resource error"));
            }
        }

        public PdfWebViewClient(@Nullable StatusCallBack statusListener) {
            this.statusListener = statusListener;
        }
    }
}

