/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.transport.jsonrpc.handler;

import io.a2a.jsonrpc.common.wrappers.CancelTaskRequest;
import io.a2a.jsonrpc.common.wrappers.CancelTaskResponse;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardRequest;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskRequest;
import io.a2a.jsonrpc.common.wrappers.GetTaskResponse;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksRequest;
import io.a2a.jsonrpc.common.wrappers.ListTasksResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.jsonrpc.common.wrappers.SendMessageRequest;
import io.a2a.jsonrpc.common.wrappers.SendMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageRequest;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SetTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.SetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.SubscribeToTaskRequest;
import io.a2a.server.AgentCardValidator;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.PublicAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.AsyncUtils;
import io.a2a.server.util.async.Internal;
import io.a2a.server.version.A2AVersionValidator;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.ExtendedCardNotConfiguredError;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;
import org.jspecify.annotations.Nullable;

@ApplicationScoped
public class JSONRPCHandler {
    private AgentCard agentCard;
    private @Nullable Instance<AgentCard> extendedAgentCard;
    private RequestHandler requestHandler;
    private Executor executor;

    protected JSONRPCHandler() {
        this.agentCard = null;
        this.extendedAgentCard = null;
        this.requestHandler = null;
        this.executor = null;
    }

    @Inject
    public JSONRPCHandler(@PublicAgentCard AgentCard agentCard, @ExtendedAgentCard @Nullable Instance<AgentCard> extendedAgentCard, RequestHandler requestHandler, @Internal Executor executor) {
        this.agentCard = agentCard;
        this.extendedAgentCard = extendedAgentCard;
        this.requestHandler = requestHandler;
        this.executor = executor;
        AgentCardValidator.validateTransportConfiguration((AgentCard)agentCard);
    }

    public JSONRPCHandler(@PublicAgentCard AgentCard agentCard, RequestHandler requestHandler, Executor executor) {
        this(agentCard, null, requestHandler, executor);
    }

    public SendMessageResponse onMessageSend(SendMessageRequest request, ServerCallContext context) {
        try {
            A2AVersionValidator.validateProtocolVersion((AgentCard)this.agentCard, (ServerCallContext)context);
            A2AExtensions.validateRequiredExtensions((AgentCard)this.agentCard, (ServerCallContext)context);
            EventKind taskOrMessage = this.requestHandler.onMessageSend((MessageSendParams)request.getParams(), context);
            return new SendMessageResponse(request.getId(), taskOrMessage);
        }
        catch (A2AError e) {
            return new SendMessageResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SendMessageResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onMessageSendStream(SendStreamingMessageRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (A2AError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            A2AVersionValidator.validateProtocolVersion((AgentCard)this.agentCard, (ServerCallContext)context);
            A2AExtensions.validateRequiredExtensions((AgentCard)this.agentCard, (ServerCallContext)context);
            Flow.Publisher publisher = this.requestHandler.onMessageSendStream((MessageSendParams)request.getParams(), context);
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (A2AError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (A2AError)new InternalError(throwable.getMessage()))});
        }
    }

    public CancelTaskResponse onCancelTask(CancelTaskRequest request, ServerCallContext context) {
        try {
            Task task = this.requestHandler.onCancelTask((TaskIdParams)request.getParams(), context);
            if (task != null) {
                return new CancelTaskResponse(request.getId(), task);
            }
            return new CancelTaskResponse(request.getId(), (A2AError)new TaskNotFoundError());
        }
        catch (A2AError e) {
            return new CancelTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new CancelTaskResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onSubscribeToTask(SubscribeToTaskRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (A2AError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            Flow.Publisher publisher = this.requestHandler.onResubscribeToTask((TaskIdParams)request.getParams(), context);
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (A2AError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (A2AError)new InternalError(throwable.getMessage()))});
        }
    }

    public GetTaskPushNotificationConfigResponse getPushNotificationConfig(GetTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new GetTaskPushNotificationConfigResponse(request.getId(), (A2AError)new PushNotificationNotSupportedError());
        }
        try {
            TaskPushNotificationConfig config = this.requestHandler.onGetTaskPushNotificationConfig((GetTaskPushNotificationConfigParams)request.getParams(), context);
            return new GetTaskPushNotificationConfigResponse(request.getId(), config);
        }
        catch (A2AError e) {
            return new GetTaskPushNotificationConfigResponse((Object)request.getId().toString(), e);
        }
        catch (Throwable t) {
            return new GetTaskPushNotificationConfigResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public SetTaskPushNotificationConfigResponse setPushNotificationConfig(SetTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (A2AError)new PushNotificationNotSupportedError());
        }
        try {
            TaskPushNotificationConfig config = this.requestHandler.onSetTaskPushNotificationConfig((TaskPushNotificationConfig)request.getParams(), context);
            return new SetTaskPushNotificationConfigResponse((Object)request.getId().toString(), config);
        }
        catch (A2AError e) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public GetTaskResponse onGetTask(GetTaskRequest request, ServerCallContext context) {
        try {
            Task task = this.requestHandler.onGetTask((TaskQueryParams)request.getParams(), context);
            return new GetTaskResponse(request.getId(), task);
        }
        catch (A2AError e) {
            return new GetTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new GetTaskResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public ListTasksResponse onListTasks(ListTasksRequest request, ServerCallContext context) {
        try {
            ListTasksResult result = this.requestHandler.onListTasks((ListTasksParams)request.getParams(), context);
            return new ListTasksResponse(request.getId(), result);
        }
        catch (A2AError e) {
            return new ListTasksResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new ListTasksResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public ListTaskPushNotificationConfigResponse listPushNotificationConfig(ListTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), (A2AError)new PushNotificationNotSupportedError());
        }
        try {
            ListTaskPushNotificationConfigResult result = this.requestHandler.onListTaskPushNotificationConfig((ListTaskPushNotificationConfigParams)request.getParams(), context);
            return new ListTaskPushNotificationConfigResponse(request.getId(), result);
        }
        catch (A2AError e) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public DeleteTaskPushNotificationConfigResponse deletePushNotificationConfig(DeleteTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), (A2AError)new PushNotificationNotSupportedError());
        }
        try {
            this.requestHandler.onDeleteTaskPushNotificationConfig((DeleteTaskPushNotificationConfigParams)request.getParams(), context);
            return new DeleteTaskPushNotificationConfigResponse(request.getId());
        }
        catch (A2AError e) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public GetAuthenticatedExtendedCardResponse onGetAuthenticatedExtendedCardRequest(GetAuthenticatedExtendedCardRequest request, ServerCallContext context) {
        if (!this.agentCard.supportsExtendedAgentCard() || this.extendedAgentCard == null || !this.extendedAgentCard.isResolvable()) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (A2AError)new ExtendedCardNotConfiguredError(null, "Extended Card not configured", null));
        }
        try {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (AgentCard)this.extendedAgentCard.get());
        }
        catch (A2AError e) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (A2AError)new InternalError(t.getMessage()));
        }
    }

    public AgentCard getAgentCard() {
        return this.agentCard;
    }

    private Flow.Publisher<SendStreamingMessageResponse> convertToSendStreamingMessageResponse(final Object requestId, Flow.Publisher<StreamingEventKind> publisher) {
        return ZeroPublisher.create((TubeConfiguration)AsyncUtils.createTubeConfig(), tube -> CompletableFuture.runAsync(() -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(StreamingEventKind item) {
                tube.send((Object)new SendStreamingMessageResponse(requestId, item));
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof A2AError) {
                    A2AError jsonrpcError = (A2AError)throwable;
                    tube.send((Object)new SendStreamingMessageResponse(requestId, jsonrpcError));
                } else {
                    tube.send((Object)new SendStreamingMessageResponse(requestId, (A2AError)new InternalError(throwable.getMessage())));
                }
                this.onComplete();
            }

            @Override
            public void onComplete() {
                tube.complete();
            }
        }), this.executor));
    }
}

