/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.transport.jsonrpc.handler;

import io.a2a.server.AgentCardValidator;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.PublicAgentCard;
import io.a2a.server.ServerCallContext;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.AsyncUtils;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AuthenticatedExtendedCardNotConfiguredError;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.CancelTaskResponse;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.DeleteTaskPushNotificationConfigRequest;
import io.a2a.spec.DeleteTaskPushNotificationConfigResponse;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetAuthenticatedExtendedCardRequest;
import io.a2a.spec.GetAuthenticatedExtendedCardResponse;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskPushNotificationConfigResponse;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.GetTaskResponse;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigRequest;
import io.a2a.spec.ListTaskPushNotificationConfigResponse;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendMessageResponse;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SendStreamingMessageResponse;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.SetTaskPushNotificationConfigResponse;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskResubscriptionRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import mutiny.zero.TubeConfiguration;
import mutiny.zero.ZeroPublisher;

@ApplicationScoped
public class JSONRPCHandler {
    private AgentCard agentCard;
    private Instance<AgentCard> extendedAgentCard;
    private RequestHandler requestHandler;
    private final Executor executor;

    protected JSONRPCHandler() {
        this.executor = null;
    }

    @Inject
    public JSONRPCHandler(@PublicAgentCard AgentCard agentCard, @ExtendedAgentCard Instance<AgentCard> extendedAgentCard, RequestHandler requestHandler, @Internal Executor executor) {
        this.agentCard = agentCard;
        this.extendedAgentCard = extendedAgentCard;
        this.requestHandler = requestHandler;
        this.executor = executor;
        AgentCardValidator.validateTransportConfiguration((AgentCard)agentCard);
    }

    public JSONRPCHandler(@PublicAgentCard AgentCard agentCard, RequestHandler requestHandler, Executor executor) {
        this(agentCard, null, requestHandler, executor);
    }

    public SendMessageResponse onMessageSend(SendMessageRequest request, ServerCallContext context) {
        try {
            EventKind taskOrMessage = this.requestHandler.onMessageSend((MessageSendParams)request.getParams(), context);
            return new SendMessageResponse(request.getId(), taskOrMessage);
        }
        catch (JSONRPCError e) {
            return new SendMessageResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SendMessageResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onMessageSendStream(SendStreamingMessageRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            Flow.Publisher publisher = this.requestHandler.onMessageSendStream((MessageSendParams)request.getParams(), context);
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (JSONRPCError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InternalError(throwable.getMessage()))});
        }
    }

    public CancelTaskResponse onCancelTask(CancelTaskRequest request, ServerCallContext context) {
        try {
            Task task = this.requestHandler.onCancelTask((TaskIdParams)request.getParams(), context);
            if (task != null) {
                return new CancelTaskResponse(request.getId(), task);
            }
            return new CancelTaskResponse(request.getId(), (JSONRPCError)new TaskNotFoundError());
        }
        catch (JSONRPCError e) {
            return new CancelTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new CancelTaskResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public Flow.Publisher<SendStreamingMessageResponse> onResubscribeToTask(TaskResubscriptionRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().streaming()) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InvalidRequestError("Streaming is not supported by the agent"))});
        }
        try {
            Flow.Publisher publisher = this.requestHandler.onResubscribeToTask((TaskIdParams)request.getParams(), context);
            return this.convertToSendStreamingMessageResponse(request.getId(), publisher);
        }
        catch (JSONRPCError e) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), e)});
        }
        catch (Throwable throwable) {
            return ZeroPublisher.fromItems((Object[])new SendStreamingMessageResponse[]{new SendStreamingMessageResponse(request.getId(), (JSONRPCError)new InternalError(throwable.getMessage()))});
        }
    }

    public GetTaskPushNotificationConfigResponse getPushNotificationConfig(GetTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new GetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new PushNotificationNotSupportedError());
        }
        try {
            TaskPushNotificationConfig config = this.requestHandler.onGetTaskPushNotificationConfig((GetTaskPushNotificationConfigParams)request.getParams(), context);
            return new GetTaskPushNotificationConfigResponse(request.getId(), config);
        }
        catch (JSONRPCError e) {
            return new GetTaskPushNotificationConfigResponse((Object)request.getId().toString(), e);
        }
        catch (Throwable t) {
            return new GetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public SetTaskPushNotificationConfigResponse setPushNotificationConfig(SetTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new PushNotificationNotSupportedError());
        }
        try {
            TaskPushNotificationConfig config = this.requestHandler.onSetTaskPushNotificationConfig((TaskPushNotificationConfig)request.getParams(), context);
            return new SetTaskPushNotificationConfigResponse((Object)request.getId().toString(), config);
        }
        catch (JSONRPCError e) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new SetTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public GetTaskResponse onGetTask(GetTaskRequest request, ServerCallContext context) {
        try {
            Task task = this.requestHandler.onGetTask((TaskQueryParams)request.getParams(), context);
            return new GetTaskResponse(request.getId(), task);
        }
        catch (JSONRPCError e) {
            return new GetTaskResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new GetTaskResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public ListTaskPushNotificationConfigResponse listPushNotificationConfig(ListTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new PushNotificationNotSupportedError());
        }
        try {
            List pushNotificationConfigList = this.requestHandler.onListTaskPushNotificationConfig((ListTaskPushNotificationConfigParams)request.getParams(), context);
            return new ListTaskPushNotificationConfigResponse(request.getId(), pushNotificationConfigList);
        }
        catch (JSONRPCError e) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new ListTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public DeleteTaskPushNotificationConfigResponse deletePushNotificationConfig(DeleteTaskPushNotificationConfigRequest request, ServerCallContext context) {
        if (!this.agentCard.capabilities().pushNotifications()) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new PushNotificationNotSupportedError());
        }
        try {
            this.requestHandler.onDeleteTaskPushNotificationConfig((DeleteTaskPushNotificationConfigParams)request.getParams(), context);
            return new DeleteTaskPushNotificationConfigResponse(request.getId());
        }
        catch (JSONRPCError e) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new DeleteTaskPushNotificationConfigResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public GetAuthenticatedExtendedCardResponse onGetAuthenticatedExtendedCardRequest(GetAuthenticatedExtendedCardRequest request, ServerCallContext context) {
        if (!this.agentCard.supportsAuthenticatedExtendedCard() || !this.extendedAgentCard.isResolvable()) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (JSONRPCError)new AuthenticatedExtendedCardNotConfiguredError());
        }
        try {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (AgentCard)this.extendedAgentCard.get());
        }
        catch (JSONRPCError e) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), e);
        }
        catch (Throwable t) {
            return new GetAuthenticatedExtendedCardResponse(request.getId(), (JSONRPCError)new InternalError(t.getMessage()));
        }
    }

    public AgentCard getAgentCard() {
        return this.agentCard;
    }

    private Flow.Publisher<SendStreamingMessageResponse> convertToSendStreamingMessageResponse(final Object requestId, Flow.Publisher<StreamingEventKind> publisher) {
        return ZeroPublisher.create((TubeConfiguration)AsyncUtils.createTubeConfig(), tube -> CompletableFuture.runAsync(() -> publisher.subscribe(new Flow.Subscriber<StreamingEventKind>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(StreamingEventKind item) {
                tube.send((Object)new SendStreamingMessageResponse(requestId, item));
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                if (throwable instanceof JSONRPCError) {
                    JSONRPCError jsonrpcError = (JSONRPCError)throwable;
                    tube.send((Object)new SendStreamingMessageResponse(requestId, jsonrpcError));
                } else {
                    tube.send((Object)new SendStreamingMessageResponse(requestId, (JSONRPCError)new InternalError(throwable.getMessage())));
                }
                this.onComplete();
            }

            @Override
            public void onComplete() {
                tube.complete();
            }
        }), this.executor));
    }
}

