/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.util.Assert;
import io.a2a.util.Utils;
import org.jspecify.annotations.Nullable;

public record TaskQueryParams(String id, @Nullable Integer historyLength, String tenant) {
    public TaskQueryParams(String id, @Nullable Integer historyLength, String tenant) {
        Assert.checkNotNullParam((String)"id", (Object)id);
        Assert.checkNotNullParam((String)"tenant", (Object)tenant);
        if (historyLength != null && historyLength < 0) {
            throw new IllegalArgumentException("Invalid history length");
        }
    }

    public TaskQueryParams(String id, @Nullable Integer historyLength) {
        this(id, historyLength, "");
    }

    public TaskQueryParams(String id) {
        this(id, null, "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String id;
        private @Nullable Integer historyLength;
        private @Nullable String tenant;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder historyLength(Integer historyLength) {
            this.historyLength = historyLength;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public TaskQueryParams build() {
            return new TaskQueryParams((String)Assert.checkNotNullParam((String)"id", (Object)this.id), this.historyLength, Utils.defaultIfNull(this.tenant, ""));
        }
    }
}

