/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Artifact;
import io.a2a.spec.EventKind;
import io.a2a.spec.Message;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskStatus;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;

public record Task(String id, String contextId, TaskStatus status, List<Artifact> artifacts, List<Message> history, Map<String, Object> metadata) implements EventKind,
StreamingEventKind
{
    public static final String STREAMING_EVENT_ID = "task";

    public Task {
        Assert.checkNotNullParam((String)"id", (Object)id);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
        Assert.checkNotNullParam((String)"status", (Object)status);
        artifacts = artifacts != null ? List.copyOf(artifacts) : List.of();
        history = history != null ? List.copyOf(history) : List.of();
        metadata = metadata != null ? Map.copyOf(metadata) : null;
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Task task) {
        return new Builder(task);
    }

    public static class Builder {
        private String id;
        private String contextId;
        private TaskStatus status;
        private List<Artifact> artifacts;
        private List<Message> history;
        private Map<String, Object> metadata;

        private Builder() {
        }

        private Builder(Task task) {
            this.id = task.id();
            this.contextId = task.contextId();
            this.status = task.status();
            this.artifacts = task.artifacts();
            this.history = task.history();
            this.metadata = task.metadata();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder artifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder history(List<Message> history) {
            this.history = history;
            return this;
        }

        public Builder history(Message ... history) {
            this.history = List.of(history);
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Task build() {
            return new Task(this.id, this.contextId, this.status, this.artifacts, this.history, this.metadata);
        }
    }
}

