/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.OAuthFlows;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;

public record OAuth2SecurityScheme(OAuthFlows flows, String description, String oauth2MetadataUrl) implements SecurityScheme
{
    public static final String TYPE = "oauth2SecurityScheme";

    public OAuth2SecurityScheme {
        Assert.checkNotNullParam((String)"flows", (Object)flows);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OAuthFlows flows;
        private String description;
        private String oauth2MetadataUrl;

        private Builder() {
        }

        public Builder flows(OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder oauth2MetadataUrl(String oauth2MetadataUrl) {
            this.oauth2MetadataUrl = oauth2MetadataUrl;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.flows, this.description, this.oauth2MetadataUrl);
        }
    }
}

