/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.EventKind;
import io.a2a.spec.Part;
import io.a2a.spec.StreamingEventKind;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public record Message(Role role, List<Part<?>> parts, String messageId, String contextId, String taskId, List<String> referenceTaskIds, Map<String, Object> metadata, List<String> extensions) implements EventKind,
StreamingEventKind
{
    public static final String STREAMING_EVENT_ID = "message";

    public Message {
        Assert.checkNotNullParam((String)"role", (Object)((Object)role));
        Assert.checkNotNullParam((String)"parts", parts);
        Assert.checkNotNullParam((String)"messageId", (Object)messageId);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be empty");
        }
        parts = List.copyOf(parts);
        referenceTaskIds = referenceTaskIds != null ? List.copyOf(referenceTaskIds) : null;
        extensions = extensions != null ? List.copyOf(extensions) : null;
        metadata = metadata != null ? Map.copyOf(metadata) : null;
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Message message) {
        return new Builder(message);
    }

    public static enum Role {
        USER("user"),
        AGENT("agent");

        private final String role;

        private Role(String role) {
            this.role = role;
        }

        public String asString() {
            return this.role;
        }
    }

    public static class Builder {
        private Role role;
        private List<Part<?>> parts;
        private String messageId;
        private String contextId;
        private String taskId;
        private List<String> referenceTaskIds;
        private Map<String, Object> metadata;
        private List<String> extensions;

        private Builder() {
        }

        private Builder(Message message) {
            this.role = message.role();
            this.parts = message.parts();
            this.messageId = message.messageId();
            this.contextId = message.contextId();
            this.taskId = message.taskId();
            this.referenceTaskIds = message.referenceTaskIds();
            this.metadata = message.metadata();
            this.extensions = message.extensions();
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder parts(Part<?> ... parts) {
            this.parts = List.of(parts);
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder referenceTaskIds(List<String> referenceTaskIds) {
            this.referenceTaskIds = referenceTaskIds;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder extensions(List<String> extensions) {
            this.extensions = extensions == null ? null : List.copyOf(extensions);
            return this;
        }

        public Message build() {
            return new Message(this.role, this.parts, this.messageId == null ? UUID.randomUUID().toString() : this.messageId, this.contextId, this.taskId, this.referenceTaskIds, this.metadata, this.extensions);
        }
    }
}

