/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCardSignature;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.AgentProvider;
import io.a2a.spec.AgentSkill;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public record AgentCard(String name, String description, AgentProvider provider, String version, String documentationUrl, AgentCapabilities capabilities, List<String> defaultInputModes, List<String> defaultOutputModes, List<AgentSkill> skills, boolean supportsExtendedAgentCard, Map<String, SecurityScheme> securitySchemes, List<Map<String, List<String>>> security, String iconUrl, List<AgentInterface> supportedInterfaces, String protocolVersion, List<AgentCardSignature> signatures) {
    public static final String CURRENT_PROTOCOL_VERSION = "1.0";

    public AgentCard {
        Assert.checkNotNullParam((String)"capabilities", (Object)capabilities);
        Assert.checkNotNullParam((String)"defaultInputModes", defaultInputModes);
        Assert.checkNotNullParam((String)"defaultOutputModes", defaultOutputModes);
        Assert.checkNotNullParam((String)"description", (Object)description);
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"skills", skills);
        Assert.checkNotNullParam((String)"supportedInterfaces", supportedInterfaces);
        Assert.checkNotNullParam((String)"version", (Object)version);
        if (protocolVersion == null) {
            protocolVersion = CURRENT_PROTOCOL_VERSION;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AgentCard card) {
        return new Builder(card);
    }

    public static class Builder {
        private String name;
        private String description;
        private AgentProvider provider;
        private String version;
        private String documentationUrl;
        private AgentCapabilities capabilities;
        private List<String> defaultInputModes;
        private List<String> defaultOutputModes;
        private List<AgentSkill> skills;
        private boolean supportsExtendedAgentCard = false;
        private Map<String, SecurityScheme> securitySchemes;
        private List<Map<String, List<String>>> security;
        private String iconUrl;
        private List<AgentInterface> supportedInterfaces;
        private String protocolVersion;
        private List<AgentCardSignature> signatures;

        private Builder() {
        }

        private Builder(AgentCard card) {
            this.name = card.name;
            this.description = card.description;
            this.provider = card.provider;
            this.version = card.version;
            this.documentationUrl = card.documentationUrl;
            this.capabilities = card.capabilities;
            this.defaultInputModes = card.defaultInputModes != null ? new ArrayList<String>(card.defaultInputModes) : null;
            this.defaultOutputModes = card.defaultOutputModes != null ? new ArrayList<String>(card.defaultOutputModes) : null;
            this.skills = card.skills != null ? new ArrayList<AgentSkill>(card.skills) : null;
            this.supportsExtendedAgentCard = card.supportsExtendedAgentCard;
            this.securitySchemes = card.securitySchemes != null ? Map.copyOf(card.securitySchemes) : null;
            this.security = card.security != null ? new ArrayList<Map<String, List<String>>>(card.security) : null;
            this.iconUrl = card.iconUrl;
            this.supportedInterfaces = card.supportedInterfaces != null ? new ArrayList<AgentInterface>(card.supportedInterfaces) : null;
            this.protocolVersion = card.protocolVersion;
            this.signatures = card.signatures != null ? new ArrayList<AgentCardSignature>(card.signatures) : null;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder provider(AgentProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder capabilities(AgentCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder defaultInputModes(List<String> defaultInputModes) {
            this.defaultInputModes = defaultInputModes;
            return this;
        }

        public Builder defaultOutputModes(List<String> defaultOutputModes) {
            this.defaultOutputModes = defaultOutputModes;
            return this;
        }

        public Builder skills(List<AgentSkill> skills) {
            this.skills = skills;
            return this;
        }

        public Builder supportsExtendedAgentCard(boolean supportsExtendedAgentCard) {
            this.supportsExtendedAgentCard = supportsExtendedAgentCard;
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes = securitySchemes;
            return this;
        }

        public Builder security(List<Map<String, List<String>>> security) {
            this.security = security;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder supportedInterfaces(List<AgentInterface> supportedInterfaces) {
            this.supportedInterfaces = supportedInterfaces;
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder signatures(List<AgentCardSignature> signatures) {
            this.signatures = signatures;
            return this;
        }

        public AgentCard build() {
            return new AgentCard(this.name, this.description, this.provider, this.version, this.documentationUrl, this.capabilities, this.defaultInputModes, this.defaultOutputModes, this.skills, this.supportsExtendedAgentCard, this.securitySchemes, this.security, this.iconUrl, this.supportedInterfaces, this.protocolVersion, this.signatures);
        }
    }
}

