/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.a2a.spec.StreamingJSONRPCRequest;
import io.a2a.spec.TaskIdParams;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class TaskResubscriptionRequest
extends StreamingJSONRPCRequest<TaskIdParams> {
    public static final String METHOD = "tasks/resubscribe";

    @JsonCreator
    public TaskResubscriptionRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="method") String method, @JsonProperty(value="params") TaskIdParams params) {
        if (jsonrpc != null && !jsonrpc.equals("2.0")) {
            throw new IllegalArgumentException("Invalid JSON-RPC protocol version");
        }
        Assert.checkNotNullParam((String)"method", (Object)method);
        if (!method.equals(METHOD)) {
            throw new IllegalArgumentException("Invalid TaskResubscriptionRequest method");
        }
        Assert.checkNotNullParam((String)"params", (Object)params);
        this.jsonrpc = Utils.defaultIfNull(jsonrpc, "2.0");
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.method = method;
        this.params = params;
    }

    public TaskResubscriptionRequest(Object id, TaskIdParams params) {
        this((String)null, id, METHOD, params);
    }

    public static class Builder {
        private String jsonrpc;
        private Object id;
        private String method = "tasks/resubscribe";
        private TaskIdParams params;

        public Builder jsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
            return this;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder params(TaskIdParams params) {
            this.params = params;
            return this;
        }

        public TaskResubscriptionRequest build() {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            return new TaskResubscriptionRequest(this.jsonrpc, this.id, this.method, this.params);
        }
    }
}

