/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class APIKeySecurityScheme
implements SecurityScheme {
    public static final String API_KEY = "apiKey";
    private final String in;
    private final String name;
    private final String type;
    private final String description;

    public APIKeySecurityScheme(String in, String name, String description) {
        this(in, name, description, API_KEY);
    }

    @JsonCreator
    public APIKeySecurityScheme(@JsonProperty(value="in") String in, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="type") String type) {
        Assert.checkNotNullParam((String)"in", (Object)in);
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (!type.equals(API_KEY)) {
            throw new IllegalArgumentException("Invalid type for APIKeySecurityScheme");
        }
        this.in = in;
        this.name = name;
        this.description = description;
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private String in;
        private String name;
        private String description;

        public Builder in(String in) {
            this.in = in;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public APIKeySecurityScheme build() {
            return new APIKeySecurityScheme(this.in, this.name, this.description);
        }
    }

    public static enum Location {
        COOKIE("cookie"),
        HEADER("header"),
        QUERY("query");

        private final String location;

        private Location(String location) {
            this.location = location;
        }

        @JsonValue
        public String asString() {
            return this.location;
        }

        @JsonCreator
        public static Location fromString(String location) {
            switch (location) {
                case "cookie": {
                    return COOKIE;
                }
                case "header": {
                    return HEADER;
                }
                case "query": {
                    return QUERY;
                }
            }
            throw new IllegalArgumentException("Invalid API key location: " + location);
        }
    }
}

