/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class SendMessageRequest
extends NonStreamingJSONRPCRequest<MessageSendParams> {
    public static final String METHOD = "message/send";

    @JsonCreator
    public SendMessageRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="method") String method, @JsonProperty(value="params") MessageSendParams params) {
        if (jsonrpc == null || jsonrpc.isEmpty()) {
            throw new IllegalArgumentException("JSON-RPC protocol version cannot be null or empty");
        }
        if (jsonrpc != null && !jsonrpc.equals("2.0")) {
            throw new IllegalArgumentException("Invalid JSON-RPC protocol version");
        }
        Assert.checkNotNullParam((String)"method", (Object)method);
        if (!method.equals(METHOD)) {
            throw new IllegalArgumentException("Invalid SendMessageRequest method");
        }
        Assert.checkNotNullParam((String)"params", (Object)params);
        Assert.isNullOrStringOrInteger((Object)id);
        this.jsonrpc = Utils.defaultIfNull(jsonrpc, "2.0");
        this.id = id;
        this.method = method;
        this.params = params;
    }

    public SendMessageRequest(Object id, MessageSendParams params) {
        this("2.0", id, METHOD, params);
    }

    public static class Builder {
        private String jsonrpc;
        private Object id;
        private String method;
        private MessageSendParams params;

        public Builder jsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
            return this;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder params(MessageSendParams params) {
            this.params = params;
            return this;
        }

        public SendMessageRequest build() {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            return new SendMessageRequest(this.jsonrpc, this.id, this.method, this.params);
        }
    }
}

