/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.SecurityScheme;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.grpc.mapper.APIKeySecuritySchemeMapper;
import io.a2a.grpc.mapper.HTTPAuthSecuritySchemeMapper;
import io.a2a.grpc.mapper.MutualTLSSecuritySchemeMapper;
import io.a2a.grpc.mapper.OAuth2SecuritySchemeMapper;
import io.a2a.grpc.mapper.OpenIdConnectSecuritySchemeMapper;
import io.a2a.spec.APIKeySecurityScheme;
import io.a2a.spec.HTTPAuthSecurityScheme;
import io.a2a.spec.MutualTLSSecurityScheme;
import io.a2a.spec.OAuth2SecurityScheme;
import io.a2a.spec.OpenIdConnectSecurityScheme;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class, collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, uses={APIKeySecuritySchemeMapper.class, HTTPAuthSecuritySchemeMapper.class, OAuth2SecuritySchemeMapper.class, OpenIdConnectSecuritySchemeMapper.class, MutualTLSSecuritySchemeMapper.class})
public interface SecuritySchemeMapper {
    public static final SecuritySchemeMapper INSTANCE = A2AMappers.getMapper(SecuritySchemeMapper.class);

    default public SecurityScheme toProto(io.a2a.spec.SecurityScheme domain) {
        if (domain == null) {
            return null;
        }
        if (domain instanceof APIKeySecurityScheme) {
            APIKeySecurityScheme s = (APIKeySecurityScheme)domain;
            return SecurityScheme.newBuilder().setApiKeySecurityScheme(APIKeySecuritySchemeMapper.INSTANCE.toProto(s)).build();
        }
        if (domain instanceof HTTPAuthSecurityScheme) {
            HTTPAuthSecurityScheme s = (HTTPAuthSecurityScheme)domain;
            return SecurityScheme.newBuilder().setHttpAuthSecurityScheme(HTTPAuthSecuritySchemeMapper.INSTANCE.toProto(s)).build();
        }
        if (domain instanceof OAuth2SecurityScheme) {
            OAuth2SecurityScheme s = (OAuth2SecurityScheme)domain;
            return SecurityScheme.newBuilder().setOauth2SecurityScheme(OAuth2SecuritySchemeMapper.INSTANCE.toProto(s)).build();
        }
        if (domain instanceof OpenIdConnectSecurityScheme) {
            OpenIdConnectSecurityScheme s = (OpenIdConnectSecurityScheme)domain;
            return SecurityScheme.newBuilder().setOpenIdConnectSecurityScheme(OpenIdConnectSecuritySchemeMapper.INSTANCE.toProto(s)).build();
        }
        if (domain instanceof MutualTLSSecurityScheme) {
            MutualTLSSecurityScheme s = (MutualTLSSecurityScheme)domain;
            return SecurityScheme.newBuilder().setMtlsSecurityScheme(MutualTLSSecuritySchemeMapper.INSTANCE.toProto(s)).build();
        }
        throw new IllegalArgumentException("Unknown SecurityScheme type: " + String.valueOf(domain.getClass()));
    }

    default public io.a2a.spec.SecurityScheme fromProto(SecurityScheme proto) {
        if (proto == null) {
            return null;
        }
        return switch (proto.getSchemeCase()) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityScheme.SchemeCase.API_KEY_SECURITY_SCHEME -> APIKeySecuritySchemeMapper.INSTANCE.fromProto(proto.getApiKeySecurityScheme());
            case SecurityScheme.SchemeCase.HTTP_AUTH_SECURITY_SCHEME -> HTTPAuthSecuritySchemeMapper.INSTANCE.fromProto(proto.getHttpAuthSecurityScheme());
            case SecurityScheme.SchemeCase.OAUTH2_SECURITY_SCHEME -> OAuth2SecuritySchemeMapper.INSTANCE.fromProto(proto.getOauth2SecurityScheme());
            case SecurityScheme.SchemeCase.OPEN_ID_CONNECT_SECURITY_SCHEME -> OpenIdConnectSecuritySchemeMapper.INSTANCE.fromProto(proto.getOpenIdConnectSecurityScheme());
            case SecurityScheme.SchemeCase.MTLS_SECURITY_SCHEME -> MutualTLSSecuritySchemeMapper.INSTANCE.fromProto(proto.getMtlsSecurityScheme());
            case SecurityScheme.SchemeCase.SCHEME_NOT_SET -> throw new IllegalArgumentException("SecurityScheme oneof field not set");
        };
    }
}

