/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import io.a2a.spec.APIKeySecurityScheme;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.MapperConfig;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.ReportingPolicy;

@MapperConfig(unmappedTargetPolicy=ReportingPolicy.ERROR, componentModel="default", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
public interface A2AProtoMapperConfig {
    default public String map(APIKeySecurityScheme.Location location) {
        return location == null ? null : location.asString();
    }

    default public Instant map(Timestamp value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochSecond(value.getSeconds(), value.getNanos());
    }

    default public Timestamp map(Instant value) {
        if (value == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(value.getEpochSecond()).setNanos(value.getNano()).build();
    }

    default public java.time.Duration map(Duration value) {
        if (value == null) {
            return null;
        }
        return java.time.Duration.ofSeconds(value.getSeconds(), value.getNanos());
    }

    default public Duration map(java.time.Duration value) {
        if (value == null) {
            return null;
        }
        return Duration.newBuilder().setSeconds(value.getSeconds()).setNanos(value.getNano()).build();
    }

    default public byte[] map(ByteString value) {
        return value == null ? null : value.toByteArray();
    }

    default public ByteString map(byte[] value) {
        return value == null ? null : ByteString.copyFrom((byte[])value);
    }

    default public ByteBuffer mapToBuffer(ByteString value) {
        return value == null ? null : value.asReadOnlyByteBuffer();
    }

    default public ByteString mapFromBuffer(ByteBuffer value) {
        return value == null ? null : ByteString.copyFrom((ByteBuffer)value);
    }

    default public String map(StringValue value) {
        return value == null ? null : value.getValue();
    }

    default public StringValue mapString(String value) {
        return value == null ? null : StringValue.of((String)value);
    }

    default public Integer map(Int32Value value) {
        return value == null ? null : Integer.valueOf(value.getValue());
    }

    default public Int32Value mapInt(Integer value) {
        return value == null ? null : Int32Value.of((int)value);
    }

    default public Long map(Int64Value value) {
        return value == null ? null : Long.valueOf(value.getValue());
    }

    default public Int64Value mapLong(Long value) {
        return value == null ? null : Int64Value.of((long)value);
    }

    default public Boolean map(BoolValue value) {
        return value == null ? null : Boolean.valueOf(value.getValue());
    }

    default public BoolValue mapBool(Boolean value) {
        return value == null ? null : BoolValue.of((boolean)value);
    }

    default public Map<String, Object> map(Struct struct) {
        if (struct == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
            map.put((String)entry.getKey(), this.map((Value)entry.getValue()));
        }
        return map;
    }

    default public Struct mapStruct(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Struct.Builder builder = Struct.newBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.putFields(entry.getKey(), this.mapValue(entry.getValue()));
        }
        return builder.build();
    }

    default public Object map(Value value) {
        if (value == null) {
            return null;
        }
        switch (value.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case STRUCT_VALUE: {
                return this.map(value.getStructValue());
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().map(this::map).collect(Collectors.toList());
            }
        }
        return null;
    }

    default public Value mapValue(Object object) {
        if (object == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (object instanceof String) {
            return Value.newBuilder().setStringValue((String)object).build();
        }
        if (object instanceof Boolean) {
            return Value.newBuilder().setBoolValue(((Boolean)object).booleanValue()).build();
        }
        if (object instanceof Number) {
            return Value.newBuilder().setNumberValue(((Number)object).doubleValue()).build();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return Value.newBuilder().setStructValue(this.mapStruct(map)).build();
        }
        if (object instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : (List)object) {
                listBuilder.addValues(this.mapValue(item));
            }
            return Value.newBuilder().setListValue(listBuilder).build();
        }
        throw new IllegalArgumentException("Unsupported type for Proto Value conversion: " + object.getClass().getName());
    }
}

