/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import com.google.protobuf.ByteString;
import com.google.protobuf.Value;
import io.a2a.grpc.Part;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.spec.DataPart;
import io.a2a.spec.FileContent;
import io.a2a.spec.FilePart;
import io.a2a.spec.FileWithBytes;
import io.a2a.spec.FileWithUri;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.TextPart;
import java.util.Base64;
import org.mapstruct.Mapper;

@Mapper(config=A2AProtoMapperConfig.class, uses={A2ACommonFieldMapper.class})
public interface PartMapper {
    public static final PartMapper INSTANCE = A2AMappers.getMapper(PartMapper.class);

    default public Part toProto(io.a2a.spec.Part<?> domain) {
        if (domain == null) {
            return null;
        }
        Part.Builder builder = Part.newBuilder();
        if (domain instanceof TextPart) {
            TextPart textPart = (TextPart)domain;
            builder.setText(textPart.text());
        } else if (domain instanceof FilePart) {
            FilePart filePart = (FilePart)domain;
            FileContent fileContent = filePart.file();
            if (fileContent instanceof FileWithBytes) {
                FileWithBytes fileWithBytes = (FileWithBytes)fileContent;
                builder.setRaw(ByteString.copyFrom((byte[])Base64.getDecoder().decode(fileWithBytes.bytes())));
                if (fileWithBytes.name() != null) {
                    builder.setFilename(fileWithBytes.name());
                }
                if (fileWithBytes.mimeType() != null) {
                    builder.setMediaType(fileWithBytes.mimeType());
                }
            } else if (fileContent instanceof FileWithUri) {
                FileWithUri fileWithUri = (FileWithUri)fileContent;
                builder.setUrl(fileWithUri.uri());
                if (fileWithUri.name() != null) {
                    builder.setFilename(fileWithUri.name());
                }
                if (fileWithUri.mimeType() != null) {
                    builder.setMediaType(fileWithUri.mimeType());
                }
            }
        } else if (domain instanceof DataPart) {
            DataPart dataPart = (DataPart)domain;
            Value dataValue = A2ACommonFieldMapper.INSTANCE.objectToValue(dataPart.data());
            builder.setData(dataValue);
        }
        return builder.build();
    }

    default public io.a2a.spec.Part<?> fromProto(Part proto) {
        if (proto == null) {
            return null;
        }
        if (proto.hasText()) {
            return new TextPart(proto.getText());
        }
        if (proto.hasRaw()) {
            String bytes = Base64.getEncoder().encodeToString(proto.getRaw().toByteArray());
            String mimeType = proto.getMediaType().isEmpty() ? null : proto.getMediaType();
            String name = proto.getFilename().isEmpty() ? null : proto.getFilename();
            return new FilePart((FileContent)new FileWithBytes(mimeType, name, bytes));
        }
        if (proto.hasUrl()) {
            String uri = proto.getUrl();
            String mimeType = proto.getMediaType().isEmpty() ? null : proto.getMediaType();
            String name = proto.getFilename().isEmpty() ? null : proto.getFilename();
            return new FilePart((FileContent)new FileWithUri(mimeType, name, uri));
        }
        if (proto.hasData()) {
            Value dataValue = proto.getData();
            Object data = A2ACommonFieldMapper.INSTANCE.valueToObject(dataValue);
            return new DataPart(data);
        }
        throw new InvalidRequestError();
    }
}

