/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.TaskStatus;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.MessageMapper;
import io.a2a.grpc.mapper.TaskStateMapper;
import io.a2a.grpc.mapper.TaskStatusMapper;
import io.a2a.spec.Message;
import io.a2a.spec.TaskState;
import java.time.OffsetDateTime;

public class TaskStatusMapperImpl
implements TaskStatusMapper {
    private final TaskStateMapper taskStateMapper = TaskStateMapper.INSTANCE;
    private final MessageMapper messageMapper = MessageMapper.INSTANCE;
    private final A2ACommonFieldMapper a2ACommonFieldMapper = A2ACommonFieldMapper.INSTANCE;

    @Override
    public TaskStatus toProto(io.a2a.spec.TaskStatus domain) {
        if (domain == null) {
            return null;
        }
        TaskStatus.Builder taskStatus = TaskStatus.newBuilder();
        if (domain.state() != null) {
            taskStatus.setState(this.taskStateMapper.toProto(domain.state()));
        }
        if (domain.message() != null) {
            taskStatus.setMessage(this.messageMapper.toProto(domain.message()));
        }
        taskStatus.setTimestamp(this.a2ACommonFieldMapper.offsetDateTimeToProtoTimestamp(domain.timestamp()));
        return taskStatus.build();
    }

    @Override
    public io.a2a.spec.TaskStatus fromProto(TaskStatus proto) {
        if (proto == null) {
            return null;
        }
        OffsetDateTime timestamp = null;
        TaskState state = null;
        Message message = null;
        if (proto.hasTimestamp()) {
            timestamp = this.a2ACommonFieldMapper.protoTimestampToOffsetDateTime(proto.getTimestamp());
        }
        state = this.taskStateMapper.fromProto(proto.getState());
        if (proto.hasMessage()) {
            message = this.messageMapper.fromProto(proto.getMessage());
        }
        io.a2a.spec.TaskStatus taskStatus = new io.a2a.spec.TaskStatus(state, message, timestamp);
        return taskStatus;
    }
}

