/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.mapper.ResourceNameParser;
import io.a2a.grpc.mapper.TaskQueryParamsMapper;
import io.a2a.spec.TaskQueryParams;

public class TaskQueryParamsMapperImpl
implements TaskQueryParamsMapper {
    @Override
    public TaskQueryParams fromProto(GetTaskRequest proto) {
        if (proto == null) {
            return null;
        }
        Integer historyLength = null;
        String tenant = null;
        if (proto.hasHistoryLength()) {
            historyLength = proto.getHistoryLength();
        }
        tenant = proto.getTenant();
        String id = ResourceNameParser.extractTaskId(proto.getName());
        TaskQueryParams taskQueryParams = new TaskQueryParams(id, historyLength, tenant);
        return taskQueryParams;
    }

    @Override
    public GetTaskRequest toProto(TaskQueryParams domain) {
        if (domain == null) {
            return null;
        }
        GetTaskRequest.Builder getTaskRequest = GetTaskRequest.newBuilder();
        if (domain.historyLength() != null) {
            getTaskRequest.setHistoryLength(domain.historyLength());
        }
        getTaskRequest.setTenant(domain.tenant());
        getTaskRequest.setName(ResourceNameParser.defineTaskName(domain.id()));
        return getTaskRequest.build();
    }
}

