/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.PushNotificationConfig;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.mapper.A2AMappers;
import io.a2a.grpc.mapper.A2AProtoMapperConfig;
import io.a2a.grpc.mapper.PushNotificationConfigMapper;
import io.a2a.grpc.mapper.ResourceNameParser;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(config=A2AProtoMapperConfig.class, uses={PushNotificationConfigMapper.class})
public interface TaskPushNotificationConfigMapper {
    public static final TaskPushNotificationConfigMapper INSTANCE = A2AMappers.getMapper(TaskPushNotificationConfigMapper.class);

    @Mappings(value={@Mapping(target="name", expression="java(buildResourceName(config))"), @Mapping(target="pushNotificationConfig", source="pushNotificationConfig")})
    public TaskPushNotificationConfig toProto(io.a2a.spec.TaskPushNotificationConfig var1);

    @Mappings(value={@Mapping(target="taskId", expression="java(extractTaskId(proto))"), @Mapping(target="pushNotificationConfig", expression="java(mapPushNotificationConfigWithId(proto))"), @Mapping(target="tenant", expression="java(null)")})
    public io.a2a.spec.TaskPushNotificationConfig fromProto(TaskPushNotificationConfig var1);

    default public String buildResourceName(io.a2a.spec.TaskPushNotificationConfig config) {
        String taskId = config.taskId();
        String configId = config.pushNotificationConfig().id();
        if (configId == null || configId.isEmpty()) {
            return "tasks/" + taskId + "/pushNotificationConfigs";
        }
        return "tasks/" + taskId + "/pushNotificationConfigs/" + configId;
    }

    default public String extractTaskId(TaskPushNotificationConfig proto) {
        String[] parts = ResourceNameParser.parseTaskPushNotificationConfigName(proto.getName());
        return parts[0];
    }

    default public io.a2a.spec.PushNotificationConfig mapPushNotificationConfigWithId(TaskPushNotificationConfig proto) {
        String[] parts = ResourceNameParser.parseTaskPushNotificationConfigName(proto.getName());
        String configId = parts[1];
        if (!proto.hasPushNotificationConfig() || proto.getPushNotificationConfig().equals(PushNotificationConfig.getDefaultInstance())) {
            return null;
        }
        io.a2a.spec.PushNotificationConfig result = PushNotificationConfigMapper.INSTANCE.fromProto(proto.getPushNotificationConfig());
        if (configId != null && !configId.isEmpty() && !configId.equals(result.id())) {
            return new io.a2a.spec.PushNotificationConfig(result.url(), result.token(), result.authentication(), configId);
        }
        return result;
    }
}

