/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.Artifact;
import io.a2a.grpc.Message;
import io.a2a.grpc.Task;
import io.a2a.grpc.mapper.A2ACommonFieldMapper;
import io.a2a.grpc.mapper.ArtifactMapper;
import io.a2a.grpc.mapper.MessageMapper;
import io.a2a.grpc.mapper.TaskMapper;
import io.a2a.grpc.mapper.TaskStatusMapper;
import io.a2a.spec.Task;
import java.util.ArrayList;
import java.util.List;

public class TaskMapperImpl
implements TaskMapper {
    private final TaskStatusMapper taskStatusMapper = TaskStatusMapper.INSTANCE;
    private final ArtifactMapper artifactMapper = ArtifactMapper.INSTANCE;
    private final MessageMapper messageMapper = MessageMapper.INSTANCE;
    private final A2ACommonFieldMapper a2ACommonFieldMapper = A2ACommonFieldMapper.INSTANCE;

    @Override
    public Task toProto(io.a2a.spec.Task domain) {
        if (domain == null) {
            return null;
        }
        Task.Builder task = Task.newBuilder();
        if (domain.id() != null) {
            task.setId(domain.id());
        }
        if (domain.contextId() != null) {
            task.setContextId(domain.contextId());
        }
        task.setMetadata(this.a2ACommonFieldMapper.metadataToProto(domain.metadata()));
        task.setStatus(this.taskStatusMapper.toProto(domain.status()));
        if (domain.artifacts() != null) {
            for (io.a2a.spec.Artifact artifact : domain.artifacts()) {
                task.addArtifacts(this.artifactMapper.toProto(artifact));
            }
        }
        if (domain.history() != null) {
            for (io.a2a.spec.Message history : domain.history()) {
                task.addHistory(this.messageMapper.toProto(history));
            }
        }
        return task.build();
    }

    @Override
    public io.a2a.spec.Task fromProto(Task proto) {
        if (proto == null) {
            return null;
        }
        Task.Builder task = io.a2a.spec.Task.builder();
        task.id(this.a2ACommonFieldMapper.emptyToNull(proto.getId()));
        task.contextId(this.a2ACommonFieldMapper.emptyToNull(proto.getContextId()));
        if (proto.hasMetadata()) {
            task.metadata(this.a2ACommonFieldMapper.metadataFromProto(proto.getMetadata()));
        }
        if (proto.hasStatus()) {
            task.status(this.taskStatusMapper.fromProto(proto.getStatus()));
        }
        task.artifacts(this.artifactListToArtifactList(proto.getArtifactsList()));
        task.history(this.messageListToMessageArray(proto.getHistoryList()));
        return task.build();
    }

    protected List<io.a2a.spec.Artifact> artifactListToArtifactList(List<Artifact> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.a2a.spec.Artifact> list1 = new ArrayList<io.a2a.spec.Artifact>(list.size());
        for (Artifact artifact : list) {
            list1.add(this.artifactMapper.fromProto(artifact));
        }
        return list1;
    }

    protected io.a2a.spec.Message[] messageListToMessageArray(List<Message> list) {
        if (list == null) {
            return null;
        }
        io.a2a.spec.Message[] messageTmp = new io.a2a.spec.Message[list.size()];
        int i = 0;
        for (Message message : list) {
            messageTmp[i] = this.messageMapper.fromProto(message);
            ++i;
        }
        return messageTmp;
    }
}

