/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.grpc.mapper;

import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.SubscribeToTaskRequest;
import io.a2a.grpc.mapper.ResourceNameParser;
import io.a2a.grpc.mapper.TaskIdParamsMapper;
import io.a2a.spec.TaskIdParams;

public class TaskIdParamsMapperImpl
implements TaskIdParamsMapper {
    @Override
    public TaskIdParams fromProtoCancelTaskRequest(CancelTaskRequest proto) {
        if (proto == null) {
            return null;
        }
        String tenant = null;
        tenant = proto.getTenant();
        String id = ResourceNameParser.extractTaskId(proto.getName());
        TaskIdParams taskIdParams = new TaskIdParams(id, tenant);
        return taskIdParams;
    }

    @Override
    public CancelTaskRequest toProtoCancelTaskRequest(TaskIdParams domain) {
        if (domain == null) {
            return null;
        }
        CancelTaskRequest.Builder cancelTaskRequest = CancelTaskRequest.newBuilder();
        cancelTaskRequest.setTenant(domain.tenant());
        cancelTaskRequest.setName(ResourceNameParser.defineTaskName(domain.id()));
        return cancelTaskRequest.build();
    }

    @Override
    public TaskIdParams fromProtoSubscribeToTaskRequest(SubscribeToTaskRequest proto) {
        if (proto == null) {
            return null;
        }
        String tenant = null;
        tenant = proto.getTenant();
        String id = ResourceNameParser.extractTaskId(proto.getName());
        TaskIdParams taskIdParams = new TaskIdParams(id, tenant);
        return taskIdParams;
    }

    @Override
    public SubscribeToTaskRequest toProtoSubscribeToTaskRequest(TaskIdParams domain) {
        if (domain == null) {
            return null;
        }
        SubscribeToTaskRequest.Builder subscribeToTaskRequest = SubscribeToTaskRequest.newBuilder();
        subscribeToTaskRequest.setTenant(domain.tenant());
        subscribeToTaskRequest.setName(ResourceNameParser.defineTaskName(domain.id()));
        return subscribeToTaskRequest.build();
    }
}

