/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.util.sse;

import com.google.protobuf.Empty;
import com.google.protobuf.MessageOrBuilder;
import io.a2a.grpc.utils.JSONRPCUtils;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.wrappers.A2AErrorResponse;
import io.a2a.jsonrpc.common.wrappers.A2AResponse;
import io.a2a.jsonrpc.common.wrappers.CancelTaskResponse;
import io.a2a.jsonrpc.common.wrappers.CreateTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetExtendedAgentCardResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskResponse;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.jsonrpc.common.wrappers.SendMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageResponse;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.EventKind;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskPushNotificationConfig;

public class SseFormatter {
    private SseFormatter() {
    }

    public static String formatResponseAsSSE(A2AResponse<?> response, long eventId) {
        String jsonData = SseFormatter.serializeResponse(response);
        return "data: " + jsonData + "\nid: " + eventId + "\n\n";
    }

    public static String formatJsonAsSSE(String jsonString, long eventId) {
        return "data: " + jsonString + "\nid: " + eventId + "\n\n";
    }

    private static String serializeResponse(A2AResponse<?> response) {
        if (response instanceof A2AErrorResponse) {
            A2AErrorResponse error = (A2AErrorResponse)response;
            return JSONRPCUtils.toJsonRPCErrorResponse((Object)error.getId(), (A2AError)error.getError());
        }
        if (response.getError() != null) {
            return JSONRPCUtils.toJsonRPCErrorResponse((Object)response.getId(), (A2AError)response.getError());
        }
        MessageOrBuilder protoMessage = SseFormatter.convertToProto(response);
        return JSONRPCUtils.toJsonRPCResultResponse((Object)response.getId(), (MessageOrBuilder)protoMessage);
    }

    private static MessageOrBuilder convertToProto(A2AResponse<?> response) {
        if (response instanceof GetTaskResponse) {
            GetTaskResponse r = (GetTaskResponse)response;
            return ProtoUtils.ToProto.task((Task)((Task)r.getResult()));
        }
        if (response instanceof CancelTaskResponse) {
            CancelTaskResponse r = (CancelTaskResponse)response;
            return ProtoUtils.ToProto.task((Task)((Task)r.getResult()));
        }
        if (response instanceof SendMessageResponse) {
            SendMessageResponse r = (SendMessageResponse)response;
            return ProtoUtils.ToProto.taskOrMessage((EventKind)((EventKind)r.getResult()));
        }
        if (response instanceof ListTasksResponse) {
            ListTasksResponse r = (ListTasksResponse)response;
            return ProtoUtils.ToProto.listTasksResult((ListTasksResult)((ListTasksResult)r.getResult()));
        }
        if (response instanceof CreateTaskPushNotificationConfigResponse) {
            CreateTaskPushNotificationConfigResponse r = (CreateTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.createTaskPushNotificationConfigResponse((TaskPushNotificationConfig)((TaskPushNotificationConfig)r.getResult()));
        }
        if (response instanceof GetTaskPushNotificationConfigResponse) {
            GetTaskPushNotificationConfigResponse r = (GetTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.getTaskPushNotificationConfigResponse((TaskPushNotificationConfig)((TaskPushNotificationConfig)r.getResult()));
        }
        if (response instanceof ListTaskPushNotificationConfigResponse) {
            ListTaskPushNotificationConfigResponse r = (ListTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.listTaskPushNotificationConfigResponse((ListTaskPushNotificationConfigResult)((ListTaskPushNotificationConfigResult)r.getResult()));
        }
        if (response instanceof DeleteTaskPushNotificationConfigResponse) {
            return Empty.getDefaultInstance();
        }
        if (response instanceof GetExtendedAgentCardResponse) {
            GetExtendedAgentCardResponse r = (GetExtendedAgentCardResponse)response;
            return ProtoUtils.ToProto.getExtendedCardResponse((AgentCard)((AgentCard)r.getResult()));
        }
        if (response instanceof SendStreamingMessageResponse) {
            SendStreamingMessageResponse r = (SendStreamingMessageResponse)response;
            return ProtoUtils.ToProto.taskOrMessageStream((StreamingEventKind)((StreamingEventKind)r.getResult()));
        }
        throw new IllegalArgumentException("Unknown response type: " + response.getClass().getName());
    }
}

