/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.A2AError;
import io.a2a.spec.A2AServerException;
import io.a2a.spec.Event;
import io.a2a.spec.InternalError;
import io.a2a.spec.Message;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    private volatile @Nullable String taskId;
    private volatile @Nullable String contextId;
    private final TaskStore taskStore;
    private final @Nullable Message initialMessage;
    private volatile @Nullable Task currentTask;

    public TaskManager(@Nullable String taskId, @Nullable String contextId, TaskStore taskStore, @Nullable Message initialMessage) {
        Assert.checkNotNullParam((String)"taskStore", (Object)taskStore);
        this.taskId = taskId;
        this.contextId = contextId;
        this.taskStore = taskStore;
        this.initialMessage = initialMessage;
    }

    @Nullable String getTaskId() {
        return this.taskId;
    }

    @Nullable String getContextId() {
        return this.contextId;
    }

    public @Nullable Task getTask() {
        if (this.taskId == null) {
            return null;
        }
        if (this.currentTask != null) {
            return this.currentTask;
        }
        this.currentTask = this.taskStore.get(this.taskId);
        return this.currentTask;
    }

    boolean saveTaskEvent(Task task, boolean isReplicated) throws A2AServerException {
        this.checkIdsAndUpdateIfNecessary(task.id(), task.contextId());
        Task savedTask = this.saveTask(task, isReplicated);
        return savedTask.status() != null && savedTask.status().state() != null && savedTask.status().state().isFinal();
    }

    boolean saveTaskEvent(TaskStatusUpdateEvent event, boolean isReplicated) throws A2AServerException {
        Task savedTask;
        this.checkIdsAndUpdateIfNecessary(event.taskId(), event.contextId());
        Task task = this.ensureTask(event.taskId(), event.contextId());
        Task.Builder builder = Task.builder((Task)task).status(event.status());
        if (task.status().message() != null) {
            ArrayList<Message> newHistory = task.history() == null ? new ArrayList<Message>() : new ArrayList(task.history());
            newHistory.add(task.status().message());
            builder.history(newHistory);
        }
        if (event.metadata() != null) {
            HashMap metadata = task.metadata() == null ? new HashMap() : new HashMap(task.metadata());
            metadata.putAll(event.metadata());
            builder.metadata(metadata);
        }
        return (savedTask = this.saveTask(task = builder.build(), isReplicated)).status() != null && savedTask.status().state() != null && savedTask.status().state().isFinal();
    }

    boolean saveTaskEvent(TaskArtifactUpdateEvent event, boolean isReplicated) throws A2AServerException {
        this.checkIdsAndUpdateIfNecessary(event.taskId(), event.contextId());
        Task task = this.ensureTask(event.taskId(), event.contextId());
        String nonNullTaskId = this.taskId;
        if (nonNullTaskId == null) {
            throw new IllegalStateException("taskId should not be null after checkIdsAndUpdateIfNecessary");
        }
        Task savedTask = this.saveTask(task = Utils.appendArtifactToTask((Task)task, (TaskArtifactUpdateEvent)event, (String)nonNullTaskId), isReplicated);
        return savedTask.status() != null && savedTask.status().state() != null && savedTask.status().state().isFinal();
    }

    public boolean process(Event event, boolean isReplicated) throws A2AServerException {
        boolean isFinal = false;
        if (event instanceof Task) {
            Task task = (Task)event;
            isFinal = this.saveTaskEvent(task, isReplicated);
        } else if (event instanceof TaskStatusUpdateEvent) {
            TaskStatusUpdateEvent taskStatusUpdateEvent = (TaskStatusUpdateEvent)event;
            isFinal = this.saveTaskEvent(taskStatusUpdateEvent, isReplicated);
        } else if (event instanceof TaskArtifactUpdateEvent) {
            TaskArtifactUpdateEvent taskArtifactUpdateEvent = (TaskArtifactUpdateEvent)event;
            isFinal = this.saveTaskEvent(taskArtifactUpdateEvent, isReplicated);
        } else if (event instanceof A2AError) {
            Task existingTask;
            if (this.taskId == null) {
                LOGGER.debug("A2AError event without task context - skipping state update");
                return true;
            }
            String errorContextId = this.contextId;
            if (errorContextId == null && (existingTask = this.getTask()) != null) {
                errorContextId = existingTask.contextId();
            }
            if (errorContextId != null) {
                LOGGER.debug("A2AError event detected, transitioning task {} to FAILED", (Object)this.taskId);
                TaskStatusUpdateEvent failedEvent = TaskStatusUpdateEvent.builder().taskId(this.taskId).contextId(errorContextId).status(new TaskStatus(TaskState.TASK_STATE_FAILED)).build();
                isFinal = this.saveTaskEvent(failedEvent, isReplicated);
            } else {
                LOGGER.debug("A2AError event for task {} without contextId - skipping state update", (Object)this.taskId);
                isFinal = true;
            }
        }
        return isFinal;
    }

    public Task updateWithMessage(Message message, Task task) {
        ArrayList<Message> history = new ArrayList<Message>(task.history());
        TaskStatus status = task.status();
        if (status.message() != null) {
            history.add(status.message());
            status = new TaskStatus(status.state(), null, status.timestamp());
        }
        history.add(message);
        task = Task.builder((Task)task).status(status).history(history).build();
        this.saveTask(task, false);
        return task;
    }

    private void checkIdsAndUpdateIfNecessary(String eventTaskId, String eventContextId) throws A2AServerException {
        if (this.taskId != null && !eventTaskId.equals(this.taskId)) {
            throw new A2AServerException("Invalid task id", (Throwable)new InternalError(String.format("Task event has taskId %s but TaskManager has %s", eventTaskId, this.taskId)));
        }
        if (this.taskId == null) {
            this.taskId = eventTaskId;
        }
        if (this.contextId == null) {
            this.contextId = eventContextId;
        }
    }

    private Task ensureTask(String eventTaskId, String eventContextId) {
        Task task = this.currentTask;
        if (task != null) {
            return task;
        }
        String currentTaskId = this.taskId;
        if (currentTaskId != null) {
            task = this.taskStore.get(currentTaskId);
        }
        if (task == null) {
            task = this.createTask(eventTaskId, eventContextId);
            this.saveTask(task, false);
        }
        return task;
    }

    private Task createTask(String taskId, String contextId) {
        List history = this.initialMessage != null ? List.of(this.initialMessage) : Collections.emptyList();
        return Task.builder().id(taskId).contextId(contextId).status(new TaskStatus(TaskState.TASK_STATE_SUBMITTED)).history(history).build();
    }

    private Task saveTask(Task task, boolean isReplicated) {
        this.taskStore.save(task, isReplicated);
        if (this.taskId == null) {
            this.taskId = task.id();
            this.contextId = task.contextId();
        }
        this.currentTask = task;
        return this.currentTask;
    }
}

